/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.cache.query.IndexQueryCriterion;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteExperimental;
import org.jetbrains.annotations.Nullable;

@IgniteExperimental
public final class IndexQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    private static final long serialVersionUID = 0L;
    private final String valType;
    @Nullable
    private final String idxName;
    @Nullable
    private List<IndexQueryCriterion> criteria;
    private IgniteBiPredicate<K, V> filter;

    public IndexQuery(Class<?> valCls) {
        this(valCls, null);
    }

    public IndexQuery(String valType) {
        this(valType, null);
    }

    public IndexQuery(Class<?> valCls, @Nullable String idxName) {
        this(valCls.getName(), idxName);
    }

    public IndexQuery(String valType, @Nullable String idxName) {
        A.notEmpty(valType, "valType");
        A.nullableNotEmpty(idxName, "idxName");
        this.valType = valType;
        this.idxName = idxName;
    }

    public IndexQuery<K, V> setCriteria(IndexQueryCriterion ... criteria) {
        this.validateAndSetCriteria(Arrays.asList(criteria));
        return this;
    }

    public IndexQuery<K, V> setCriteria(List<IndexQueryCriterion> criteria) {
        this.validateAndSetCriteria(new ArrayList<IndexQueryCriterion>(criteria));
        return this;
    }

    public List<IndexQueryCriterion> getCriteria() {
        return this.criteria;
    }

    public String getValueType() {
        return this.valType;
    }

    public String getIndexName() {
        return this.idxName;
    }

    public IndexQuery<K, V> setFilter(IgniteBiPredicate<K, V> filter) {
        A.notNull(filter, "filter");
        this.filter = filter;
        return this;
    }

    public IgniteBiPredicate<K, V> getFilter() {
        return this.filter;
    }

    private void validateAndSetCriteria(List<IndexQueryCriterion> criteria) {
        if (F.isEmpty(criteria)) {
            return;
        }
        Class<?> critCls = criteria.get(0).getClass();
        for (IndexQueryCriterion c : criteria) {
            A.notNull(c, "criteria");
            A.ensure(c.getClass() == critCls, "Expect a the same criteria class for merging criteria. Exp=" + critCls + ", act=" + c.getClass());
        }
        this.criteria = Collections.unmodifiableList(criteria);
    }
}

