/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ShortIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class ShortInlineIndexKeyType
extends NullableInlineIndexKeyType<ShortIndexKey> {
    public ShortInlineIndexKeyType() {
        super(3, (short)2);
    }

    @Override
    public int compare0(long pageAddr, int off, ShortIndexKey key) {
        short val1 = PageUtils.getShort(pageAddr, off + 1);
        return Integer.signum(val1 - (Short)key.key());
    }

    @Override
    protected int put0(long pageAddr, int off, ShortIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putShort(pageAddr, off + 1, (Short)key.key());
        return this.keySize + 1;
    }

    @Override
    protected ShortIndexKey get0(long pageAddr, int off) {
        short key = PageUtils.getShort(pageAddr, off + 1);
        return new ShortIndexKey(key);
    }

    @Override
    protected int inlineSize0(ShortIndexKey key) {
        return this.keySize + 1;
    }
}

