/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;

public class CdcConsumerState {
    public static final String STATE_FILE_NAME = "cdc-state.bin";
    private final Path state;
    private final Path tmp;

    public CdcConsumerState(Path stateDir) {
        this.state = stateDir.resolve(STATE_FILE_NAME);
        this.tmp = stateDir.resolve("cdc-state.bin.tmp");
    }

    public void save(WALPointer ptr) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putLong(ptr.index());
        buf.putInt(ptr.fileOffset());
        buf.putInt(ptr.length());
        buf.flip();
        try (FileChannel ch = FileChannel.open(this.tmp, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ch.write(buf);
            ch.force(true);
        }
        Files.move(this.tmp, this.state, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WALPointer load() {
        if (!Files.exists(this.state, new LinkOption[0])) {
            return null;
        }
        try (FileChannel ch = FileChannel.open(this.state, StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(16);
            ch.read(buf);
            buf.flip();
            long idx = buf.getLong();
            int offset = buf.getInt();
            int length = buf.getInt();
            WALPointer wALPointer = new WALPointer(idx, offset, length);
            return wALPointer;
        }
        catch (IOException e) {
            throw new IgniteException("Failed to read state [file=" + this.state + ']', e);
        }
    }
}

