/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.lang.management.ManagementFactory;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.FileLockHolder;

public class CdcFileLockHolder
extends FileLockHolder {
    private final String consumerId;

    public CdcFileLockHolder(String rootDir, String consumerId, IgniteLogger log) {
        super(rootDir, log);
        this.consumerId = consumerId;
    }

    @Override
    public String lockInfo() {
        return "[consumerId=" + this.consumerId + ", proc=" + ManagementFactory.getRuntimeMXBean().getName() + ']';
    }

    @Override
    protected String warningMessage(String lockInfo) {
        return "Failed to acquire file lock. Will try again in 1s [proc=" + ManagementFactory.getRuntimeMXBean().getName() + ", holder=" + lockInfo + ", path=" + this.lockPath() + ']';
    }
}

