/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;

class ClientBinary
implements IgniteBinary {
    private final ClientBinaryMarshaller marsh;

    ClientBinary(ClientBinaryMarshaller marsh) {
        this.marsh = marsh;
    }

    @Override
    public int typeId(String typeName) {
        return this.marsh.context().typeId(typeName);
    }

    @Override
    public <T> T toBinary(Object obj) {
        if (obj == null) {
            return null;
        }
        if (BinaryUtils.isBinaryType(obj.getClass())) {
            return (T)obj;
        }
        byte[] objBytes = this.marsh.marshal(obj);
        return this.marsh.unmarshal(new BinaryHeapInputStream(objBytes));
    }

    @Override
    public BinaryObjectBuilder builder(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName");
        }
        return new BinaryObjectBuilderImpl(this.marsh.context(), typeName);
    }

    @Override
    public BinaryObjectBuilder builder(BinaryObject binaryObj) {
        if (binaryObj == null) {
            throw new NullPointerException("binaryObj");
        }
        return BinaryObjectBuilderImpl.wrap(binaryObj);
    }

    @Override
    public BinaryType type(Class<?> cls) throws BinaryObjectException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        return this.type(cls.getName());
    }

    @Override
    public BinaryType type(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName");
        }
        int typeId = this.marsh.context().typeId(typeName);
        return this.type(typeId);
    }

    @Override
    public BinaryType type(int typeId) {
        return this.marsh.context().metadata(typeId);
    }

    @Override
    public Collection<BinaryType> types() {
        return this.marsh.context().metadata();
    }

    @Override
    public BinaryObject buildEnum(String typeName, int ord) {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName");
        }
        BinaryContext ctx = this.marsh.context();
        int typeId = ctx.typeId(typeName);
        return new BinaryEnumObjectImpl(ctx, typeId, null, ord);
    }

    @Override
    public BinaryObject buildEnum(String typeName, String name) {
        int typeId;
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name");
        }
        BinaryContext ctx = this.marsh.context();
        BinaryMetadata metadata = ctx.metadata0(typeId = ctx.typeId(typeName));
        if (metadata == null) {
            throw new BinaryObjectException(String.format("Failed to get metadata for type [typeId=%s, typeName='%s']", typeId, typeName));
        }
        Integer ordinal = metadata.getEnumOrdinalByName(name);
        if (ordinal == null) {
            throw new BinaryObjectException(String.format("Failed to resolve enum ordinal by name [typeId=%s, typeName='%s', name='%s']", typeId, typeName, name));
        }
        return new BinaryEnumObjectImpl(ctx, typeId, null, ordinal);
    }

    @Override
    public BinaryType registerEnum(String typeName, Map<String, Integer> vals) {
        if (typeName == null || typeName.isEmpty()) {
            throw new IllegalArgumentException("typeName");
        }
        BinaryContext ctx = this.marsh.context();
        int typeId = ctx.typeId(typeName);
        ctx.updateMetadata(typeId, new BinaryMetadata(typeId, typeName, null, null, null, true, vals), false);
        return ctx.metadata(typeId);
    }

    @Override
    public BinaryType registerClass(Class<?> cls) throws BinaryObjectException {
        BinaryClassDescriptor clsDesc = this.marsh.context().registerClass(cls, true, false);
        return this.marsh.context().metadata(clsDesc.typeId());
    }
}

