/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccCandidate;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheVersionedFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.distributed.dht.colocated.GridDhtDetachedCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticSerializableTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearOptimisticTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearPessimisticTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFastFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishAndAckFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryAbstractEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxQueryResultsEnlistFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappings;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappingsImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.IgniteTxMappingsSingleImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairCheckOnlyFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrInfo;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinator;
import org.apache.ignite.internal.processors.cache.mvcc.MvccCoordinatorChangeAware;
import org.apache.ignite.internal.processors.cache.mvcc.MvccProcessor;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshotFuture;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxy;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyRollbackOnlyImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.UpdateSourceIterator;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridEmbeddedFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridInClosure3;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.C2;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class GridNearTxLocal
extends GridDhtTxLocalAdapter
implements GridTimeoutObject,
AutoCloseable,
MvccCoordinatorChangeAware {
    private static final AtomicReferenceFieldUpdater<GridNearTxLocal, IgniteInternalFuture> PREP_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxLocal.class, IgniteInternalFuture.class, "prepFut");
    private static final AtomicReferenceFieldUpdater<GridNearTxLocal, NearTxFinishFuture> FINISH_FUT_UPD = AtomicReferenceFieldUpdater.newUpdater(GridNearTxLocal.class, NearTxFinishFuture.class, "finishFut");
    private static final String TX_TYPE_MISMATCH_ERR_MSG = "SQL queries and cache operations may not be used in the same transaction.";
    private final IgniteTxMappings mappings;
    @GridToStringExclude
    private volatile IgniteInternalFuture<?> prepFut;
    @GridToStringExclude
    private volatile NearTxFinishFuture finishFut;
    private boolean nearLocallyMapped;
    private boolean colocatedLocallyMapped;
    private Map<IgniteTxKey, IgniteCacheExpiryPolicy> accessMap;
    private Boolean needCheckBackup;
    private boolean hasRemoteLocks;
    protected boolean transform;
    private boolean trackTimeout;
    private final AtomicLong systemTime = new AtomicLong(0L);
    private final AtomicLong systemStartTime = new AtomicLong(0L);
    private final AtomicLong prepareStartTime = new AtomicLong(0L);
    private final AtomicLong prepareTime = new AtomicLong(0L);
    private final AtomicLong commitOrRollbackStartTime = new AtomicLong(0L);
    private final AtomicLong commitOrRollbackTime = new AtomicLong(0L);
    @GridToStringExclude
    private final IgniteTxManager.TxDumpsThrottling txDumpsThrottling;
    @GridToStringExclude
    private TransactionProxyImpl proxy;
    @GridToStringExclude
    private TransactionProxyImpl rollbackOnlyProxy;
    @Nullable
    private final String lb;
    private Boolean mvccOp;
    private long qryId = -1L;
    private long crdVer;

    public GridNearTxLocal(GridCacheSharedContext ctx, boolean implicit, boolean implicitSingle, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, long timeout, boolean storeEnabled, Boolean mvccOp, int txSize, @Nullable UUID subjId, int taskNameHash, @Nullable String lb, IgniteTxManager.TxDumpsThrottling txDumpsThrottling, boolean tracingEnabled) {
        super(ctx, ctx.versions().next(ctx.kernalContext().discovery().topologyVersion()), implicit, implicitSingle, sys, false, plc, concurrency, isolation, timeout, false, storeEnabled, false, txSize, subjId, taskNameHash);
        this.lb = lb;
        this.mappings = implicitSingle ? new IgniteTxMappingsSingleImpl() : new IgniteTxMappingsImpl();
        this.mvccOp = mvccOp;
        this.txDumpsThrottling = txDumpsThrottling;
        this.initResult();
        this.trackTimeout = this.timeout() > 0L && !this.implicit() && this.cctx.time().addTimeoutObject(this);
    }

    @Override
    public boolean near() {
        return true;
    }

    @Override
    public boolean colocated() {
        return true;
    }

    @Override
    public GridCacheVersion nearXidVersion() {
        return this.xidVer;
    }

    @Override
    protected UUID nearNodeId() {
        return this.cctx.localNodeId();
    }

    @Override
    protected IgniteUuid nearFutureId() {
        assert (false) : "nearFutureId should not be called for colocated transactions.";
        return null;
    }

    @Override
    protected IgniteInternalFuture<Boolean> addReader(long msgId, GridDhtCacheEntry cached, IgniteTxEntry entry, AffinityTopologyVersion topVer) {
        return null;
    }

    @Override
    protected void sendFinishReply(@Nullable Throwable err) {
    }

    @Override
    protected void clearPrepareFuture(GridDhtTxPrepareFuture fut) {
    }

    void markForBackupCheck() {
        this.needCheckBackup = true;
    }

    boolean onNeedCheckBackup() {
        Boolean check = this.needCheckBackup;
        if (check != null && check.booleanValue()) {
            this.needCheckBackup = false;
            return true;
        }
        return false;
    }

    boolean needCheckBackup() {
        return this.needCheckBackup != null;
    }

    public boolean nearLocallyMapped() {
        return this.nearLocallyMapped;
    }

    void nearLocallyMapped(boolean nearLocallyMapped) {
        this.nearLocallyMapped = nearLocallyMapped;
    }

    public boolean colocatedLocallyMapped() {
        return this.colocatedLocallyMapped;
    }

    public void colocatedLocallyMapped(boolean colocatedLocallyMapped) {
        this.colocatedLocallyMapped = colocatedLocallyMapped;
    }

    @Override
    public boolean ownsLockUnsafe(GridCacheEntryEx entry) {
        return entry.detached() || super.ownsLockUnsafe(entry);
    }

    @Override
    public long timeout(long timeout) {
        long old = super.timeout(timeout);
        if (old == timeout) {
            return old;
        }
        if (this.trackTimeout && !this.cctx.time().removeTimeoutObject(this)) {
            return old;
        }
        if (this.timeout() > 0L) {
            this.trackTimeout = this.cctx.time().addTimeoutObject(this);
        }
        return old;
    }

    @Override
    public boolean ownsLock(GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        return entry.detached() || super.ownsLock(entry);
    }

    public <K, V> IgniteInternalFuture<GridCacheReturn> putAllAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Map<? extends K, ? extends V> map, boolean retval) {
        return this.putAllAsync0(cacheCtx, entryTopVer, map, null, null, null, retval);
    }

    public final <K, V> IgniteInternalFuture<GridCacheReturn> putAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, V val, boolean retval, CacheEntryPredicate filter) {
        return this.putAsync0(cacheCtx, entryTopVer, key, val, null, null, retval, filter);
    }

    public <K, V> IgniteInternalFuture<GridCacheReturn> invokeAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, EntryProcessor<K, V, Object> entryProcessor, Object ... invokeArgs) {
        return this.putAsync0(cacheCtx, entryTopVer, key, null, entryProcessor, invokeArgs, true, null);
    }

    public <K, V, T> IgniteInternalFuture<GridCacheReturn> invokeAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Map<? extends K, ? extends EntryProcessor<K, V, Object>> map, Object ... invokeArgs) {
        return this.putAllAsync0(cacheCtx, entryTopVer, null, map, invokeArgs, null, true);
    }

    public IgniteInternalFuture<?> putAllDrAsync(GridCacheContext cacheCtx, Map<KeyCacheObject, GridCacheDrInfo> drMap) {
        Map<KeyCacheObject, Object> map = F.viewReadOnly(drMap, new IgniteClosure<GridCacheDrInfo, Object>(){

            @Override
            public Object apply(GridCacheDrInfo val) {
                return val.value();
            }
        }, new IgnitePredicate[0]);
        return this.putAllAsync0(cacheCtx, null, map, null, null, drMap, false);
    }

    public IgniteInternalFuture<?> removeAllDrAsync(GridCacheContext cacheCtx, Map<KeyCacheObject, GridCacheVersion> drMap) {
        return this.removeAllAsync0(cacheCtx, null, null, drMap, false, null, false);
    }

    public <K, V> IgniteInternalFuture<GridCacheReturn> removeAllAsync(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<? extends K> keys, boolean retval, CacheEntryPredicate filter, boolean singleRmv) {
        return this.removeAllAsync0(cacheCtx, entryTopVer, keys, null, retval, filter, singleRmv);
    }

    private <K, V> IgniteInternalFuture putAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, K key, @Nullable V val, @Nullable EntryProcessor<K, V, Object> entryProcessor, @Nullable Object[] invokeArgs, final boolean retval, @Nullable CacheEntryPredicate filter) {
        assert (key != null);
        if (cacheCtx.mvccEnabled()) {
            return this.mvccPutAllAsync0(cacheCtx, Collections.singletonMap(key, val), entryProcessor == null ? null : Collections.singletonMap(key, entryProcessor), invokeArgs, retval, filter);
        }
        try {
            this.beforePut(cacheCtx, retval, false);
            GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
            CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
            Byte dataCenterId = opCtx != null ? opCtx.dataCenterId() : null;
            KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
            boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
            final CacheEntryPredicate[] filters = CU.filterArray(filter);
            IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, cacheKey, val, opCtx != null ? opCtx.expiry() : null, entryProcessor, invokeArgs, retval, false, filters, ret, opCtx != null && opCtx.skipStore(), false, keepBinary, opCtx != null && opCtx.recovery(), dataCenterId);
            try {
                loadFut.get();
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture(e);
            }
            long timeout = this.remainingTime();
            if (timeout == -1L) {
                return new GridFinishedFuture(this.timeoutException());
            }
            if (this.isRollbackOnly()) {
                return new GridFinishedFuture(this.rollbackException());
            }
            if (this.pessimistic()) {
                final Set<KeyCacheObject> enlisted = Collections.singleton(cacheKey);
                if (log.isDebugEnabled()) {
                    log.debug("Before acquiring transaction lock for put on key: " + enlisted);
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, entryProcessor != null, retval, this.isolation, this.isInvalidate(), -1L, -1L);
                IgniteTxLocalAdapter.PLC1<GridCacheReturn> plc1 = new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret){

                    @Override
                    public GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                        if (log.isDebugEnabled()) {
                            log.debug("Acquired transaction lock for put on keys: " + enlisted);
                        }
                        GridNearTxLocal.this.postLockWrite(cacheCtx, enlisted, ret, false, retval, false, -1L, filters, true);
                        return ret;
                    }
                };
                if (fut.isDone()) {
                    try {
                        return GridNearTxLocal.nonInterruptable(plc1.apply(fut.get(), null));
                    }
                    catch (GridClosureException e) {
                        return new GridFinishedFuture(e.unwrap());
                    }
                    catch (IgniteCheckedException e) {
                        try {
                            return GridNearTxLocal.nonInterruptable(plc1.apply(false, e));
                        }
                        catch (Exception e1) {
                            return new GridFinishedFuture(e1);
                        }
                    }
                }
                return GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
            }
            return this.optimisticPutFuture(cacheCtx, loadFut, ret, keepBinary);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private <K, V> IgniteInternalFuture mvccPutAllAsync0(GridCacheContext cacheCtx, @Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor<K, V, Object>> invokeMap, @Nullable Object[] invokeArgs, boolean retval, @Nullable CacheEntryPredicate filter) {
        try {
            MvccUtils.requestSnapshot(this);
            this.beforePut(cacheCtx, retval, true);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Called putAllAsync(...) [tx=" + this + ", map=" + map + ", retval=" + retval + "]");
        }
        assert (map != null || invokeMap != null);
        if (F.isEmpty(map) && F.isEmpty(invokeMap)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(new GridCacheReturn(true, false));
        }
        final boolean transform = invokeMap != null;
        try {
            Set<K> keys = map != null ? map.keySet() : invokeMap.keySet();
            final LinkedHashMap<KeyCacheObject, GridInvokeValue> enlisted = new LinkedHashMap<KeyCacheObject, GridInvokeValue>(keys.size());
            for (K key : keys) {
                EntryProcessor<Object, Object, Object> entryProcessor;
                if (this.isRollbackOnly()) {
                    return new GridFinishedFuture(this.timedOut() ? this.timeoutException() : this.rollbackException());
                }
                if (key == null) {
                    this.rollback();
                    throw new NullPointerException("Null key.");
                }
                Object val = map == null ? null : (Object)map.get(key);
                EntryProcessor<Object, Object, Object> entryProcessor2 = entryProcessor = transform ? invokeMap.get(key) : null;
                if (val == null && entryProcessor == null) {
                    this.setRollbackOnly();
                    throw new NullPointerException("Null value.");
                }
                KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
                if (transform) {
                    enlisted.put(cacheKey, new GridInvokeValue(entryProcessor, invokeArgs));
                    continue;
                }
                enlisted.put(cacheKey, (GridInvokeValue)val);
            }
            return this.updateAsync(cacheCtx, new UpdateSourceIterator<IgniteBiTuple<KeyCacheObject, Object>>(){
                private final Iterator<Map.Entry<KeyCacheObject, Object>> it;
                {
                    this.it = enlisted.entrySet().iterator();
                }

                @Override
                public EnlistOperation operation() {
                    return transform ? EnlistOperation.TRANSFORM : EnlistOperation.UPSERT;
                }

                @Override
                public boolean hasNextX() throws IgniteCheckedException {
                    return this.it.hasNext();
                }

                @Override
                public IgniteBiTuple<KeyCacheObject, Object> nextX() throws IgniteCheckedException {
                    Map.Entry<KeyCacheObject, Object> next = this.it.next();
                    return new IgniteBiTuple<KeyCacheObject, Object>(next.getKey(), next.getValue());
                }
            }, retval, filter, this.remainingTime(), true);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private <K, V> IgniteInternalFuture putAllAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor<K, V, Object>> invokeMap, @Nullable Object[] invokeArgs, @Nullable Map<KeyCacheObject, GridCacheDrInfo> drMap, final boolean retval) {
        Byte dataCenterId;
        if (cacheCtx.mvccEnabled()) {
            return this.mvccPutAllAsync0(cacheCtx, map, invokeMap, invokeArgs, retval, null);
        }
        try {
            this.beforePut(cacheCtx, retval, false);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture(e);
        }
        CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (drMap == null) : drMap;
            assert (map != null || invokeMap != null);
            dataCenterId = opCtx.dataCenterId();
        } else {
            dataCenterId = null;
        }
        Map<K, V> map0 = map;
        Map<K, EntryProcessor<K, V, Object>> invokeMap0 = invokeMap;
        if (log.isDebugEnabled()) {
            log.debug("Called putAllAsync(...) [tx=" + this + ", map=" + map0 + ", retval=" + retval + "]");
        }
        assert (map0 != null || invokeMap0 != null);
        GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(map0) && F.isEmpty(invokeMap0)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(ret.success(true));
        }
        try {
            Set<K> keySet = map0 != null ? map0.keySet() : invokeMap0.keySet();
            final ArrayList<KeyCacheObject> enlisted = new ArrayList<KeyCacheObject>(keySet.size());
            boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
            IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, keySet, opCtx != null ? opCtx.expiry() : null, map0, invokeMap0, invokeArgs, retval, false, CU.filterArray(null), ret, enlisted, drMap, null, opCtx != null && opCtx.skipStore(), false, keepBinary, opCtx != null && opCtx.recovery(), dataCenterId);
            try {
                loadFut.get();
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture(e);
            }
            long timeout = this.remainingTime();
            if (timeout == -1L) {
                return new GridFinishedFuture(this.timeoutException());
            }
            if (this.isRollbackOnly()) {
                return new GridFinishedFuture(this.rollbackException());
            }
            if (this.pessimistic()) {
                if (log.isDebugEnabled()) {
                    log.debug("Before acquiring transaction lock for put on keys: " + enlisted);
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, invokeMap != null, retval, this.isolation, this.isInvalidate(), -1L, -1L);
                IgniteTxLocalAdapter.PLC1<GridCacheReturn> plc1 = new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret){

                    @Override
                    public GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                        if (log.isDebugEnabled()) {
                            log.debug("Acquired transaction lock for put on keys: " + enlisted);
                        }
                        GridNearTxLocal.this.postLockWrite(cacheCtx, enlisted, ret, false, retval, false, -1L, CU.filterArray(null), true);
                        return ret;
                    }
                };
                if (fut.isDone()) {
                    try {
                        return GridNearTxLocal.nonInterruptable(plc1.apply(fut.get(), null));
                    }
                    catch (GridClosureException e) {
                        return new GridFinishedFuture(e.unwrap());
                    }
                    catch (IgniteCheckedException e) {
                        try {
                            return GridNearTxLocal.nonInterruptable(plc1.apply(false, e));
                        }
                        catch (Exception e1) {
                            return new GridFinishedFuture(e1);
                        }
                    }
                }
                return GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
            }
            return this.optimisticPutFuture(cacheCtx, loadFut, ret, keepBinary);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private <K, V> IgniteInternalFuture<Void> enlistWrite(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, KeyCacheObject cacheKey, Object val, @Nullable ExpiryPolicy expiryPlc, @Nullable EntryProcessor<K, V, Object> entryProcessor, @Nullable Object[] invokeArgs, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheReturn ret, boolean skipStore, boolean singleRmv, boolean keepBinary, boolean recovery, Byte dataCenterId) {
        try (MTC.TraceSurroundings ignored2 = MTC.support(this.context().kernalContext().tracing().create(SpanType.TX_NEAR_ENLIST_WRITE, MTC.span()));){
            GridCacheVersion drVer;
            boolean loadMissed;
            boolean needReadVer;
            GridFutureAdapter<Void> enlistFut;
            block26: {
                enlistFut = new GridFutureAdapter<Void>();
                try {
                    if (this.updateLockFuture(null, enlistFut)) break block26;
                    GridFutureAdapter<Void> gridFutureAdapter = this.finishFuture(enlistFut, this.timedOut() ? this.timeoutException() : this.rollbackException(), false);
                    return gridFutureAdapter;
                }
                catch (IgniteCheckedException e) {
                    GridFutureAdapter<Void> gridFutureAdapter = this.finishFuture(enlistFut, e, true);
                    return gridFutureAdapter;
                }
            }
            this.addActiveCache(cacheCtx, recovery);
            boolean hasFilters = !F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter);
            boolean needVal = singleRmv || retval || hasFilters;
            boolean bl = needReadVer = needVal && this.serializable() && this.optimistic();
            if (entryProcessor != null) {
                this.transform = true;
            }
            if (loadMissed = this.enlistWriteEntry(cacheCtx, entryTopVer, cacheKey, val, entryProcessor, invokeArgs, expiryPlc, retval, lockOnly, filter, drVer = dataCenterId != null ? cacheCtx.cache().nextVersion(dataCenterId) : null, -1L, -1L, ret, null, skipStore, singleRmv, hasFilters, needVal, needReadVer, keepBinary, recovery)) {
                AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
                if (topVer == null) {
                    topVer = entryTopVer;
                }
                IgniteInternalFuture<Void> loadFut = this.loadMissing(cacheCtx, topVer != null ? topVer : this.topologyVersion(), Collections.singleton(cacheKey), filter, ret, needReadVer, singleRmv, hasFilters, (entryProcessor != null || cacheCtx.config().isLoadPreviousValue()) && !skipStore, retval, keepBinary, recovery, expiryPlc);
                loadFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Void> fut) {
                        try {
                            fut.get();
                            GridNearTxLocal.this.finishFuture(enlistFut, null, true);
                        }
                        catch (IgniteCheckedException e) {
                            GridNearTxLocal.this.finishFuture(enlistFut, e, true);
                        }
                    }
                });
                GridFutureAdapter<Void> gridFutureAdapter = enlistFut;
                return gridFutureAdapter;
            }
            this.finishFuture(enlistFut, null, true);
            GridFutureAdapter<Void> gridFutureAdapter = enlistFut;
            return gridFutureAdapter;
        }
    }

    private <K, V> IgniteInternalFuture<Void> enlistWrite(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<?> keys, @Nullable ExpiryPolicy expiryPlc, @Nullable Map<?, ?> lookup, @Nullable Map<?, EntryProcessor<K, V, Object>> invokeMap, @Nullable Object[] invokeArgs, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheReturn ret, Collection<KeyCacheObject> enlisted, @Nullable Map<KeyCacheObject, GridCacheDrInfo> drPutMap, @Nullable Map<KeyCacheObject, GridCacheVersion> drRmvMap, boolean skipStore, boolean singleRmv, boolean keepBinary, boolean recovery, Byte dataCenterId) {
        assert (retval || invokeMap == null);
        try (MTC.TraceSurroundings ignored2 = MTC.support(this.context().kernalContext().tracing().create(SpanType.TX_NEAR_ENLIST_WRITE, MTC.span()));){
            GridFutureAdapter<Void> gridFutureAdapter;
            GridFutureAdapter<Void> gridFutureAdapter2;
            HashSet<KeyCacheObject> missedForLoad;
            final GridFutureAdapter enlistFut = new GridFutureAdapter();
            if (!this.updateLockFuture(null, enlistFut)) {
                GridFutureAdapter<Void> gridFutureAdapter3 = this.finishFuture(enlistFut, this.timedOut() ? this.timeoutException() : this.rollbackException(), false);
                return gridFutureAdapter3;
            }
            try {
                this.addActiveCache(cacheCtx, recovery);
            }
            catch (IgniteCheckedException e) {
                GridFutureAdapter<Void> gridFutureAdapter4 = this.finishFuture(enlistFut, e, false);
                if (ignored2 != null) {
                    if (var21_21 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable) {
                            var21_21.addSuppressed(throwable);
                        }
                    } else {
                        ignored2.close();
                    }
                }
                return gridFutureAdapter4;
            }
            boolean rmv = lookup == null && invokeMap == null;
            boolean hasFilters = !F.isEmptyOrNulls(filter) && !F.isAlwaysTrue(filter);
            boolean needVal = singleRmv || retval || hasFilters;
            boolean needReadVer = needVal && this.serializable() && this.optimistic();
            try {
                if (invokeMap != null) {
                    this.transform = true;
                }
                missedForLoad = null;
                for (Object key : keys) {
                    if (this.isRollbackOnly()) {
                        gridFutureAdapter2 = this.finishFuture(enlistFut, this.timedOut() ? this.timeoutException() : this.rollbackException(), false);
                        return gridFutureAdapter2;
                    }
                    if (key != null) break block51;
                }
            }
            catch (IgniteCheckedException e) {
                gridFutureAdapter = this.finishFuture(enlistFut, e, true);
                return gridFutureAdapter;
            }
            {
                long drExpireTime;
                long drTtl;
                GridCacheVersion drVer;
                EntryProcessor<K, V, Object> entryProcessor;
                Object key;
                block51: {
                    this.rollback();
                    throw new NullPointerException("Null key.");
                }
                Object val = rmv || lookup == null ? null : lookup.get(key);
                EntryProcessor<K, V, Object> entryProcessor2 = entryProcessor = invokeMap == null ? null : invokeMap.get(key);
                if (drPutMap != null) {
                    GridCacheDrInfo info = drPutMap.get(key);
                    assert (info != null);
                    drVer = info.version();
                    drTtl = info.ttl();
                    drExpireTime = info.expireTime();
                } else if (drRmvMap != null) {
                    assert (drRmvMap.get(key) != null);
                    drVer = drRmvMap.get(key);
                    drTtl = -1L;
                    drExpireTime = -1L;
                } else if (dataCenterId != null) {
                    drVer = cacheCtx.cache().nextVersion(dataCenterId);
                    drTtl = -1L;
                    drExpireTime = -1L;
                } else {
                    drVer = null;
                    drTtl = -1L;
                    drExpireTime = -1L;
                }
                if (!rmv && val == null && entryProcessor == null) {
                    this.setRollbackOnly();
                    throw new NullPointerException("Null value.");
                }
                KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
                boolean loadMissed = this.enlistWriteEntry(cacheCtx, entryTopVer, cacheKey, val, entryProcessor, invokeArgs, expiryPlc, retval, lockOnly, filter, drVer, drTtl, drExpireTime, ret, enlisted, skipStore, singleRmv, hasFilters, needVal, needReadVer, keepBinary, recovery);
                if (!loadMissed) continue;
                if (missedForLoad == null) {
                    missedForLoad = new HashSet<KeyCacheObject>();
                }
                missedForLoad.add(cacheKey);
                continue;
            }
            if (missedForLoad != null) {
                AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
                if (topVer == null) {
                    topVer = entryTopVer;
                }
                IgniteInternalFuture<Void> loadFut = this.loadMissing(cacheCtx, topVer != null ? topVer : this.topologyVersion(), missedForLoad, filter, ret, needReadVer, singleRmv, hasFilters, (invokeMap != null || cacheCtx.config().isLoadPreviousValue()) && !skipStore, retval, keepBinary, recovery, expiryPlc);
                loadFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                    @Override
                    public void apply(IgniteInternalFuture<Void> fut) {
                        try {
                            fut.get();
                            GridNearTxLocal.this.finishFuture(enlistFut, null, true);
                        }
                        catch (IgniteCheckedException e) {
                            GridNearTxLocal.this.finishFuture(enlistFut, e, true);
                        }
                    }
                });
                gridFutureAdapter2 = enlistFut;
                return gridFutureAdapter2;
            }
            gridFutureAdapter = this.finishFuture(enlistFut, null, true);
            return gridFutureAdapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean enlistWriteEntry(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, KeyCacheObject cacheKey, @Nullable Object val, @Nullable EntryProcessor<?, ?, ?> entryProcessor, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, boolean retval, boolean lockOnly, CacheEntryPredicate[] filter, GridCacheVersion drVer, long drTtl, long drExpireTime, GridCacheReturn ret, @Nullable Collection<KeyCacheObject> enlisted, boolean skipStore, boolean singleRmv, boolean hasFilters, boolean needVal, boolean needReadVer, boolean keepBinary, boolean recovery) throws IgniteCheckedException {
        boolean loadMissed = false;
        boolean rmv = val == null && entryProcessor == null;
        IgniteTxKey txKey = cacheCtx.txKey(cacheKey);
        IgniteTxEntry txEntry = this.entry(txKey);
        if (txEntry != null) {
            boolean del;
            if (entryProcessor == null && txEntry.op() == GridCacheOperation.TRANSFORM) {
                throw new IgniteCheckedException("Failed to enlist write value for key (cannot have update value in transaction after EntryProcessor is applied): " + CU.value(cacheKey, cacheCtx, false));
            }
            GridCacheEntryEx entry = txEntry.cached();
            CacheObject v = txEntry.value();
            boolean bl = del = txEntry.op() == GridCacheOperation.DELETE && rmv;
            if (!del) {
                if (hasFilters && !this.filter(entry.context(), cacheKey, v, filter)) {
                    ret.set(cacheCtx, v, false, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                    return loadMissed;
                }
                GridCacheOperation op = rmv ? GridCacheOperation.DELETE : (entryProcessor != null ? GridCacheOperation.TRANSFORM : (v != null ? GridCacheOperation.UPDATE : GridCacheOperation.CREATE));
                CacheObject cVal = cacheCtx.toCacheObject(val);
                if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                    cacheCtx.validateKeyAndValue(cacheKey, cVal);
                }
                txEntry = this.addEntry(op, cVal, entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary, CU.isNearEnabled(cacheCtx));
                if (enlisted != null) {
                    enlisted.add(cacheKey);
                }
                if (txEntry.op() == GridCacheOperation.TRANSFORM) {
                    GridCacheVersion ver;
                    try {
                        ver = entry.version();
                    }
                    catch (GridCacheEntryRemovedException e) {
                        assert (this.optimistic()) : txEntry;
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to get entry version: [msg=" + e.getMessage() + ']');
                        }
                        ver = null;
                    }
                    this.addInvokeResult(txEntry, txEntry.value(), ret, ver);
                }
            }
            if (this.pessimistic()) return loadMissed;
            txEntry.markValid();
            if (retval && !this.transform) {
                ret.set(cacheCtx, v, true, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                return loadMissed;
            }
            ret.success(true);
            return loadMissed;
        }
        while (true) {
            GridCacheEntryEx entry = this.entryEx(cacheCtx, txKey, entryTopVer != null ? entryTopVer : this.topologyVersion());
            try {
                GridCacheOperation op;
                GridCacheVersion readVer;
                CacheObject old;
                block49: {
                    entry.unswap(false);
                    if (!this.implicit && this.cctx.kernalContext().config().isCacheSanityCheckEnabled() && entry.lockedByThread(this.threadId, this.xidVer)) {
                        throw new IgniteCheckedException("Cannot access key within transaction if lock is externally held [key=" + CU.value(cacheKey, cacheCtx, false) + ", entry=" + entry + ", xidVer=" + this.xidVer + ", threadId=" + this.threadId + ", locNodeId=" + this.cctx.localNodeId() + ']');
                    }
                    old = null;
                    readVer = null;
                    if (this.optimistic() && !this.implicit()) {
                        try {
                            if (needReadVer) {
                                if (!this.primaryLocal(entry)) break block49;
                                this.cctx.database().checkpointReadLock();
                                try {
                                    EntryGetResult res = entry.innerGetVersioned(null, this, retval, retval, entryProcessor, this.resolveTaskName(), null, keepBinary, null);
                                    if (res != null) {
                                        old = (CacheObject)res.value();
                                        readVer = res.version();
                                    }
                                    break block49;
                                }
                                finally {
                                    this.cctx.database().checkpointReadUnlock();
                                }
                            }
                            this.cctx.database().checkpointReadLock();
                            try {
                                old = entry.innerGet(null, this, false, retval, retval, entryProcessor, this.resolveTaskName(), null, keepBinary);
                                break block49;
                            }
                            finally {
                                this.cctx.database().checkpointReadUnlock();
                            }
                        }
                        catch (ClusterTopologyCheckedException e) {
                            entry.touch();
                            throw e;
                        }
                    }
                    old = entry.rawGet();
                }
                GridCacheOperation gridCacheOperation = lockOnly ? GridCacheOperation.NOOP : (rmv ? GridCacheOperation.DELETE : (entryProcessor != null ? GridCacheOperation.TRANSFORM : (op = old != null ? GridCacheOperation.UPDATE : GridCacheOperation.CREATE)));
                if (old != null && hasFilters && !this.filter(entry.context(), cacheKey, old, filter)) {
                    ret.set(cacheCtx, old, false, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                    if (!this.readCommitted()) {
                        txEntry = this.optimistic() && this.serializable() ? this.addEntry(op, old, entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary, CU.isNearEnabled(cacheCtx)) : this.addEntry(GridCacheOperation.READ, old, null, null, entry, null, CU.empty0(), false, -1L, -1L, null, skipStore, keepBinary, CU.isNearEnabled(cacheCtx));
                        txEntry.markValid();
                        if (needReadVer) {
                            assert (readVer != null);
                            txEntry.entryReadVersion(singleRmv ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : readVer);
                        }
                    }
                    if (!this.readCommitted()) return loadMissed;
                    entry.touch();
                    return loadMissed;
                }
                CacheObject cVal = cacheCtx.toCacheObject(val);
                if (op == GridCacheOperation.CREATE || op == GridCacheOperation.UPDATE) {
                    cacheCtx.validateKeyAndValue(cacheKey, cVal);
                }
                txEntry = this.addEntry(op, cVal, entryProcessor, invokeArgs, entry, expiryPlc, filter, true, drTtl, drExpireTime, drVer, skipStore, keepBinary, CU.isNearEnabled(cacheCtx));
                if (op == GridCacheOperation.TRANSFORM && txEntry.value() == null && old != null) {
                    txEntry.value(cacheCtx.toCacheObject(old), false, false);
                }
                if (enlisted != null) {
                    enlisted.add(cacheKey);
                }
                if (!this.pessimistic() && !this.implicit()) {
                    GridCacheVersion ver;
                    txEntry.markValid();
                    if (old == null) {
                        if (needVal) {
                            return true;
                        }
                        assert (!this.implicit() || !this.transform) : this;
                        assert (txEntry.op() != GridCacheOperation.TRANSFORM) : txEntry;
                        if (retval) {
                            ret.set(cacheCtx, null, true, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                            return loadMissed;
                        }
                        ret.success(true);
                        return loadMissed;
                    }
                    if (needReadVer) {
                        assert (readVer != null);
                        txEntry.entryReadVersion(singleRmv ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : readVer);
                    }
                    if (retval && !this.transform) {
                        ret.set(cacheCtx, old, true, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                        return loadMissed;
                    }
                    if (txEntry.op() != GridCacheOperation.TRANSFORM) {
                        ret.success(true);
                        return loadMissed;
                    }
                    try {
                        ver = entry.version();
                    }
                    catch (GridCacheEntryRemovedException ex) {
                        assert (this.optimistic()) : txEntry;
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to get entry version [err=" + ex.getMessage() + ']');
                        }
                        ver = null;
                    }
                    this.addInvokeResult(txEntry, old, ret, ver);
                    return loadMissed;
                }
                if (retval && !this.transform) {
                    ret.set(cacheCtx, old, true, keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                    return loadMissed;
                }
                ret.success(true);
                return loadMissed;
            }
            catch (GridCacheEntryRemovedException ignore) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Got removed entry in transaction putAll0 method: " + entry);
                continue;
            }
            break;
        }
    }

    private <K, V> IgniteInternalFuture<GridCacheReturn> removeAllAsync0(final GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, @Nullable Collection<? extends K> keys, @Nullable Map<KeyCacheObject, GridCacheVersion> drMap, final boolean retval, @Nullable CacheEntryPredicate filter, boolean singleRmv) {
        Byte dataCenterId;
        Collection<? extends K> keys0;
        if (cacheCtx.mvccEnabled()) {
            return this.mvccRemoveAllAsync0(cacheCtx, keys, retval, filter);
        }
        try {
            this.checkUpdatesAllowed(cacheCtx);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        cacheCtx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        if (retval) {
            this.needReturnValue(true);
        }
        if (drMap != null) {
            assert (keys == null);
            keys0 = drMap.keySet();
        } else {
            keys0 = keys;
        }
        CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
        if (opCtx != null && opCtx.hasDataCenterId()) {
            assert (drMap == null) : drMap;
            dataCenterId = opCtx.dataCenterId();
        } else {
            dataCenterId = null;
        }
        assert (keys0 != null);
        if (log.isDebugEnabled()) {
            log.debug(S.toString("Called removeAllAsync(...)", "tx", (Object)this, false, "keys", keys0, true, "implicit", (Object)this.implicit, false, "retval", (Object)retval, false));
        }
        try {
            this.checkValid();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        final GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(keys0)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(ret.success(true));
        }
        this.init();
        final ArrayList<KeyCacheObject> enlisted = new ArrayList<KeyCacheObject>();
        final CacheEntryPredicate[] filters = CU.filterArray(filter);
        ExpiryPolicy plc = !F.isEmpty(filters) ? (opCtx != null ? opCtx.expiry() : null) : null;
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        IgniteInternalFuture<Void> loadFut = this.enlistWrite(cacheCtx, entryTopVer, keys0, plc, null, null, null, retval, false, filters, ret, enlisted, null, drMap, opCtx != null && opCtx.skipStore(), singleRmv, keepBinary, opCtx != null && opCtx.recovery(), dataCenterId);
        try {
            loadFut.get();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        long timeout = this.remainingTime();
        if (timeout == -1L) {
            return new GridFinishedFuture<GridCacheReturn>(this.timeoutException());
        }
        if (this.isRollbackOnly()) {
            return new GridFinishedFuture<GridCacheReturn>(this.rollbackException());
        }
        if (log.isDebugEnabled()) {
            log.debug("Remove keys: " + enlisted);
        }
        if (this.pessimistic()) {
            if (log.isDebugEnabled()) {
                log.debug("Before acquiring transaction lock for remove on keys: " + enlisted);
            }
            IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(enlisted, timeout, this, false, retval, this.isolation, this.isInvalidate(), -1L, -1L);
            IgniteTxLocalAdapter.PLC1<GridCacheReturn> plc1 = new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret){

                @Override
                protected GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                    if (log.isDebugEnabled()) {
                        log.debug("Acquired transaction lock for remove on keys: " + enlisted);
                    }
                    GridNearTxLocal.this.postLockWrite(cacheCtx, enlisted, ret, true, retval, false, -1L, filters, false);
                    return ret;
                }
            };
            if (fut.isDone()) {
                try {
                    return GridNearTxLocal.nonInterruptable(plc1.apply(fut.get(), null));
                }
                catch (GridClosureException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e.unwrap());
                }
                catch (IgniteCheckedException e) {
                    try {
                        return GridNearTxLocal.nonInterruptable(plc1.apply(false, e));
                    }
                    catch (Exception e1) {
                        return new GridFinishedFuture<GridCacheReturn>(e1);
                    }
                }
            }
            return GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, plc1));
        }
        if (this.implicit()) {
            assert (loadFut.isDone());
            return GridNearTxLocal.nonInterruptable(this.commitNearTxLocalAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, GridCacheReturn>(){

                @Override
                public GridCacheReturn applyx(IgniteInternalFuture<IgniteInternalTx> txFut) throws IgniteCheckedException {
                    try {
                        txFut.get();
                        return new GridCacheReturn(cacheCtx, true, keepBinary, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId), GridNearTxLocal.this.implicitRes.value(), GridNearTxLocal.this.implicitRes.success());
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        GridNearTxLocal.this.rollbackNearTxLocalAsync();
                        throw e;
                    }
                }
            }));
        }
        return GridNearTxLocal.nonInterruptable(loadFut.chain(new CX1<IgniteInternalFuture<Void>, GridCacheReturn>(){

            @Override
            public GridCacheReturn applyx(IgniteInternalFuture<Void> f) throws IgniteCheckedException {
                f.get();
                return ret;
            }
        }));
    }

    private <K, V> IgniteInternalFuture<GridCacheReturn> mvccRemoveAllAsync0(GridCacheContext cacheCtx, @Nullable Collection<? extends K> keys, boolean retval, @Nullable CacheEntryPredicate filter) {
        try {
            MvccUtils.requestSnapshot(this);
            this.beforeRemove(cacheCtx, retval, true);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        if (F.isEmpty(keys)) {
            if (this.implicit()) {
                try {
                    this.commit();
                }
                catch (IgniteCheckedException e) {
                    return new GridFinishedFuture<GridCacheReturn>(e);
                }
            }
            return new GridFinishedFuture<GridCacheReturn>(new GridCacheReturn(this.localResult(), true));
        }
        this.init();
        final HashSet<KeyCacheObject> enlisted = new HashSet<KeyCacheObject>(keys.size());
        try {
            for (K key : keys) {
                if (this.isRollbackOnly()) {
                    return new GridFinishedFuture<GridCacheReturn>(this.timedOut() ? this.timeoutException() : this.rollbackException());
                }
                if (key == null) {
                    this.rollback();
                    throw new NullPointerException("Null key.");
                }
                KeyCacheObject cacheKey = cacheCtx.toCacheKeyObject(key);
                enlisted.add(cacheKey);
            }
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        return this.updateAsync(cacheCtx, new UpdateSourceIterator<KeyCacheObject>(){
            private final Iterator<KeyCacheObject> it;
            {
                this.it = enlisted.iterator();
            }

            @Override
            public EnlistOperation operation() {
                return EnlistOperation.DELETE;
            }

            @Override
            public boolean hasNextX() throws IgniteCheckedException {
                return this.it.hasNext();
            }

            @Override
            public KeyCacheObject nextX() throws IgniteCheckedException {
                return this.it.next();
            }
        }, retval, filter, this.remainingTime(), true);
    }

    public IgniteInternalFuture<Long> updateAsync(GridCacheContext cacheCtx, int[] cacheIds, int[] parts, String schema, String qry, Object[] params, int flags, int pageSize, long timeout) {
        try {
            this.beforePut(cacheCtx, false, true);
            return this.updateAsync(new GridNearTxQueryEnlistFuture(cacheCtx, this, cacheIds, parts, schema, qry, params, flags, pageSize, timeout));
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Long>(e);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    public IgniteInternalFuture<Long> updateAsync(GridCacheContext cacheCtx, UpdateSourceIterator<?> it, int pageSize, long timeout, boolean sequential) {
        try {
            this.beforePut(cacheCtx, false, true);
            return this.updateAsync(new GridNearTxQueryResultsEnlistFuture(cacheCtx, this, timeout, it, pageSize, sequential));
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<Long>(e);
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private IgniteInternalFuture<GridCacheReturn> updateAsync(final GridCacheContext cacheCtx, UpdateSourceIterator<?> it, boolean retval, @Nullable CacheEntryPredicate filter, long timeout, boolean sequential) {
        try {
            CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
            final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
            final GridNearTxEnlistFuture fut = new GridNearTxEnlistFuture(cacheCtx, this, timeout, it, 0, sequential, filter, retval, keepBinary);
            fut.init();
            return GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut.chain(new CX1<IgniteInternalFuture<GridCacheReturn>, Boolean>(){

                @Override
                public Boolean applyx(IgniteInternalFuture<GridCacheReturn> fut0) throws IgniteCheckedException {
                    fut0.get();
                    return true;
                }
            }), new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(null){

                @Override
                protected GridCacheReturn postLock(GridCacheReturn ret) throws IgniteCheckedException {
                    GridCacheReturn futRes = (GridCacheReturn)fut.get();
                    assert (futRes != null);
                    GridNearTxLocal.this.mvccSnapshot.incrementOperationCounter();
                    Object val = futRes.value();
                    if (futRes.invokeResult() && val != null) {
                        assert (val instanceof Map);
                        val = cacheCtx.unwrapInvokeResult((Map)val, keepBinary);
                    }
                    return new GridCacheReturn(cacheCtx, true, keepBinary, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId), val, futRes.success());
                }
            }));
        }
        catch (RuntimeException e) {
            this.onException();
            throw e;
        }
    }

    private IgniteInternalFuture<Long> updateAsync(final GridNearTxQueryAbstractEnlistFuture fut) {
        try {
            fut.init();
            IgniteInternalFuture<Long> igniteInternalFuture = GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture<Long, Boolean>(fut.chain(new CX1<IgniteInternalFuture<Long>, Boolean>(){

                @Override
                public Boolean applyx(IgniteInternalFuture<Long> fut0) throws IgniteCheckedException {
                    return fut0.get() != null;
                }
            }), new IgniteTxLocalAdapter.PLC1<Long>(null){

                @Override
                protected Long postLock(Long val) throws IgniteCheckedException {
                    Long res = (Long)fut.get();
                    assert (GridNearTxLocal.this.mvccSnapshot != null);
                    assert (res != null);
                    if (res > 0L) {
                        if (GridNearTxLocal.this.mvccSnapshot.operationCounter() == 0x1FFFFFFF) {
                            throw new IgniteCheckedException("The maximum limit of the number of statements allowed in one transaction is reached. [max=" + GridNearTxLocal.this.mvccSnapshot.operationCounter() + ']');
                        }
                        GridNearTxLocal.this.mvccSnapshot.incrementOperationCounter();
                    }
                    return res;
                }
            }));
            return igniteInternalFuture;
        }
        finally {
            this.cctx.tm().resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K, V> IgniteInternalFuture<Map<K, V>> getAllAsync(final GridCacheContext cacheCtx, final @Nullable AffinityTopologyVersion entryTopVer, final Collection<KeyCacheObject> keys, final boolean deserializeBinary, final boolean skipVals, final boolean keepCacheObjects, final boolean skipStore, final boolean recovery, final boolean readRepair, final boolean needVer) {
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture(Collections.emptyMap());
        }
        if (cacheCtx.mvccEnabled() && !this.isOperationAllowed(true)) {
            return GridNearTxLocal.txTypeMismatchFinishFuture();
        }
        this.init();
        int keysCnt = keys.size();
        boolean single = keysCnt == 1;
        try {
            AffinityTopologyVersion affinityTopologyVersion;
            Collection<KeyCacheObject> lockKeys;
            this.checkValid();
            GridFutureAdapter enlistFut = new GridFutureAdapter();
            if (!this.updateLockFuture(null, enlistFut)) {
                IgniteCheckedException igniteCheckedException;
                if (this.timedOut()) {
                    igniteCheckedException = this.timeoutException();
                    return new GridFinishedFuture<Map<K, V>>(igniteCheckedException);
                }
                igniteCheckedException = this.rollbackException();
                return new GridFinishedFuture<Map<K, V>>(igniteCheckedException);
            }
            final GridLeanMap retMap = new GridLeanMap(keysCnt);
            final GridLeanMap<KeyCacheObject, GridCacheVersion> missed = new GridLeanMap<KeyCacheObject, GridCacheVersion>(this.pessimistic() ? keysCnt : 0);
            CacheOperationContext opCtx = cacheCtx.operationContextPerCall();
            ExpiryPolicy expiryPlc = opCtx != null ? opCtx.expiry() : null;
            try {
                lockKeys = this.enlistRead(cacheCtx, entryTopVer, keys, expiryPlc, retMap, missed, keysCnt, deserializeBinary, skipVals, keepCacheObjects, skipStore, recovery, readRepair, needVer);
            }
            catch (IgniteCheckedException e) {
                GridFinishedFuture<Map<K, V>> gridFinishedFuture = new GridFinishedFuture<Map<K, V>>(e);
                return gridFinishedFuture;
            }
            finally {
                this.finishFuture(enlistFut, null, true);
            }
            if (this.isRollbackOnly()) {
                IgniteCheckedException igniteCheckedException;
                if (this.timedOut()) {
                    igniteCheckedException = this.timeoutException();
                    return new GridFinishedFuture<Map<K, V>>(igniteCheckedException);
                }
                igniteCheckedException = this.rollbackException();
                return new GridFinishedFuture<Map<K, V>>(igniteCheckedException);
            }
            if (single && missed.isEmpty()) {
                return new GridFinishedFuture<Map<K, V>>(retMap);
            }
            if (this.pessimistic() && !this.readCommitted() && !skipVals) {
                if (expiryPlc == null) {
                    expiryPlc = cacheCtx.expiry();
                }
                long accessTtl = expiryPlc != null ? CU.toTtl(expiryPlc.getExpiryForAccess()) : -1L;
                long createTtl = expiryPlc != null ? CU.toTtl(expiryPlc.getExpiryForCreation()) : -1L;
                long timeout = this.remainingTime();
                if (timeout == -1L) {
                    return new GridFinishedFuture<Map<K, V>>(this.timeoutException());
                }
                IgniteInternalFuture<Boolean> fut = cacheCtx.cache().txLockAsync(lockKeys, timeout, this, true, true, this.isolation, this.isInvalidate(), createTtl, accessTtl);
                final ExpiryPolicy expiryPlc0 = expiryPlc;
                IgniteTxLocalAdapter.PLC2 plc2 = new IgniteTxLocalAdapter.PLC2<Map<K, V>>(){

                    @Override
                    public IgniteInternalFuture<Map<K, V>> postLock() throws IgniteCheckedException {
                        if (log.isDebugEnabled()) {
                            log.debug("Acquired transaction lock for read on keys: " + lockKeys);
                        }
                        block2: for (KeyCacheObject cacheKey : lockKeys) {
                            KeyCacheObject keyVal;
                            KeyCacheObject keyCacheObject = keepCacheObjects ? cacheKey : (keyVal = cacheCtx.cacheObjectContext().unwrapBinaryIfNeeded(cacheKey, !deserializeBinary, true, null));
                            if (retMap.containsKey(keyVal)) continue;
                            IgniteTxKey txKey = cacheCtx.txKey(cacheKey);
                            IgniteTxEntry txEntry = GridNearTxLocal.this.entry(txKey);
                            assert (txEntry != null);
                            while (true) {
                                GridCacheEntryEx cached = txEntry.cached();
                                CacheObject val = null;
                                GridCacheVersion readVer = null;
                                EntryGetResult getRes = null;
                                try {
                                    T2<EntryProcessor<Object, Object, Object>, Object[]> transformClo;
                                    T2<EntryProcessor<Object, Object, Object>, Object[]> t2 = transformClo = !F.isEmpty(txEntry.entryProcessors()) && GridNearTxLocal.this.cctx.gridEvents().isRecordable(64) ? F.first(txEntry.entryProcessors()) : null;
                                    if (needVer) {
                                        getRes = cached.innerGetVersioned(null, GridNearTxLocal.this, true, !skipVals, transformClo, GridNearTxLocal.this.resolveTaskName(), null, txEntry.keepBinary(), null);
                                        if (getRes != null) {
                                            val = (CacheObject)getRes.value();
                                            readVer = getRes.version();
                                        }
                                    } else {
                                        val = cached.innerGet(null, GridNearTxLocal.this, false, true, !skipVals, transformClo, GridNearTxLocal.this.resolveTaskName(), null, txEntry.keepBinary());
                                    }
                                    if (val == null) continue block2;
                                    missed.remove(cacheKey);
                                    txEntry.setAndMarkValid(val);
                                    if (!F.isEmpty(txEntry.entryProcessors())) {
                                        val = txEntry.applyEntryProcessors(val);
                                    }
                                    cacheCtx.addResult(retMap, cacheKey, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                                    if (readVer == null) continue block2;
                                    txEntry.entryReadVersion(readVer);
                                    continue block2;
                                }
                                catch (GridCacheEntryRemovedException ignore) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Got removed exception in get postLock (will retry): " + cached);
                                    }
                                    txEntry.cached(GridNearTxLocal.this.entryEx(cacheCtx, txKey, GridNearTxLocal.this.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        if (!missed.isEmpty() && cacheCtx.isLocal()) {
                            AffinityTopologyVersion topVer = GridNearTxLocal.this.topologyVersionSnapshot();
                            if (topVer == null) {
                                topVer = entryTopVer;
                            }
                            return GridNearTxLocal.this.checkMissed(cacheCtx, topVer != null ? topVer : GridNearTxLocal.this.topologyVersion(), retMap, missed, deserializeBinary, skipVals, keepCacheObjects, skipStore, recovery, readRepair, needVer, expiryPlc0);
                        }
                        if (readRepair) {
                            return new GridNearReadRepairFuture(GridNearTxLocal.this.topVer != null ? GridNearTxLocal.this.topVer : GridNearTxLocal.this.topologyVersion(), cacheCtx, (Collection<KeyCacheObject>)keys, !skipStore, GridNearTxLocal.this.taskName, deserializeBinary, recovery, cacheCtx.cache().expiryPolicy(expiryPlc0), (IgniteInternalTx)GridNearTxLocal.this).chain(fut -> {
                                try {
                                    for (Map.Entry entry : ((Map)fut.get()).entrySet()) {
                                        EntryGetResult getRes = (EntryGetResult)entry.getValue();
                                        GridNearTxLocal.this.enlistWrite(cacheCtx, entryTopVer, (KeyCacheObject)entry.getKey(), getRes.value(), expiryPlc0, null, null, false, false, null, null, skipStore, false, !deserializeBinary, recovery, null);
                                        cacheCtx.addResult(retMap, (KeyCacheObject)entry.getKey(), (CacheObject)getRes.value(), skipVals, keepCacheObjects, deserializeBinary, false, getRes, getRes.version(), 0L, 0L, needVer, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                                    }
                                    return Collections.emptyMap();
                                }
                                catch (Exception e) {
                                    throw new GridClosureException(e);
                                }
                            });
                        }
                        return new GridFinishedFuture(Collections.emptyMap());
                    }
                };
                FinishClosure finClos = new FinishClosure<Map<K, V>>(){

                    @Override
                    Map<K, V> finish(Map<K, V> loaded) {
                        retMap.putAll(loaded);
                        return retMap;
                    }
                };
                if (!fut.isDone()) return GridNearTxLocal.nonInterruptable(new GridEmbeddedFuture(fut, plc2, finClos));
                try {
                    IgniteInternalFuture igniteInternalFuture;
                    IgniteInternalFuture fut1 = plc2.apply(fut.get(), null);
                    if (fut1.isDone()) {
                        igniteInternalFuture = new GridFinishedFuture(finClos.apply(fut1.get(), null));
                        return GridNearTxLocal.nonInterruptable(igniteInternalFuture);
                    }
                    igniteInternalFuture = new GridEmbeddedFuture(finClos, fut1);
                    return GridNearTxLocal.nonInterruptable(igniteInternalFuture);
                }
                catch (GridClosureException e) {
                    return new GridFinishedFuture<Map<K, V>>(e.unwrap());
                }
                catch (IgniteCheckedException e) {
                    try {
                        return GridNearTxLocal.nonInterruptable(plc2.apply(false, e));
                    }
                    catch (Exception e1) {
                        return new GridFinishedFuture<Map<K, V>>(e1);
                    }
                }
            }
            assert (this.optimistic() || this.readCommitted() || skipVals);
            if (missed.isEmpty()) return new GridFinishedFuture<Map<K, V>>(retMap);
            if (!this.readCommitted()) {
                Iterator it = missed.keySet().iterator();
                while (it.hasNext()) {
                    KeyCacheObject cacheKey = (KeyCacheObject)it.next();
                    Object keyVal = keepCacheObjects ? cacheKey : cacheCtx.cacheObjectContext().unwrapBinaryIfNeeded(cacheKey, !deserializeBinary, false, null);
                    if (!retMap.containsKey(keyVal)) continue;
                    it.remove();
                }
            }
            if (missed.isEmpty()) {
                return new GridFinishedFuture<Map<K, V>>(retMap);
            }
            AffinityTopologyVersion topVer = this.topologyVersionSnapshot();
            if (topVer == null) {
                topVer = entryTopVer;
            }
            if (topVer != null) {
                affinityTopologyVersion = topVer;
                return this.checkMissed(cacheCtx, affinityTopologyVersion, retMap, missed, deserializeBinary, skipVals, keepCacheObjects, skipStore, recovery, readRepair, needVer, expiryPlc);
            }
            affinityTopologyVersion = this.topologyVersion();
            return this.checkMissed(cacheCtx, affinityTopologyVersion, retMap, missed, deserializeBinary, skipVals, keepCacheObjects, skipStore, recovery, readRepair, needVer, expiryPlc);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            return new GridFinishedFuture<Map<K, V>>(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> Collection<KeyCacheObject> enlistRead(GridCacheContext cacheCtx, @Nullable AffinityTopologyVersion entryTopVer, Collection<KeyCacheObject> keys, @Nullable ExpiryPolicy expiryPlc, Map<K, V> map, Map<KeyCacheObject, GridCacheVersion> missed, int keysCnt, boolean deserializeBinary, boolean skipVals, boolean keepCacheObjects, boolean skipStore, boolean recovery, boolean readRepair, boolean needVer) throws IgniteCheckedException {
        assert (!F.isEmpty(keys));
        assert (keysCnt == keys.size());
        try (MTC.TraceSurroundings ignored2 = MTC.support(this.context().kernalContext().tracing().create(SpanType.TX_NEAR_ENLIST_READ, MTC.span()));){
            cacheCtx.checkSecurity(SecurityPermission.CACHE_READ);
            boolean single = keysCnt == 1;
            Collection<Object> lockKeys = null;
            AffinityTopologyVersion topVer = entryTopVer != null ? entryTopVer : this.topologyVersion();
            boolean needReadVer = this.serializable() && this.optimistic() || needVer;
            block18: for (KeyCacheObject key : keys) {
                GridCacheVersion ver;
                IgniteTxKey txKey;
                IgniteTxEntry txEntry;
                if (this.isRollbackOnly()) {
                    throw this.timedOut() ? this.timeoutException() : this.rollbackException();
                }
                if ((this.pessimistic() || needReadVer) && !this.readCommitted() && !skipVals) {
                    this.addActiveCache(cacheCtx, recovery);
                }
                if ((txEntry = this.entry(txKey = cacheCtx.txKey(key))) != null) {
                    CacheObject val = txEntry.value();
                    if (txEntry.hasValue()) {
                        if (!F.isEmpty(txEntry.entryProcessors())) {
                            val = txEntry.applyEntryProcessors(val);
                        }
                        if (val == null) continue;
                        ver = null;
                        if (needVer) {
                            if (txEntry.op() != GridCacheOperation.READ) {
                                ver = IgniteTxEntry.GET_ENTRY_INVALID_VER_UPDATED;
                            } else {
                                ver = txEntry.entryReadVersion();
                                if (ver == null && this.pessimistic()) {
                                    while (true) {
                                        try {
                                            GridCacheEntryEx cached = txEntry.cached();
                                            ver = cached.isNear() ? ((GridNearCacheEntry)cached).dhtVersion() : cached.version();
                                        }
                                        catch (GridCacheEntryRemovedException ignored) {
                                            txEntry.cached(this.entryEx(cacheCtx, txEntry.txKey(), topVer));
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                if (ver == null) {
                                    assert (this.optimistic() && this.repeatableRead()) : this;
                                    ver = IgniteTxEntry.GET_ENTRY_INVALID_VER_AFTER_GET;
                                }
                            }
                            assert (ver != null);
                        }
                        cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, ver, 0L, 0L, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                        continue;
                    }
                    assert (txEntry.op() == GridCacheOperation.TRANSFORM);
                    while (true) {
                        try {
                            T2<EntryProcessor<Object, Object, Object>, Object[]> transformClo;
                            GridCacheVersion readVer = null;
                            EntryGetResult getRes = null;
                            T2<EntryProcessor<Object, Object, Object>, Object[]> t2 = transformClo = txEntry.op() == GridCacheOperation.TRANSFORM && this.cctx.gridEvents().isRecordable(64) ? F.first(txEntry.entryProcessors()) : null;
                            if (needVer) {
                                getRes = txEntry.cached().innerGetVersioned(null, this, true, !skipVals, transformClo, this.resolveTaskName(), null, txEntry.keepBinary(), null);
                                if (getRes != null) {
                                    val = (CacheObject)getRes.value();
                                    readVer = getRes.version();
                                }
                            } else {
                                val = txEntry.cached().innerGet(null, this, false, true, !skipVals, transformClo, this.resolveTaskName(), null, txEntry.keepBinary());
                            }
                            if (val != null) {
                                if (!this.readCommitted() && !skipVals) {
                                    txEntry.readValue(val);
                                }
                                if (!F.isEmpty(txEntry.entryProcessors())) {
                                    val = txEntry.applyEntryProcessors(val);
                                }
                                cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                                continue block18;
                            }
                            missed.put(key, txEntry.cached().version());
                            continue block18;
                        }
                        catch (GridCacheEntryRemovedException ignored) {
                            txEntry.cached(this.entryEx(cacheCtx, txEntry.txKey(), topVer));
                            continue;
                        }
                        break;
                    }
                }
                if (lockKeys == null && !skipVals) {
                    Collection<KeyCacheObject> collection = lockKeys = single ? Collections.singleton(key) : new ArrayList(keysCnt);
                }
                if (!single && !skipVals) {
                    lockKeys.add(key);
                }
                while (true) {
                    GridCacheEntryEx entry = this.entryEx(cacheCtx, txKey, topVer);
                    try {
                        ver = entry.version();
                        CacheObject val = null;
                        GridCacheVersion readVer = null;
                        EntryGetResult getRes = null;
                        if ((!this.pessimistic() || this.readCommitted() && !skipVals) && !readRepair) {
                            IgniteCacheExpiryPolicy accessPlc;
                            IgniteCacheExpiryPolicy igniteCacheExpiryPolicy = accessPlc = this.optimistic() ? this.accessPolicy(cacheCtx, txKey, expiryPlc) : null;
                            if (needReadVer) {
                                EntryGetResult entryGetResult = this.primaryLocal(entry) ? entry.innerGetVersioned(null, this, true, true, null, this.resolveTaskName(), accessPlc, !deserializeBinary, null) : (getRes = null);
                                if (getRes != null) {
                                    val = (CacheObject)getRes.value();
                                    readVer = getRes.version();
                                }
                            } else {
                                val = entry.innerGet(null, this, false, true, !skipVals, null, this.resolveTaskName(), accessPlc, !deserializeBinary);
                            }
                            if (val != null) {
                                cacheCtx.addResult(map, key, val, skipVals, keepCacheObjects, deserializeBinary, false, getRes, readVer, 0L, 0L, needVer, U.deploymentClassLoader(this.cctx.kernalContext(), this.deploymentLdrId));
                            } else {
                                missed.put(key, ver);
                            }
                        } else {
                            missed.put(key, ver);
                        }
                        if (this.readCommitted() || skipVals) continue block18;
                        txEntry = this.addEntry(GridCacheOperation.READ, val, null, null, entry, expiryPlc, null, true, -1L, -1L, null, skipStore, !deserializeBinary, CU.isNearEnabled(cacheCtx));
                        if (val == null || this.pessimistic()) continue block18;
                        txEntry.markValid();
                        if (!needReadVer) continue block18;
                        assert (readVer != null);
                        txEntry.entryReadVersion(readVer);
                        continue block18;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Got removed entry in transaction getAllAsync(..) (will retry): " + key);
                        continue;
                    }
                    finally {
                        if (entry == null || !this.readCommitted()) continue;
                        if (cacheCtx.isNear()) {
                            if (!cacheCtx.affinity().partitionBelongs(cacheCtx.localNode(), entry.partition(), topVer) || !entry.markObsolete(this.xidVer)) continue;
                            cacheCtx.cache().removeEntry(entry);
                            continue;
                        }
                        entry.touch();
                        continue;
                    }
                    break;
                }
            }
            Collection<Object> collection = lockKeys != null ? lockKeys : Collections.emptyList();
            return collection;
        }
    }

    private IgniteInternalFuture<Void> loadMissing(final GridCacheContext cacheCtx, AffinityTopologyVersion topVer, Set<KeyCacheObject> keys, final CacheEntryPredicate[] filter, final GridCacheReturn ret, final boolean needReadVer, final boolean singleRmv, final boolean hasFilters, boolean readThrough, final boolean retval, final boolean keepBinary, boolean recovery, ExpiryPolicy expiryPlc) {
        GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c = new GridInClosure3<KeyCacheObject, Object, GridCacheVersion>(){

            @Override
            public void apply(KeyCacheObject key, @Nullable Object val, @Nullable GridCacheVersion loadVer) {
                if (log.isDebugEnabled()) {
                    log.debug("Loaded value from remote node [key=" + key + ", val=" + val + ']');
                }
                IgniteTxEntry e = GridNearTxLocal.this.entry(new IgniteTxKey(key, cacheCtx.cacheId()));
                assert (e != null);
                if (needReadVer) {
                    assert (loadVer != null);
                    e.entryReadVersion(singleRmv && val != null ? IgniteTxEntry.SER_READ_NOT_EMPTY_VER : loadVer);
                }
                if (singleRmv) {
                    assert (!hasFilters && !retval);
                    assert (val == null || Boolean.TRUE.equals(val)) : val;
                    ret.set(cacheCtx, null, val != null, keepBinary, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                } else {
                    CacheObject cacheVal = cacheCtx.toCacheObject(val);
                    if (e.op() == GridCacheOperation.TRANSFORM) {
                        GridCacheVersion ver;
                        e.readValue(cacheVal);
                        try {
                            ver = e.cached().version();
                        }
                        catch (GridCacheEntryRemovedException ex) {
                            assert (GridNearTxLocal.this.optimistic()) : e;
                            if (log.isDebugEnabled()) {
                                log.debug("Failed to get entry version: [msg=" + ex.getMessage() + ']');
                            }
                            ver = null;
                        }
                        GridNearTxLocal.this.addInvokeResult(e, cacheVal, ret, ver);
                    } else {
                        boolean success;
                        if (hasFilters) {
                            success = GridNearTxLocal.this.isAll(e.context(), key, cacheVal, filter);
                            if (!success) {
                                e.value(cacheVal, false, false);
                                e.op(GridCacheOperation.READ);
                            }
                        } else {
                            success = true;
                        }
                        ret.set(cacheCtx, cacheVal, success, keepBinary, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                    }
                }
            }
        };
        return this.loadMissing(cacheCtx, topVer, readThrough, true, keys, singleRmv, needReadVer, keepBinary, recovery, false, expiryPlc, c);
    }

    private static IgniteInternalFuture txTypeMismatchFinishFuture() {
        return new GridFinishedFuture(new IgniteCheckedException(TX_TYPE_MISMATCH_ERR_MSG));
    }

    private IgniteInternalFuture optimisticPutFuture(final GridCacheContext cacheCtx, IgniteInternalFuture<Void> loadFut, final GridCacheReturn ret, final boolean keepBinary) {
        if (this.implicit()) {
            assert (loadFut.isDone());
            return GridNearTxLocal.nonInterruptable(this.commitNearTxLocalAsync().chain(new CX1<IgniteInternalFuture<IgniteInternalTx>, GridCacheReturn>(){

                @Override
                public GridCacheReturn applyx(IgniteInternalFuture<IgniteInternalTx> txFut) throws IgniteCheckedException {
                    try {
                        txFut.get();
                        Object res = GridNearTxLocal.this.implicitRes.value();
                        if (GridNearTxLocal.this.implicitRes.invokeResult()) {
                            assert (res == null || res instanceof Map) : GridNearTxLocal.access$4600(GridNearTxLocal.this);
                            res = cacheCtx.unwrapInvokeResult((Map)res, keepBinary);
                        }
                        return new GridCacheReturn(cacheCtx, true, keepBinary, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId), res, GridNearTxLocal.this.implicitRes.success());
                    }
                    catch (RuntimeException | IgniteCheckedException e) {
                        if (!(e instanceof NodeStoppingException)) {
                            GridNearTxLocal.this.rollbackNearTxLocalAsync();
                        }
                        throw e;
                    }
                }
            }));
        }
        return GridNearTxLocal.nonInterruptable(loadFut.chain(new CX1<IgniteInternalFuture<Void>, GridCacheReturn>(){

            @Override
            public GridCacheReturn applyx(IgniteInternalFuture<Void> f) throws IgniteCheckedException {
                f.get();
                return ret;
            }
        }));
    }

    private void onException() {
        for (IgniteTxEntry txEntry : this.allEntries()) {
            GridCacheEntryEx cached0 = txEntry.cached();
            if (cached0 == null) continue;
            cached0.touch();
        }
    }

    @Override
    public Collection<IgniteTxEntry> optimisticLockEntries() {
        assert (false) : "Should not be called";
        throw new UnsupportedOperationException();
    }

    private IgniteInternalFuture<Void> loadMissing(GridCacheContext cacheCtx, AffinityTopologyVersion topVer, boolean readThrough, boolean async, final Collection<KeyCacheObject> keys, final boolean skipVals, final boolean needVer, boolean keepBinary, boolean recovery, boolean readRepair, ExpiryPolicy expiryPlc, final GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        IgniteCacheExpiryPolicy expiryPlc0;
        IgniteCacheExpiryPolicy igniteCacheExpiryPolicy = expiryPlc0 = this.optimistic() ? this.accessPolicy(cacheCtx, keys) : cacheCtx.cache().expiryPolicy(expiryPlc);
        if (cacheCtx.isNear()) {
            return cacheCtx.nearTx().txLoadAsync(this, topVer, keys, readThrough, needVer || !cacheCtx.config().isReadFromBackup() || this.optimistic() && this.serializable() && readThrough, false, recovery, expiryPlc0, skipVals, needVer).chain(new C1<IgniteInternalFuture<Map<Object, Object>>, Void>(){

                @Override
                public Void apply(IgniteInternalFuture<Map<Object, Object>> f) {
                    try {
                        Map<Object, Object> map = f.get();
                        GridNearTxLocal.this.processLoaded(map, keys, needVer, c);
                        return null;
                    }
                    catch (Exception e) {
                        GridNearTxLocal.this.setRollbackOnly();
                        throw new GridClosureException(e);
                    }
                }
            });
        }
        if (cacheCtx.isColocated()) {
            if (readRepair) {
                return new GridNearReadRepairCheckOnlyFuture(cacheCtx, keys, readThrough, this.taskName, false, recovery, expiryPlc0, skipVals, needVer, true, this).multi().chain(fut -> {
                    try {
                        Map map = (Map)fut.get();
                        this.processLoaded(map, keys, needVer, c);
                        return null;
                    }
                    catch (IgniteConsistencyViolationException e) {
                        for (KeyCacheObject key : keys) {
                            this.txState().removeEntry(cacheCtx.txKey(key));
                        }
                        throw new GridClosureException(e);
                    }
                    catch (Exception e) {
                        this.setRollbackOnly();
                        throw new GridClosureException(e);
                    }
                });
            }
            if (keys.size() == 1) {
                final KeyCacheObject key = F.first(keys);
                return cacheCtx.colocated().loadAsync(key, readThrough, needVer || !cacheCtx.config().isReadFromBackup() || this.optimistic() && this.serializable() && readThrough, topVer, this.resolveTaskName(), false, expiryPlc0, skipVals, needVer, true, recovery, null, this.label()).chain(new C1<IgniteInternalFuture<Object>, Void>(){

                    @Override
                    public Void apply(IgniteInternalFuture<Object> f) {
                        try {
                            Object val = f.get();
                            GridNearTxLocal.this.processLoaded(key, val, needVer, skipVals, c);
                            return null;
                        }
                        catch (Exception e) {
                            GridNearTxLocal.this.setRollbackOnly();
                            throw new GridClosureException(e);
                        }
                    }
                });
            }
            return cacheCtx.colocated().loadAsync(keys, readThrough, needVer || !cacheCtx.config().isReadFromBackup() || this.optimistic() && this.serializable() && readThrough, topVer, this.resolveTaskName(), false, recovery, expiryPlc0, skipVals, needVer, true, this.label(), null).chain(new C1<IgniteInternalFuture<Map<Object, Object>>, Void>(){

                @Override
                public Void apply(IgniteInternalFuture<Map<Object, Object>> f) {
                    try {
                        Map<Object, Object> map = f.get();
                        GridNearTxLocal.this.processLoaded(map, keys, needVer, c);
                        return null;
                    }
                    catch (Exception e) {
                        GridNearTxLocal.this.setRollbackOnly();
                        throw new GridClosureException(e);
                    }
                }
            });
        }
        assert (cacheCtx.isLocal());
        return this.localCacheLoadMissing(cacheCtx, topVer, readThrough, async, keys, skipVals, needVer, keepBinary, recovery, expiryPlc, c);
    }

    private IgniteInternalFuture<Void> localCacheLoadMissing(final GridCacheContext cacheCtx, final AffinityTopologyVersion topVer, boolean readThrough, boolean async, Collection<KeyCacheObject> keys, boolean skipVals, boolean needVer, boolean keepBinary, boolean recovery, ExpiryPolicy expiryPlc, final GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        assert (cacheCtx.isLocal()) : cacheCtx.name();
        if (!readThrough || !cacheCtx.readThrough()) {
            for (KeyCacheObject key : keys) {
                c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
            }
            return new GridFinishedFuture<Void>();
        }
        try {
            IgniteCacheExpiryPolicy expiryPlc0 = this.optimistic() ? this.accessPolicy(cacheCtx, keys) : cacheCtx.cache().expiryPolicy(expiryPlc);
            LinkedHashMap<KeyCacheObject, GridCacheVersion> misses = null;
            block5: for (KeyCacheObject key : keys) {
                while (true) {
                    IgniteTxEntry txEntry;
                    GridCacheEntryEx entry;
                    GridCacheEntryEx gridCacheEntryEx = entry = (txEntry = this.entry(cacheCtx.txKey(key))) == null ? cacheCtx.cache().entryEx(key) : txEntry.cached();
                    if (entry == null) continue;
                    try {
                        EntryGetResult res = entry.innerGetVersioned(null, this, !skipVals, !skipVals, null, this.resolveTaskName(), expiryPlc0, txEntry == null ? keepBinary : txEntry.keepBinary(), null);
                        if (res == null) {
                            if (misses == null) {
                                misses = new LinkedHashMap<KeyCacheObject, GridCacheVersion>();
                            }
                            misses.put(key, entry.version());
                            continue block5;
                        }
                        c.apply(key, skipVals ? Boolean.valueOf(true) : res.value(), res.version());
                        continue block5;
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        if (log.isDebugEnabled()) {
                            log.debug("Got removed entry, will retry: " + key);
                        }
                        if (txEntry == null) continue;
                        txEntry.cached(cacheCtx.cache().entryEx(key, this.topologyVersion()));
                        continue;
                    }
                    break;
                }
            }
            if (misses != null) {
                final LinkedHashMap<KeyCacheObject, GridCacheVersion> misses0 = misses;
                cacheCtx.store().loadAll(this, misses.keySet(), (IgniteBiInClosure<KeyCacheObject, Object>)new CI2<KeyCacheObject, Object>(){

                    @Override
                    public void apply(KeyCacheObject key, Object val) {
                        GridCacheVersion ver;
                        block7: {
                            ver = (GridCacheVersion)misses0.remove(key);
                            assert (ver != null) : key;
                            if (val != null) {
                                CacheObject cacheVal = cacheCtx.toCacheObject(val);
                                while (true) {
                                    GridCacheEntryEx entry = cacheCtx.cache().entryEx(key, topVer);
                                    try {
                                        cacheCtx.shared().database().ensureFreeSpace(cacheCtx.dataRegion());
                                        EntryGetResult verVal = entry.versionedValue(cacheVal, ver, null, null, null);
                                        if (log.isDebugEnabled()) {
                                            log.debug("Set value loaded from store into entry [oldVer=" + ver + ", newVer=" + verVal.version() + ", entry=" + entry + ']');
                                        }
                                        ver = verVal.version();
                                        break block7;
                                    }
                                    catch (GridCacheEntryRemovedException ignore) {
                                        if (!log.isDebugEnabled()) continue;
                                        log.debug("Got removed entry, (will retry): " + entry);
                                        continue;
                                    }
                                    catch (IgniteCheckedException e) {
                                        throw new GridClosureException(e);
                                    }
                                    break;
                                }
                            }
                            ver = IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER;
                        }
                        c.apply(key, val, ver);
                    }
                });
                for (KeyCacheObject key : misses0.keySet()) {
                    c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
                }
            }
            return new GridFinishedFuture<Void>();
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            return new GridFinishedFuture<Void>(e);
        }
    }

    private void processLoaded(Map<Object, Object> map, Collection<KeyCacheObject> keys, boolean needVer, GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        for (KeyCacheObject key : keys) {
            this.processLoaded(key, map.get(key), needVer, false, c);
        }
    }

    private void processLoaded(KeyCacheObject key, @Nullable Object val, boolean needVer, boolean skipVals, GridInClosure3<KeyCacheObject, Object, GridCacheVersion> c) {
        if (val != null) {
            GridCacheVersion ver;
            Object v;
            if (needVer) {
                EntryGetResult getRes = (EntryGetResult)val;
                v = getRes.value();
                ver = getRes.version();
            } else {
                v = val;
                ver = null;
            }
            if (skipVals && v == Boolean.FALSE) {
                c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
            } else {
                c.apply(key, v, ver);
            }
        } else {
            c.apply(key, null, IgniteTxEntry.SER_READ_EMPTY_ENTRY_VER);
        }
    }

    @Override
    protected void updateExplicitVersion(IgniteTxEntry txEntry, GridCacheEntryEx entry) throws GridCacheEntryRemovedException {
        if (entry.detached()) {
            GridCacheMvccCandidate cand = this.cctx.mvcc().explicitLock(this.threadId(), entry.txKey());
            if (cand != null && !this.xidVersion().equals(cand.version())) {
                GridCacheVersion candVer = cand.version();
                txEntry.explicitVersion(candVer);
                if (candVer.compareTo(this.minVer) < 0) {
                    this.minVer = candVer;
                }
            }
        } else {
            super.updateExplicitVersion(txEntry, entry);
        }
    }

    public IgniteTxMappings mappings() {
        return this.mappings;
    }

    @Override
    public boolean removeMapping(UUID nodeId) {
        if (this.mappings.remove(nodeId) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Removed mapping for node [nodeId=" + nodeId + ", tx=" + this + ']');
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Mapping for node was not found [nodeId=" + nodeId + ", tx=" + this + ']');
        }
        return false;
    }

    @Override
    public boolean queryEnlisted() {
        if (!this.txState.mvccEnabled()) {
            return false;
        }
        if (this.qryEnlisted) {
            return true;
        }
        if (this.mappings.single()) {
            return !this.mappings.empty() && this.mappings.singleMapping().queryUpdate();
        }
        return this.mappings.mappings().stream().anyMatch(GridDistributedTxMapping::queryUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<MvccSnapshot> requestSnapshot() {
        MvccTxSnapshotFuture fut;
        if (this.isRollbackOnly()) {
            return new GridFinishedFuture<MvccSnapshot>(this.rollbackException());
        }
        MvccSnapshot mvccSnapshot0 = this.mvccSnapshot;
        if (mvccSnapshot0 != null) {
            return new GridFinishedFuture<MvccSnapshot>(mvccSnapshot0);
        }
        MvccProcessor prc = this.cctx.coordinators();
        MvccCoordinator crd = prc.currentCoordinator();
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            this.crdVer = crd.version();
        }
        if (crd.local()) {
            mvccSnapshot0 = prc.requestWriteSnapshotLocal();
        }
        if (mvccSnapshot0 == null) {
            fut = new MvccTxSnapshotFuture();
            prc.requestWriteSnapshotAsync(crd, fut);
            return fut;
        }
        fut = new GridFutureAdapter();
        this.onResponse0(mvccSnapshot0, fut);
        return fut;
    }

    private synchronized void onResponse0(MvccSnapshot res, GridFutureAdapter<MvccSnapshot> fut) {
        assert (this.mvccSnapshot == null);
        if (this.state() != TransactionState.ACTIVE) {
            assert (this.isRollbackOnly());
            this.cctx.coordinators().ackTxRollback(res);
            fut.onDone(this.timedOut() ? this.timeoutException() : this.rollbackException());
        } else if (this.crdVer != res.coordinatorVersion()) {
            this.setRollbackOnly();
            fut.onDone(new IgniteTxRollbackCheckedException("Mvcc coordinator has been changed during request. Please retry on a stable topology."));
        } else {
            this.mvccSnapshot = res;
            fut.onDone(this.mvccSnapshot);
        }
    }

    @Override
    public synchronized long onMvccCoordinatorChange(MvccCoordinator newCrd) {
        if (this.isDone || this.crdVer == 0L || newCrd.version() == this.crdVer) {
            return -1L;
        }
        this.crdVer = newCrd.version();
        if (this.mvccSnapshot == null) {
            return -1L;
        }
        if (this.qryId == -1L) {
            long qryId0 = this.qryId = ID_CNTR.incrementAndGet();
            this.finishFuture().listen(f -> this.cctx.coordinators().ackQueryDone(this.mvccSnapshot, qryId0));
        }
        return this.qryId;
    }

    @Override
    public void mvccSnapshot(MvccSnapshot mvccSnapshot) {
        throw new UnsupportedOperationException();
    }

    public void addKeyMapping(IgniteTxKey key, ClusterNode node) {
        GridDistributedTxMapping m = this.mappings.get(node.id());
        if (m == null) {
            m = new GridDistributedTxMapping(node);
            this.mappings.put(m);
        }
        IgniteTxEntry txEntry = this.entry(key);
        assert (txEntry != null);
        txEntry.nodeId(node.id());
        m.add(txEntry);
        if (log.isDebugEnabled()) {
            log.debug("Added mappings to transaction [locId=" + this.cctx.localNodeId() + ", key=" + key + ", node=" + node + ", tx=" + this + ']');
        }
    }

    @Nullable
    IgniteTxEntry singleWrite() {
        return this.txState.singleWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws IgniteCheckedException {
        if (log.isDebugEnabled()) {
            log.debug("Suspend near local tx: " + this);
        }
        if (this.threadId() != Thread.currentThread().getId()) {
            throw new IgniteCheckedException("Only thread started transaction can suspend it.");
        }
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            this.checkValid();
            this.cctx.tm().suspendTx(this);
        }
    }

    public void resume() throws IgniteCheckedException {
        this.resume(true, Thread.currentThread().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume(boolean checkTimeout, long threadId) throws IgniteCheckedException {
        if (log.isDebugEnabled()) {
            log.debug("Resume near local tx: " + this);
        }
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            this.checkValid(checkTimeout);
            this.cctx.tm().resumeTx(this, threadId);
        }
    }

    void addEntryMapping(@Nullable Collection<GridDistributedTxMapping> maps) {
        if (!F.isEmpty(maps)) {
            for (GridDistributedTxMapping map : maps) {
                ClusterNode primary = map.primary();
                GridDistributedTxMapping m = this.mappings.get(primary.id());
                if (m == null) {
                    m = new GridDistributedTxMapping(primary);
                    this.mappings.put(m);
                    if (map.explicitLock()) {
                        m.markExplicitLock();
                    }
                }
                for (IgniteTxEntry entry : map.entries()) {
                    m.add(entry);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Added mappings to transaction [locId=" + this.cctx.localNodeId() + ", mappings=" + maps + ", tx=" + this + ']');
            }
        }
    }

    void addSingleEntryMapping(GridDistributedTxMapping map, IgniteTxEntry entry) {
        ClusterNode n = map.primary();
        GridDistributedTxMapping m = new GridDistributedTxMapping(n);
        this.mappings.put(m);
        if (map.explicitLock()) {
            m.markExplicitLock();
        }
        m.add(entry);
    }

    public boolean markExplicit(UUID nodeId) {
        this.explicitLock = true;
        GridDistributedTxMapping m = this.mappings.get(nodeId);
        if (m != null) {
            m.markExplicitLock();
            return true;
        }
        return false;
    }

    @Override
    public boolean onOwnerChanged(GridCacheEntryEx entry, GridCacheMvccCandidate owner) {
        GridCacheVersionedFuture fut = (GridCacheVersionedFuture)this.prepFut;
        return fut != null && fut.onOwnerChanged(entry, owner);
    }

    void readyNearLocks(GridDistributedTxMapping mapping, Collection<GridCacheVersion> pendingVers, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        assert (mapping.hasNearCacheEntries()) : mapping;
        for (IgniteTxEntry txEntry : mapping.entries()) {
            if (!CU.WRITE_FILTER_NEAR.apply(txEntry)) continue;
            this.readyNearLock(txEntry, mapping.dhtVersion(), pendingVers, committedVers, rolledbackVers);
        }
        for (IgniteTxEntry txEntry : mapping.entries()) {
            if (!CU.READ_FILTER_NEAR.apply(txEntry)) continue;
            this.readyNearLock(txEntry, mapping.dhtVersion(), pendingVers, committedVers, rolledbackVers);
        }
    }

    private void readyNearLock(IgniteTxEntry txEntry, GridCacheVersion dhtVer, Collection<GridCacheVersion> pendingVers, Collection<GridCacheVersion> committedVers, Collection<GridCacheVersion> rolledbackVers) {
        while (true) {
            GridCacheContext cacheCtx = txEntry.cached().context();
            assert (cacheCtx.isNear());
            GridDistributedCacheEntry entry = (GridDistributedCacheEntry)txEntry.cached();
            try {
                GridCacheVersion explicit = txEntry.explicitVersion();
                if (explicit != null) break;
                entry.readyNearLock(this.xidVer, dhtVer, committedVers, rolledbackVers, pendingVers);
            }
            catch (GridCacheEntryRemovedException ignored) {
                assert (entry.obsoleteVersion() != null);
                if (log.isDebugEnabled()) {
                    log.debug("Replacing obsolete entry in remote transaction [entry=" + entry + ", tx=" + this + ']');
                }
                txEntry.cached(txEntry.context().cache().entryEx(txEntry.key(), this.topologyVersion()));
                continue;
            }
            break;
        }
    }

    @Override
    public boolean localFinish(boolean commit, boolean clearThreadMap) throws IgniteCheckedException {
        IgniteCheckedException err;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug("Finishing near local tx [tx=" + this + ", commit=" + commit + "]");
            }
            if (commit) {
                if (!this.state(TransactionState.COMMITTING)) {
                    TransactionState state = this.state();
                    if (state != TransactionState.COMMITTING && state != TransactionState.COMMITTED) {
                        throw this.isRollbackOnly() ? (this.timedOut() ? this.timeoutException() : this.rollbackException()) : new IgniteCheckedException("Invalid transaction state for commit [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Invalid transaction state for commit (another thread is committing): " + this);
                    }
                    return false;
                }
            } else if (!this.state(TransactionState.ROLLING_BACK)) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid transaction state for rollback [state=" + (Object)((Object)this.state()) + ", tx=" + this + ']');
                }
                return false;
            }
            err = null;
            try {
                if (commit && !this.isRollbackOnly()) {
                    this.userCommit();
                } else {
                    this.userRollback(clearThreadMap);
                }
            }
            catch (IgniteCheckedException e) {
                err = e;
                commit = false;
                if (this.isRollbackOnly()) break block17;
                this.invalidate = true;
                this.systemInvalidate(true);
                U.warn(log, "Set transaction invalidation flag to true due to error [tx=" + this + ", err=" + err + ']');
            }
        }
        if (err != null) {
            this.state(TransactionState.UNKNOWN);
            throw err;
        }
        if (commit) {
            if (!this.onePhaseCommit() && !this.state(TransactionState.COMMITTED)) {
                this.state(TransactionState.UNKNOWN);
                throw new IgniteCheckedException("Invalid transaction state for commit: " + this);
            }
        } else if (!this.state(TransactionState.ROLLED_BACK)) {
            this.state(TransactionState.UNKNOWN);
            throw new IgniteCheckedException("Invalid transaction state for rollback: " + this);
        }
        return true;
    }

    public long systemTimeCurrent() {
        long systemTime0 = this.systemTime.get();
        long systemStartTime0 = this.systemStartTime.get();
        long t = systemStartTime0 == 0L ? 0L : System.nanoTime() - systemStartTime0;
        return U.nanosToMillis(systemTime0 + t);
    }

    @Override
    public boolean state(TransactionState state) {
        boolean res = super.state(state);
        if (state == TransactionState.COMMITTED || state == TransactionState.ROLLED_BACK) {
            boolean willBeSkipped;
            this.leaveSystemSection();
            if (!this.commitOrRollbackTime.compareAndSet(0L, System.nanoTime() - this.commitOrRollbackStartTime.get())) {
                return res;
            }
            long systemTimeMillis = U.nanosToMillis(this.systemTime.get());
            long totalTimeMillis = System.currentTimeMillis() - this.startTime();
            long userTimeMillis = Math.max(totalTimeMillis - systemTimeMillis, 0L);
            this.cctx.txMetrics().onNearTxComplete(systemTimeMillis, userTimeMillis);
            boolean bl = willBeSkipped = this.txDumpsThrottling == null || this.txDumpsThrottling.skipCurrent();
            if (!willBeSkipped) {
                boolean randomlyChosen;
                long transactionTimeDumpThreshold = this.cctx.tm().longTransactionTimeDumpThreshold();
                double transactionTimeDumpSamplesCoefficient = this.cctx.tm().transactionTimeDumpSamplesCoefficient();
                boolean isLong = transactionTimeDumpThreshold > 0L && totalTimeMillis > transactionTimeDumpThreshold;
                boolean bl2 = randomlyChosen = transactionTimeDumpSamplesCoefficient > 0.0 && ThreadLocalRandom.current().nextDouble() <= transactionTimeDumpSamplesCoefficient;
                if (randomlyChosen || isLong) {
                    String txDump = this.completedTransactionDump(state, systemTimeMillis, userTimeMillis, isLong);
                    if (isLong) {
                        log.warning(txDump);
                    } else {
                        log.info(txDump);
                    }
                    this.txDumpsThrottling.dump();
                }
            } else if (this.txDumpsThrottling != null) {
                this.txDumpsThrottling.skip();
            }
        }
        return res;
    }

    private String completedTransactionDump(TransactionState state, long systemTimeMillis, long userTimeMillis, boolean isLong) {
        long cacheOperationsTimeMillis = U.nanosToMillis(this.systemTime.get() - this.prepareTime.get() - this.commitOrRollbackTime.get());
        GridStringBuilder warning = new GridStringBuilder(isLong ? "Long transaction time dump " : "Transaction time dump ").a("[startTime=").a(IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(this.startTime))).a(", totalTime=").a(systemTimeMillis + userTimeMillis).a(", systemTime=").a(systemTimeMillis).a(", userTime=").a(userTimeMillis).a(", cacheOperationsTime=").a(cacheOperationsTimeMillis);
        if (state == TransactionState.COMMITTED) {
            warning.a(", prepareTime=").a(this.timeMillis(this.prepareTime)).a(", commitTime=").a(this.timeMillis(this.commitOrRollbackTime));
        } else {
            warning.a(", rollbackTime=").a(this.timeMillis(this.commitOrRollbackTime));
        }
        warning.a(", tx=").a(this).a("]");
        return warning.toString();
    }

    public IgniteInternalFuture<?> prepareNearTxLocal() {
        this.enterSystemSection();
        this.prepareStartTime.compareAndSet(0L, System.nanoTime());
        GridNearTxPrepareFutureAdapter fut = (GridNearTxPrepareFutureAdapter)this.prepFut;
        if (fut == null) {
            long timeout = this.remainingTime();
            fut = this.optimistic() ? (this.serializable() ? new GridNearOptimisticSerializableTxPrepareFuture(this.cctx, this) : new GridNearOptimisticTxPrepareFuture(this.cctx, this)) : new GridNearPessimisticTxPrepareFuture(this.cctx, this);
            if (!PREP_FUT_UPD.compareAndSet(this, null, fut)) {
                return this.prepFut;
            }
            if (this.trackTimeout) {
                this.prepFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        GridNearTxLocal.this.removeTimeoutHandler();
                    }
                });
            }
            if (timeout == -1L) {
                fut.onDone(this, this.timeoutException());
                return fut;
            }
        } else {
            return fut;
        }
        this.mapExplicitLocks();
        if (this.cctx.kernalContext().deploy().enabled() && this.deploymentLdrId != null) {
            U.restoreDeploymentContext(this.cctx.kernalContext(), this.deploymentLdrId);
        }
        fut.prepare();
        return fut;
    }

    @Override
    public IgniteInternalFuture<?> salvageTx() {
        assert (false) : "Should not be called for GridNearTxLocal";
        return null;
    }

    public final void prepare(boolean awaitLastFuture) throws IgniteCheckedException {
        if (awaitLastFuture) {
            this.txState().awaitLastFuture(this.cctx);
        }
        this.prepareNearTxLocal().get();
    }

    public void commit() throws IgniteCheckedException {
        this.commitNearTxLocalAsync().get();
    }

    public IgniteInternalFuture<IgniteInternalTx> commitNearTxLocalAsync() {
        boolean fastFinish;
        NearTxFinishFuture fut;
        NearTxFinishFuture fut0;
        if (log.isDebugEnabled()) {
            log.debug("Committing near local tx: " + this);
        }
        if ((fut0 = this.finishFut) != null || !FINISH_FUT_UPD.compareAndSet(this, null, fut = this.finishFuture(fastFinish = this.fastFinish(), true))) {
            return this.chainFinishFuture(this.finishFut, true, true, false);
        }
        if (!fastFinish) {
            IgniteInternalFuture<?> prepareFut;
            try {
                prepareFut = this.prepareNearTxLocal();
            }
            catch (Throwable t) {
                prepareFut = this.prepFut;
                assert (prepareFut != null);
                ((GridNearTxPrepareFutureAdapter)this.prepFut).onDone(t);
            }
            prepareFut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    GridNearTxLocal.this.prepareTime.compareAndSet(0L, System.nanoTime() - GridNearTxLocal.this.prepareStartTime.get());
                    GridNearTxLocal.this.commitOrRollbackStartTime.compareAndSet(0L, System.nanoTime());
                    try {
                        f.get();
                        fut.finish(true, true, false);
                    }
                    catch (Error | RuntimeException e) {
                        COMMIT_ERR_UPD.compareAndSet(GridNearTxLocal.this, null, e);
                        fut.finish(false, true, false);
                        throw e;
                    }
                    catch (IgniteCheckedException e) {
                        COMMIT_ERR_UPD.compareAndSet(GridNearTxLocal.this, null, e);
                        if (!(e instanceof NodeStoppingException)) {
                            fut.finish(false, true, true);
                        }
                        fut.onNodeStop(e);
                    }
                }
            });
        } else {
            fut.finish(true, false, false);
        }
        return fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> commitAsync() {
        return this.commitNearTxLocalAsync();
    }

    public void rollback() throws IgniteCheckedException {
        this.rollbackNearTxLocalAsync().get();
    }

    public IgniteInternalFuture<IgniteInternalTx> rollbackNearTxLocalAsync() {
        return this.rollbackNearTxLocalAsync(true, false);
    }

    public IgniteInternalFuture<IgniteInternalTx> rollbackNearTxLocalAsync(final boolean clearThreadMap, final boolean onTimeout) {
        NearTxFinishFuture fut0;
        if (log.isDebugEnabled()) {
            log.debug("Rolling back near tx: " + this);
        }
        this.enterSystemSection();
        this.commitOrRollbackStartTime.compareAndSet(0L, System.nanoTime());
        if (!onTimeout && this.trackTimeout) {
            this.removeTimeoutHandler();
        }
        IgniteInternalFuture<?> prepFut = this.prepFut;
        if (onTimeout && prepFut instanceof GridNearTxPrepareFutureAdapter && !prepFut.isDone()) {
            ((GridNearTxPrepareFutureAdapter)prepFut).onNearTxLocalTimeout();
        }
        if ((fut0 = this.finishFut) != null) {
            return this.chainFinishFuture(this.finishFut, false, clearThreadMap, onTimeout);
        }
        boolean fastFinish = clearThreadMap && this.fastFinish();
        final NearTxFinishFuture fut = this.finishFuture(fastFinish, false);
        if (!FINISH_FUT_UPD.compareAndSet(this, null, fut)) {
            return this.chainFinishFuture(this.finishFut, false, clearThreadMap, onTimeout);
        }
        this.rollbackFuture(fut);
        if (!fastFinish) {
            if (prepFut == null || prepFut.isDone()) {
                block12: {
                    try {
                        if (prepFut != null) {
                            prepFut.get();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("Got optimistic tx failure [tx=" + this + ", err=" + e + ']');
                    }
                }
                fut.finish(false, clearThreadMap, onTimeout);
            } else {
                prepFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f) {
                        block2: {
                            try {
                                f.get();
                            }
                            catch (IgniteCheckedException e) {
                                if (!log.isDebugEnabled()) break block2;
                                log.debug("Got optimistic tx failure [tx=" + this + ", err=" + e + ']');
                            }
                        }
                        fut.finish(false, clearThreadMap, onTimeout);
                    }
                });
            }
        } else {
            fut.finish(false, true, onTimeout);
        }
        return fut;
    }

    private NearTxFinishFuture finishFuture(boolean fast, boolean commit) {
        GridFutureAdapter fut = fast ? new GridNearTxFastFinishFuture(this, commit) : new GridNearTxFinishFuture(this.cctx, this, commit);
        return this.mvccSnapshot != null ? new GridNearTxFinishAndAckFuture((NearTxFinishFuture)((Object)fut)) : fut;
    }

    @Override
    public IgniteInternalFuture<IgniteInternalTx> rollbackAsync() {
        return this.rollbackNearTxLocalAsync();
    }

    private IgniteInternalFuture<IgniteInternalTx> chainFinishFuture(final NearTxFinishFuture fut, boolean commit, final boolean clearThreadMap, final boolean onTimeout) {
        assert (fut != null);
        if (fut.commit() != commit) {
            final GridNearTxLocal tx = this;
            if (!commit) {
                final GridNearTxFinishFuture rollbackFut = new GridNearTxFinishFuture(this.cctx, this, false);
                fut.listen(new IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>(){

                    @Override
                    public void apply(IgniteInternalFuture<IgniteInternalTx> fut0) {
                        block7: {
                            block6: {
                                if (!FINISH_FUT_UPD.compareAndSet(tx, fut, rollbackFut)) break block6;
                                switch (tx.state()) {
                                    case COMMITTED: {
                                        if (log.isDebugEnabled()) {
                                            log.debug("Failed to rollback, transaction is already committed: " + tx);
                                        }
                                    }
                                    case ROLLED_BACK: {
                                        rollbackFut.forceFinish();
                                        assert (rollbackFut.isDone()) : rollbackFut;
                                        break block7;
                                    }
                                    default: {
                                        rollbackFut.finish(false, clearThreadMap, onTimeout);
                                        break;
                                    }
                                }
                                break block7;
                            }
                            GridNearTxLocal.this.finishFut.listen(new IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>(){

                                @Override
                                public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                                    try {
                                        fut.get();
                                        rollbackFut.markInitialized();
                                    }
                                    catch (IgniteCheckedException e) {
                                        rollbackFut.onDone(e);
                                    }
                                }
                            });
                        }
                    }
                });
                return rollbackFut;
            }
            final GridFutureAdapter<IgniteInternalTx> fut0 = new GridFutureAdapter<IgniteInternalTx>();
            fut.listen(new IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>(){

                @Override
                public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                    if (GridNearTxLocal.this.timedOut()) {
                        fut0.onDone(new IgniteTxTimeoutCheckedException("Failed to commit transaction, transaction is concurrently rolled back on timeout: " + tx));
                    } else {
                        fut0.onDone(new IgniteTxRollbackCheckedException("Failed to commit transaction, transaction is concurrently rolled back: " + tx));
                    }
                }
            });
            return fut0;
        }
        return fut;
    }

    private boolean fastFinish() {
        return !this.queryEnlisted() && this.writeMap().isEmpty() && (this.optimistic() && !this.serializable() || this.readMap().isEmpty());
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareAsyncLocal(GridNearTxPrepareRequest req) {
        long timeout = this.remainingTime();
        if (this.state() != TransactionState.PREPARING) {
            if (timeout == -1L) {
                return new GridFinishedFuture<GridNearTxPrepareResponse>(this.timeoutException());
            }
            this.setRollbackOnly();
            return new GridFinishedFuture<GridNearTxPrepareResponse>(this.rollbackException());
        }
        if (timeout == -1L) {
            return new GridFinishedFuture<GridNearTxPrepareResponse>(this.timeoutException());
        }
        this.init();
        GridDhtTxPrepareFuture fut = new GridDhtTxPrepareFuture(this.cctx, this, timeout, 0, Collections.emptyMap(), req.last(), this.needReturnValue() && this.implicit());
        try {
            this.userPrepare(this.serializable() && this.optimistic() ? F.concat(false, req.writes(), req.reads()) : req.writes());
            this.cctx.mvcc().addFuture(fut);
            if (this.isSystemInvalidate()) {
                fut.complete();
            } else {
                fut.prepare(req);
            }
        }
        catch (IgniteTxOptimisticCheckedException | IgniteTxTimeoutCheckedException e) {
            fut.onError(e);
        }
        catch (IgniteCheckedException e) {
            this.setRollbackOnly();
            fut.onError(new IgniteTxRollbackCheckedException("Failed to prepare transaction: " + this, e));
        }
        return this.chainOnePhasePrepare(fut);
    }

    public IgniteInternalFuture<IgniteInternalTx> commitAsyncLocal() {
        if (log.isDebugEnabled()) {
            log.debug("Committing colocated tx locally: " + this);
        }
        GridFinishedFuture<IgniteInternalTx> prep = this.prepFut;
        if (F.isEmpty(this.dhtMap) && F.isEmpty(this.nearMap)) {
            GridFinishedFuture<IgniteInternalTx> fut;
            GridFinishedFuture<IgniteInternalTx> gridFinishedFuture = fut = prep != null ? prep : new GridFinishedFuture<IgniteInternalTx>(this);
            if (fut.isDone()) {
                this.cctx.tm().mvccFinish(this);
            } else {
                fut.listen(f -> this.cctx.tm().mvccFinish(this));
            }
            return fut;
        }
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, true);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        if (prep == null || prep.isDone()) {
            assert (prep != null || this.optimistic());
            IgniteCheckedException err = null;
            try {
                if (prep != null) {
                    prep.get();
                }
            }
            catch (IgniteCheckedException e) {
                err = e;
                U.error(log, "Failed to prepare transaction: " + this, e);
            }
            catch (Throwable t) {
                fut.onDone(t);
                throw t;
            }
            if (err != null) {
                fut.rollbackOnError(err);
            } else {
                fut.finish(true);
            }
        } else {
            prep.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    IgniteCheckedException err = null;
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        err = e;
                        U.error(log, "Failed to prepare transaction: " + this, e);
                    }
                    catch (Throwable t) {
                        fut.onDone(t);
                        throw t;
                    }
                    if (err != null) {
                        fut.rollbackOnError(err);
                    } else {
                        fut.finish(true);
                    }
                }
            });
        }
        return fut;
    }

    public IgniteInternalFuture<IgniteInternalTx> rollbackAsyncLocal() {
        if (log.isDebugEnabled()) {
            log.debug("Rolling back colocated tx locally: " + this);
        }
        final GridDhtTxFinishFuture fut = new GridDhtTxFinishFuture(this.cctx, this, false);
        this.cctx.mvcc().addFuture(fut, fut.futureId());
        IgniteInternalFuture<?> prep = this.prepFut;
        if (prep == null || prep.isDone()) {
            block6: {
                try {
                    if (prep != null) {
                        prep.get();
                    }
                }
                catch (IgniteCheckedException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("Failed to prepare transaction during rollback (will ignore) [tx=" + this + ", msg=" + e.getMessage() + ']');
                }
            }
            fut.finish(false);
        } else {
            prep.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> f) {
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        log.debug("Failed to prepare transaction during rollback (will ignore) [tx=" + this + ", msg=" + e.getMessage() + ']');
                    }
                    fut.finish(false);
                }
            });
        }
        return fut;
    }

    public <K> IgniteInternalFuture<GridCacheReturn> lockAllAsync(GridCacheContext cacheCtx, final Collection<? extends K> keys, boolean retval, boolean read, long createTtl, long accessTtl, boolean skipStore, boolean keepBinary) {
        long timeout;
        assert (this.pessimistic());
        try {
            this.checkValid();
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridCacheReturn>(e);
        }
        GridCacheReturn ret = new GridCacheReturn(this.localResult(), false);
        if (F.isEmpty(keys)) {
            return new GridFinishedFuture<GridCacheReturn>(ret);
        }
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Before acquiring transaction lock on keys: " + keys);
        }
        if ((timeout = this.remainingTime()) == -1L) {
            return new GridFinishedFuture<GridCacheReturn>(this.timeoutException());
        }
        GridDhtFuture<Boolean> fut = cacheCtx.colocated().lockAllAsyncInternal(keys, timeout, this, this.isInvalidate(), read, retval, this.isolation, createTtl, accessTtl, CU.empty0(), skipStore, keepBinary);
        return new GridEmbeddedFuture<GridCacheReturn, Boolean>(fut, new IgniteTxLocalAdapter.PLC1<GridCacheReturn>(ret, false){

            @Override
            protected GridCacheReturn postLock(GridCacheReturn ret) {
                if (log.isDebugEnabled()) {
                    log.debug("Acquired transaction lock on keys: " + keys);
                }
                return ret;
            }
        });
    }

    @Override
    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key) {
        if (cacheCtx.isColocated()) {
            IgniteTxEntry txEntry = this.entry(key);
            if (txEntry == null) {
                return cacheCtx.colocated().entryExx(key.key(), this.topologyVersion(), true);
            }
            GridCacheEntryEx cached = txEntry.cached();
            assert (cached != null);
            if (cached.detached()) {
                return cached;
            }
            if (cached.obsoleteVersion() != null) {
                cached = cacheCtx.colocated().entryExx(key.key(), this.topologyVersion(), true);
                txEntry.cached(cached);
            }
            return cached;
        }
        return cacheCtx.cache().entryEx(key.key());
    }

    @Override
    protected GridCacheEntryEx entryEx(GridCacheContext cacheCtx, IgniteTxKey key, AffinityTopologyVersion topVer) {
        if (cacheCtx.isColocated()) {
            IgniteTxEntry txEntry = this.entry(key);
            if (txEntry == null) {
                return cacheCtx.colocated().entryExx(key.key(), topVer, true);
            }
            GridCacheEntryEx cached = txEntry.cached();
            assert (cached != null);
            if (cached.detached()) {
                return cached;
            }
            if (cached.obsoleteVersion() != null) {
                cached = cacheCtx.colocated().entryExx(key.key(), topVer, true);
                txEntry.cached(cached);
            }
            return cached;
        }
        return cacheCtx.cache().entryEx(key.key(), topVer);
    }

    @Override
    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext ctx, IgniteTxKey key, @Nullable ExpiryPolicy expiryPlc) {
        assert (this.optimistic());
        IgniteCacheExpiryPolicy plc = ctx.cache().expiryPolicy(expiryPlc);
        if (plc != null) {
            if (this.accessMap == null) {
                this.accessMap = new HashMap<IgniteTxKey, IgniteCacheExpiryPolicy>();
            }
            this.accessMap.put(key, plc);
        }
        return plc;
    }

    @Override
    protected IgniteCacheExpiryPolicy accessPolicy(GridCacheContext cacheCtx, Collection<KeyCacheObject> keys) {
        assert (this.optimistic());
        if (this.accessMap != null) {
            for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
                if (e.getKey().cacheId() != cacheCtx.cacheId() || !keys.contains(e.getKey().key())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    @Override
    public void close() throws IgniteCheckedException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close(boolean clearThreadMap) throws IgniteCheckedException {
        TransactionState state;
        block23: {
            state = this.state();
            if (state != TransactionState.COMMITTED && state != TransactionState.ROLLED_BACK) break block23;
            if (clearThreadMap) {
                this.cctx.tm().clearThreadMap(this);
            }
            if (this.accessMap == null) return;
            assert (this.optimistic());
            for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
                if (e.getValue().entries() == null) continue;
                GridCacheContext cctx0 = this.cctx.cacheContext(e.getKey().cacheId());
                if (cctx0.isNear()) {
                    cctx0.near().dht().sendTtlUpdateRequest(e.getValue());
                    continue;
                }
                cctx0.dht().sendTtlUpdateRequest(e.getValue());
            }
            this.accessMap = null;
            return;
        }
        try {
            boolean rmv = false;
            if (this.trackTimeout) {
                rmv = this.removeTimeoutHandler();
            }
            if (state != TransactionState.COMMITTING && state != TransactionState.ROLLING_BACK && (!this.trackTimeout || rmv || this.prepFut != null && this.prepFut.isDone())) {
                this.rollbackNearTxLocalAsync(clearThreadMap, false).get();
            }
            Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e = this;
            synchronized (e) {
                block24: {
                    try {
                        while (!this.done()) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (this.done()) break block24;
                        throw new IgniteCheckedException("Got interrupted while waiting for transaction to complete: " + this, e2);
                    }
                }
            }
            if (clearThreadMap) {
                this.cctx.tm().clearThreadMap(this);
            }
            if (this.accessMap == null) return;
        }
        catch (Throwable throwable) {
            if (clearThreadMap) {
                this.cctx.tm().clearThreadMap(this);
            }
            if (this.accessMap == null) throw throwable;
            assert (this.optimistic());
            for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
                if (e.getValue().entries() == null) continue;
                GridCacheContext cctx0 = this.cctx.cacheContext(e.getKey().cacheId());
                if (cctx0.isNear()) {
                    cctx0.near().dht().sendTtlUpdateRequest(e.getValue());
                    continue;
                }
                cctx0.dht().sendTtlUpdateRequest(e.getValue());
            }
            this.accessMap = null;
            throw throwable;
        }
        assert (this.optimistic());
        for (Map.Entry<IgniteTxKey, IgniteCacheExpiryPolicy> e : this.accessMap.entrySet()) {
            if (((IgniteCacheExpiryPolicy)e.getValue()).entries() == null) continue;
            GridCacheContext cctx0 = this.cctx.cacheContext(((IgniteTxKey)e.getKey()).cacheId());
            if (cctx0.isNear()) {
                cctx0.near().dht().sendTtlUpdateRequest((IgniteCacheExpiryPolicy)e.getValue());
                continue;
            }
            cctx0.dht().sendTtlUpdateRequest((IgniteCacheExpiryPolicy)e.getValue());
        }
        this.accessMap = null;
        return;
    }

    @Override
    @Nullable
    public IgniteInternalFuture<?> currentPrepareFuture() {
        return this.prepFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemap(AffinityTopologyVersion topVer, boolean reset) {
        assert (this.cctx.kernalContext().clientNode());
        if (reset) {
            this.mapped = false;
            this.nearLocallyMapped = false;
            this.colocatedLocallyMapped = false;
            this.txNodes = null;
            this.onePhaseCommit = false;
            this.nearMap.clear();
            this.dhtMap.clear();
            this.mappings.clear();
        }
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            this.topVer = topVer;
        }
    }

    public void hasRemoteLocks(boolean hasRemoteLocks) {
        this.hasRemoteLocks = hasRemoteLocks;
    }

    public boolean hasRemoteLocks() {
        return this.hasRemoteLocks;
    }

    public boolean isOperationAllowed(boolean mvccOp) {
        if (this.mvccOp == null) {
            this.mvccOp = mvccOp;
            return true;
        }
        return this.mvccOp == mvccOp;
    }

    public TransactionProxy proxy() {
        if (this.proxy == null) {
            this.proxy = new TransactionProxyImpl(this, this.cctx, false);
        }
        return this.proxy;
    }

    public TransactionProxy rollbackOnlyProxy() {
        if (this.rollbackOnlyProxy == null) {
            this.rollbackOnlyProxy = new TransactionProxyRollbackOnlyImpl(this, this.cctx, false);
        }
        return this.rollbackOnlyProxy;
    }

    private <K, V> IgniteInternalFuture<Map<K, V>> checkMissed(final GridCacheContext cacheCtx, final AffinityTopologyVersion topVer, final Map<K, V> map, Map<KeyCacheObject, GridCacheVersion> missedMap, final boolean deserializeBinary, final boolean skipVals, final boolean keepCacheObjects, boolean skipStore, boolean recovery, boolean readRepair, final boolean needVer, ExpiryPolicy expiryPlc) {
        if (log.isDebugEnabled()) {
            log.debug("Loading missed values for missed map: " + missedMap);
        }
        final boolean needReadVer = this.serializable() && this.optimistic() || needVer;
        return new GridEmbeddedFuture(new C2<Void, Exception, Map<K, V>>(){

            @Override
            public Map<K, V> apply(Void v, Exception e) {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                if (GridNearTxLocal.this.isRollbackOnly()) {
                    if (GridNearTxLocal.this.timedOut()) {
                        throw new GridClosureException(new IgniteTxTimeoutCheckedException("Transaction has been timed out: " + GridNearTxLocal.this));
                    }
                    throw new GridClosureException(new IgniteTxRollbackCheckedException("Transaction has been rolled back: " + GridNearTxLocal.this));
                }
                return map;
            }
        }, this.loadMissing(cacheCtx, topVer, !skipStore, false, missedMap.keySet(), skipVals, needReadVer, !deserializeBinary, recovery, readRepair, expiryPlc, new GridInClosure3<KeyCacheObject, Object, GridCacheVersion>(){

            @Override
            public void apply(KeyCacheObject key, Object val, GridCacheVersion loadVer) {
                GridCacheEntryEx e;
                CacheObject cacheVal;
                CacheObject visibleVal = cacheVal = cacheCtx.toCacheObject(val);
                IgniteTxKey txKey = cacheCtx.txKey(key);
                IgniteTxEntry txEntry = GridNearTxLocal.this.entry(txKey);
                if (txEntry != null) {
                    if (!GridNearTxLocal.this.readCommitted()) {
                        txEntry.readValue(cacheVal);
                    }
                    if (!F.isEmpty(txEntry.entryProcessors())) {
                        visibleVal = txEntry.applyEntryProcessors(visibleVal);
                    }
                }
                assert (txEntry != null || GridNearTxLocal.this.readCommitted() || skipVals);
                GridCacheEntryEx gridCacheEntryEx = e = txEntry == null ? GridNearTxLocal.this.entryEx(cacheCtx, txKey, topVer) : txEntry.cached();
                if (GridNearTxLocal.this.readCommitted() || skipVals) {
                    e.touch();
                    if (visibleVal != null) {
                        cacheCtx.addResult(map, key, visibleVal, skipVals, keepCacheObjects, deserializeBinary, false, needVer ? loadVer : null, 0L, 0L, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                    }
                } else {
                    assert (txEntry != null);
                    txEntry.setAndMarkValid(cacheVal);
                    if (needReadVer) {
                        assert (loadVer != null);
                        txEntry.entryReadVersion(loadVer);
                    }
                    if (visibleVal != null) {
                        cacheCtx.addResult(map, key, visibleVal, skipVals, keepCacheObjects, deserializeBinary, false, needVer ? loadVer : null, 0L, 0L, U.deploymentClassLoader(GridNearTxLocal.this.cctx.kernalContext(), GridNearTxLocal.this.deploymentLdrId));
                    }
                }
            }
        }));
    }

    private boolean primaryLocal(GridCacheEntryEx entry) {
        return entry.context().affinity().primaryByPartition(this.cctx.localNode(), entry.partition(), AffinityTopologyVersion.NONE);
    }

    private boolean filter(GridCacheContext cctx, KeyCacheObject key, CacheObject val, CacheEntryPredicate[] filter) {
        return this.pessimistic() || this.optimistic() && this.implicit() || this.isAll(cctx, key, val, filter);
    }

    private boolean isAll(GridCacheContext cctx, KeyCacheObject key, final CacheObject val0, CacheEntryPredicate[] filter) {
        GridDhtDetachedCacheEntry e = new GridDhtDetachedCacheEntry(cctx, key){

            @Override
            @Nullable
            public CacheObject peekVisibleValue() {
                return val0;
            }
        };
        for (CacheEntryPredicate p0 : filter) {
            if (p0 == null || p0.apply(e)) continue;
            return false;
        }
        return true;
    }

    private void beforePut(GridCacheContext cacheCtx, boolean retval, boolean mvccOp) throws IgniteCheckedException {
        assert (!mvccOp || cacheCtx.mvccEnabled());
        this.checkUpdatesAllowed(cacheCtx);
        cacheCtx.checkSecurity(SecurityPermission.CACHE_PUT);
        if (cacheCtx.mvccEnabled() && !this.isOperationAllowed(mvccOp)) {
            throw new IgniteCheckedException(TX_TYPE_MISMATCH_ERR_MSG);
        }
        if (retval) {
            this.needReturnValue(true);
        }
        this.checkValid();
        this.init();
    }

    private void beforeRemove(GridCacheContext cacheCtx, boolean retval, boolean mvccOp) throws IgniteCheckedException {
        assert (!mvccOp || cacheCtx.mvccEnabled());
        this.checkUpdatesAllowed(cacheCtx);
        cacheCtx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        if (cacheCtx.mvccEnabled() && !this.isOperationAllowed(mvccOp)) {
            throw new IgniteCheckedException(TX_TYPE_MISMATCH_ERR_MSG);
        }
        if (retval) {
            this.needReturnValue(true);
        }
        this.checkValid();
    }

    private void checkUpdatesAllowed(GridCacheContext cacheCtx) throws IgniteCheckedException {
        if (!cacheCtx.updatesAllowed()) {
            throw new IgniteTxRollbackCheckedException(new CacheException("Updates are not allowed for transactional cache: " + cacheCtx.name() + ". Configure persistence store on client or use remote closure execution to start transactions from server nodes."));
        }
    }

    private static <T> IgniteInternalFuture<T> nonInterruptable(IgniteInternalFuture<T> fut) {
        if (fut instanceof GridFutureAdapter) {
            ((GridFutureAdapter)fut).ignoreInterrupts();
        }
        return fut;
    }

    public void threadId(long threadId) {
        this.threadId = threadId;
    }

    private boolean removeTimeoutHandler() {
        assert (this.trackTimeout);
        return this.cctx.time().removeTimeoutObject(this);
    }

    @Override
    public IgniteUuid timeoutId() {
        return this.xid();
    }

    @Override
    public long endTime() {
        return this.startTime() + this.timeout();
    }

    @Override
    public String label() {
        return this.lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimeout() {
        boolean proceed;
        GridNearTxLocal gridNearTxLocal = this;
        synchronized (gridNearTxLocal) {
            proceed = this.state() != TransactionState.PREPARED && this.state(TransactionState.MARKED_ROLLBACK, true);
        }
        if (proceed || this.state() == TransactionState.MARKED_ROLLBACK) {
            this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

                @Override
                public void run() {
                    GridNearTxLocal.this.rollbackNearTxLocalAsync(false, true);
                    U.warn(log, "The transaction was forcibly rolled back because a timeout is reached: " + CU.txString(GridNearTxLocal.this));
                }
            });
        } else if (log.isDebugEnabled()) {
            log.debug("Skip rollback tx on timeout: " + this);
        }
    }

    private long timeMillis(AtomicLong atomicNanoTime) {
        return U.nanosToMillis(atomicNanoTime.get());
    }

    public void enterSystemSection() {
        this.systemStartTime.compareAndSet(0L, System.nanoTime());
    }

    public void leaveSystemSection() {
        long systemStartTime0 = this.systemStartTime.getAndSet(0L);
        if (systemStartTime0 > 0L) {
            this.systemTime.addAndGet(System.nanoTime() - systemStartTime0);
        }
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxLocal.class, this, "thread", (Object)IgniteUtils.threadName(this.threadId), "mappings", (Object)this.mappings, "super", (Object)super.toString());
    }

    static /* synthetic */ GridCacheReturn access$4600(GridNearTxLocal x0) {
        return x0.implicitRes;
    }

    private class MvccTxSnapshotFuture
    extends MvccSnapshotFuture {
        private MvccTxSnapshotFuture() {
        }

        @Override
        public void onResponse(MvccSnapshot res) {
            GridNearTxLocal.this.onResponse0(res, this);
        }

        @Override
        public void onError(IgniteCheckedException err) {
            GridNearTxLocal.this.setRollbackOnly();
            super.onError(err);
        }
    }

    protected abstract class FinishClosure<T>
    implements IgniteBiClosure<T, Exception, T> {
        private static final long serialVersionUID = 0L;

        protected FinishClosure() {
        }

        @Override
        public final T apply(T t, @Nullable Exception e) {
            boolean rollback = true;
            try {
                if (e != null) {
                    throw new GridClosureException(e);
                }
                t = this.finish(t);
                if (GridNearTxLocal.this.implicit()) {
                    GridNearTxLocal.this.commit();
                }
                rollback = false;
                T t2 = t;
                return t2;
            }
            catch (IgniteCheckedException ex) {
                throw new GridClosureException(ex);
            }
            finally {
                if (rollback) {
                    GridNearTxLocal.this.setRollbackOnly();
                }
            }
        }

        abstract T finish(T var1) throws IgniteCheckedException;
    }
}

