/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Paths;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class FileLockHolder
implements AutoCloseable {
    private static final String lockFileName = "lock";
    private final File file;
    private final RandomAccessFile lockFile;
    private volatile FileLock lock;
    private final IgniteLogger log;

    protected FileLockHolder(String rootDir, IgniteLogger log) {
        try {
            this.file = Paths.get(rootDir, lockFileName).toFile();
            this.lockFile = new RandomAccessFile(this.file, "rw");
            this.log = log;
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    public abstract String lockInfo();

    protected abstract String warningMessage(String var1);

    public void tryLock(long lockWaitTimeMillis) throws IgniteCheckedException {
        String failMsg;
        assert (this.lockFile != null);
        FileChannel ch = this.lockFile.getChannel();
        try {
            String content = null;
            int i = 0;
            while ((long)i < lockWaitTimeMillis) {
                try {
                    this.lock = ch.tryLock(0L, 1L, false);
                    if (this.lock != null && this.lock.isValid()) {
                        this.writeContent(this.lockInfo());
                        return;
                    }
                }
                catch (OverlappingFileLockException ignore) {
                    if (content == null) {
                        content = this.readContent();
                    }
                    this.log.warning(this.warningMessage(content));
                }
                U.sleep(1000L);
                i += 1000;
            }
            if (content == null) {
                content = this.readContent();
            }
            failMsg = "Failed to acquire file lock [holder=" + content + ", time=" + lockWaitTimeMillis / 1000L + " sec, path=" + this.file.getAbsolutePath() + ']';
        }
        catch (Exception e) {
            throw new IgniteCheckedException(e);
        }
        if (failMsg != null) {
            throw new IgniteCheckedException(failMsg);
        }
    }

    private void writeContent(String content) throws IOException {
        FileChannel ch = this.lockFile.getChannel();
        byte[] bytes = content.getBytes();
        ByteBuffer buf = ByteBuffer.allocate(bytes.length);
        buf.put(bytes);
        buf.flip();
        ch.write(buf, 1L);
        ch.force(false);
    }

    private String readContent() throws IOException {
        FileChannel ch = this.lockFile.getChannel();
        ByteBuffer buf = ByteBuffer.allocate((int)(ch.size() - 1L));
        ch.read(buf, 1L);
        String content = new String(buf.array());
        buf.clear();
        return content;
    }

    public boolean isLocked() {
        return this.lock != null && this.lock.isValid();
    }

    public void release() {
        U.releaseQuiet(this.lock);
    }

    @Override
    public void close() {
        this.release();
        U.closeQuiet(this.lockFile);
    }

    public String lockPath() {
        return this.file.getAbsolutePath();
    }
}

