/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class RecoveryDebug
implements AutoCloseable {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd-MM-yyyy-HH-mm-ss-SSS").withZone(ZoneId.of("UTC"));
    @Nullable
    private final IgniteLogger log;
    @Nullable
    private FileChannel fc;

    public RecoveryDebug(Object constId, long time) {
        this(constId, time, null);
    }

    public RecoveryDebug(Object constId, long time, @Nullable IgniteLogger log) {
        this.log = log;
        try {
            String workDir = U.defaultWorkDirectory();
            File tmpDir = new File(workDir, "tmp");
            if (!tmpDir.exists() && !tmpDir.mkdir()) {
                return;
            }
            File f = new File(tmpDir, "recovery-" + DATE_FORMATTER.format(Instant.ofEpochMilli(time)) + "-" + constId + ".log");
            f.createNewFile();
            this.fc = FileChannel.open(Paths.get(f.getPath(), new String[0]), EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE), new FileAttribute[0]);
        }
        catch (IOException | IgniteCheckedException e) {
            U.error(log, "Fail create recovery debug file.", e);
            this.fc = null;
        }
    }

    public RecoveryDebug append(TxRecord rec) {
        GridCacheVersion txVer = rec.nearXidVersion();
        return this.fc == null ? this : this.appendFile("Tx record " + (Object)((Object)rec.state()) + " " + rec.nearXidVersion() + " timestamp " + rec.timestamp());
    }

    public RecoveryDebug append(DataRecord rec, boolean unwrapKeyValue) {
        if (this.fc == null) {
            return this;
        }
        this.append("Data record\n");
        for (DataEntry dataEntry : rec.writeEntries()) {
            this.append("\t" + (Object)((Object)dataEntry.op()) + " " + dataEntry.nearXidVersion() + (unwrapKeyValue ? " " + dataEntry.key() + " " + dataEntry.value() : "") + "\n");
        }
        return this;
    }

    public RecoveryDebug append(Object st) {
        return this.fc == null ? this : this.appendFile(st);
    }

    private RecoveryDebug appendFile(Object st) {
        try {
            this.fc.write(ByteBuffer.wrap(st.toString().getBytes()));
        }
        catch (IOException e) {
            U.error(null, "Fail write to recovery dump file.", e);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.fc != null) {
            try {
                this.fc.force(true);
                this.fc.close();
            }
            catch (IOException e) {
                U.error(null, "Fail close recovery dump file.", e);
            }
        }
    }
}

