/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class LightweightCheckpointManager {
    private volatile Checkpointer checkpointer;
    private final CheckpointWorkflow checkpointWorkflow;
    final CheckpointTimeoutLock checkpointTimeoutLock;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    private final Supplier<Checkpointer> checkpointerProvider;

    public LightweightCheckpointManager(Function<Class<?>, IgniteLogger> logger, String igniteInstanceName, String checkpointThreadName, WorkersRegistry workersRegistry, final DataStorageConfiguration persistenceCfg, Supplier<Collection<DataRegion>> dataRegions, IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver, PageMemoryImpl.ThrottlingPolicy throttlingPolicy, IgniteCacheSnapshotManager snapshotMgr, DataStorageMetricsImpl persStoreMetrics, LongJVMPauseDetector longJvmPauseDetector, FailureProcessor failureProcessor, GridCacheProcessor cacheProcessor) throws IgniteCheckedException {
        CheckpointReadWriteLock lock = new CheckpointReadWriteLock(logger);
        this.checkpointWorkflow = new CheckpointWorkflow(logger, null, snapshotMgr, null, lock, persistenceCfg.getCheckpointWriteOrder(), dataRegions, Collections::emptyList, persistenceCfg.getCheckpointThreads(), igniteInstanceName);
        ThreadLocal<ByteBuffer> threadBuf = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(persistenceCfg.getPageSize());
                tmpWriteBuf.order(ByteOrder.nativeOrder());
                return tmpWriteBuf;
            }
        };
        this.checkpointPagesWriterFactory = new CheckpointPagesWriterFactory(logger, snapshotMgr, (pageMemEx, fullPage, buf, tag) -> pageMemEx.pageManager().write(fullPage.groupId(), fullPage.pageId(), buf, tag, true), persStoreMetrics, throttlingPolicy, threadBuf, pageMemoryGroupResolver);
        this.checkpointerProvider = () -> new Checkpointer(igniteInstanceName, checkpointThreadName, workersRegistry, logger, longJvmPauseDetector, failureProcessor, snapshotMgr, persStoreMetrics, cacheProcessor, this.checkpointWorkflow, this.checkpointPagesWriterFactory, persistenceCfg.getCheckpointFrequency(), persistenceCfg.getCheckpointThreads(), () -> 0);
        this.checkpointer = this.checkpointerProvider.get();
        Long cfgCheckpointReadLockTimeout = persistenceCfg != null ? persistenceCfg.getCheckpointReadLockTimeout() : null;
        long checkpointReadLockTimeout = IgniteSystemProperties.getLong("IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT", cfgCheckpointReadLockTimeout != null ? cfgCheckpointReadLockTimeout.longValue() : workersRegistry.getSystemWorkerBlockedTimeout());
        this.checkpointTimeoutLock = new CheckpointTimeoutLock(logger, failureProcessor, dataRegions, lock, this.checkpointer, checkpointReadLockTimeout);
    }

    public CheckpointTimeoutLock checkpointTimeoutLock() {
        return this.checkpointTimeoutLock;
    }

    public void threadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.checkpointPagesWriterFactory.threadBuf(threadBuf);
    }

    public void addCheckpointListener(CheckpointListener lsnr, DataRegion dataRegion) {
        this.checkpointWorkflow.addCheckpointListener(lsnr, dataRegion);
    }

    public void removeCheckpointListener(CheckpointListener lsnr) {
        this.checkpointWorkflow.removeCheckpointListener(lsnr);
    }

    public void memoryRecoveryRecordPtr(WALPointer memoryRecoveryRecordPtr) {
        this.checkpointWorkflow.memoryRecoveryRecordPtr(memoryRecoveryRecordPtr);
    }

    public <R> CheckpointProgress forceCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return null;
        }
        return cp.scheduleCheckpoint(0L, reason, lsnr);
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public void schedulePartitionDestroy(@Nullable CacheGroupContext context, int groupId, int partId) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.schedulePartitionDestroy(context, groupId, partId);
        }
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        return this.checkpointer.enableCheckpoints(enable);
    }

    public void finalizeCheckpointOnRecovery(long ts, UUID id, WALPointer ptr, StripedExecutor exec) throws IgniteCheckedException {
        assert (this.checkpointer != null) : "Checkpointer hasn't initialized yet";
        this.checkpointer.finalizeCheckpointOnRecovery(ts, id, ptr, exec);
    }

    public boolean cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        return cp != null && cp.cancelOrWaitPartitionDestroy(grpId, partId);
    }

    public void stop(boolean cancel) {
        this.checkpointTimeoutLock.stop();
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.shutdownCheckpointer(cancel);
        }
        this.checkpointWorkflow.stop();
        this.checkpointer = null;
    }

    public void init() {
        if (this.checkpointer == null) {
            this.checkpointWorkflow.start();
            this.checkpointer = this.checkpointerProvider.get();
        }
    }

    public void start() {
        assert (this.checkpointer != null) : "Checkpointer can't be null during the start";
        this.checkpointer.start();
    }

    public void unblockCheckpointLock() {
        this.checkpointTimeoutLock.start();
    }
}

