/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class SnapshotHandlerRestoreTask
extends AbstractSnapshotVerificationTask {
    private static final long serialVersionUID = 0L;
    @LoggerResource
    private IgniteLogger log;

    @Override
    protected ComputeJob createJob(String snpName, String constId, Collection<String> groups) {
        return new SnapshotHandlerRestoreJob(snpName, constId, groups);
    }

    @Override
    @Nullable
    public SnapshotPartitionsVerifyTaskResult reduce(List<ComputeJobResult> results) {
        HashMap clusterResults = new HashMap();
        ArrayList<UUID> execNodes = new ArrayList<UUID>(results.size());
        for (ComputeJobResult res : results) {
            if (res.getException() != null) {
                throw res.getException();
            }
            execNodes.add(res.getNode().id());
            Map nodeDataMap = (Map)res.getData();
            assert (nodeDataMap != null) : "At least the default snapshot restore handler should have been executed ";
            for (Map.Entry entry : nodeDataMap.entrySet()) {
                String hndName = (String)entry.getKey();
                clusterResults.computeIfAbsent(hndName, v -> new ArrayList()).add(entry.getValue());
            }
        }
        String snapshotName = ((SnapshotMetadata)F.first((List)F.first(this.metas.values()))).snapshotName();
        try {
            this.ignite.context().cache().context().snapshotMgr().handlers().completeAll(SnapshotHandlerType.RESTORE, snapshotName, clusterResults, execNodes);
        }
        catch (Exception e) {
            this.log.warning("The snapshot operation will be aborted due to a handler error [snapshot=" + snapshotName + "].", e);
            throw new IgniteException(e);
        }
        return new SnapshotPartitionsVerifyTaskResult(this.metas, null);
    }

    private static class SnapshotHandlerRestoreJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private final String snpName;
        private final String consistentId;
        private final Collection<String> grps;

        public SnapshotHandlerRestoreJob(String snpName, String consistentId, Collection<String> grps) {
            this.snpName = snpName;
            this.consistentId = consistentId;
            this.grps = grps;
        }

        @Override
        public Map<String, SnapshotHandlerResult<Object>> execute() {
            try {
                IgniteSnapshotManager snpMgr = this.ignite.context().cache().context().snapshotMgr();
                SnapshotMetadata meta = snpMgr.readSnapshotMetadata(this.snpName, this.consistentId);
                SnapshotHandlerContext ctx = new SnapshotHandlerContext(meta, this.grps, this.ignite.localNode());
                return snpMgr.handlers().invokeAll(SnapshotHandlerType.RESTORE, ctx);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }
}

