/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwarePendingEntryInnerIO;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwarePendingEntryLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingEntryInnerIO;
import org.apache.ignite.internal.processors.cache.tree.PendingEntryLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.PendingRowIO;

public class PendingEntriesTree
extends BPlusTree<PendingRow, PendingRow> {
    public static final Object WITHOUT_KEY = new Object();
    private final CacheGroupContext grp;

    public PendingEntriesTree(CacheGroupContext grp, String name, PageMemory pageMem, long metaPageId, ReuseList reuseList, boolean initNew, PageLockTrackerManager pageLockTrackerManager, byte pageFlag) throws IgniteCheckedException {
        super(name, grp.groupId(), grp.name(), pageMem, grp.dataRegion().config().isPersistenceEnabled() ? grp.shared().wal() : null, grp.offheap().globalRemoveId(), metaPageId, reuseList, grp.sharedGroup() ? CacheIdAwarePendingEntryInnerIO.VERSIONS : PendingEntryInnerIO.VERSIONS, grp.sharedGroup() ? CacheIdAwarePendingEntryLeafIO.VERSIONS : PendingEntryLeafIO.VERSIONS, pageFlag, grp.shared().kernalContext().failure(), pageLockTrackerManager);
        this.grp = grp;
        assert (!grp.dataRegion().config().isPersistenceEnabled() || grp.shared().database().checkpointLockIsHeldByThread());
        this.initTree(initNew);
    }

    @Override
    protected int compare(BPlusIO<PendingRow> iox, long pageAddr, int idx, PendingRow row) {
        long expireTime;
        int cmp;
        PendingRowIO io = (PendingRowIO)((Object)iox);
        if (this.grp.sharedGroup()) {
            assert (row.cacheId != 0) : "Cache ID is not provided!";
            assert (io.getCacheId(pageAddr, idx) != 0) : "Cache ID is not stored!";
            cmp = Integer.compare(io.getCacheId(pageAddr, idx), row.cacheId);
            if (cmp != 0) {
                return cmp;
            }
            if (row.expireTime == 0L && row.link == 0L) {
                return cmp;
            }
        }
        if ((cmp = Long.compare(expireTime = io.getExpireTime(pageAddr, idx), row.expireTime)) != 0) {
            return cmp;
        }
        if (row.link == 0L) {
            return 0;
        }
        long link = io.getLink(pageAddr, idx);
        return Long.compare(link, row.link);
    }

    @Override
    public PendingRow getRow(BPlusIO<PendingRow> io, long pageAddr, int idx, Object flag) throws IgniteCheckedException {
        PendingRow row = io.getLookupRow(this, pageAddr, idx);
        return flag == WITHOUT_KEY ? row : row.initKey(this.grp);
    }
}

