/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.event.CacheEntryEventFilter;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cache.query.ContinuousQuery;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformJavaObjectFactoryProxy;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryContinuousHandle;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheQueryContinuousResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheRequest;

public class ClientCacheQueryContinuousRequest
extends ClientCacheRequest {
    private final ContinuousQuery qry;
    private final Object filter;
    private final byte filterPlatform;

    public ClientCacheQueryContinuousRequest(BinaryRawReaderEx reader) {
        super(reader);
        int pageSize = reader.readInt();
        long timeInterval = reader.readLong();
        boolean includeExpired = reader.readBoolean();
        this.filter = reader.readObjectDetached();
        this.filterPlatform = this.filter == null ? (byte)0 : reader.readByte();
        this.qry = new ContinuousQuery();
        ((ContinuousQuery)this.qry.setPageSize(pageSize)).setTimeInterval(timeInterval).setIncludeExpired(includeExpired);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        this.qry.setRemoteFilterFactory(this.getFilterFactory(ctx));
        ctx.incrementCursors();
        try {
            IgniteCache cache = this.filterPlatform == 1 && !this.isKeepBinary() ? this.rawCache(ctx) : this.cache(ctx);
            ClientCacheQueryContinuousHandle handle = new ClientCacheQueryContinuousHandle(ctx);
            this.qry.setLocalListener(handle);
            QueryCursor cur = cache.query(this.qry);
            long cursorId = ctx.resources().put(handle);
            handle.setCursor(cur);
            return new ClientCacheQueryContinuousResponse(this.requestId(), handle, cursorId);
        }
        catch (Exception e) {
            ctx.decrementCursors();
            throw e;
        }
    }

    private Factory<? extends CacheEntryEventFilter> getFilterFactory(ClientConnectionContext ctx) {
        if (this.filter == null) {
            return null;
        }
        if (!(this.filter instanceof BinaryObject)) {
            throw new IgniteClientException(1, "Filter must be a BinaryObject: " + this.filter.getClass());
        }
        BinaryObjectImpl bo = (BinaryObjectImpl)this.filter;
        switch (this.filterPlatform) {
            case 1: {
                if (bo.typeId() == 99) {
                    PlatformJavaObjectFactoryProxy prx = (PlatformJavaObjectFactoryProxy)bo.deserialize();
                    CacheEntryEventSerializableFilter rmtFilter = (CacheEntryEventSerializableFilter)prx.factory(ctx.kernalContext()).create();
                    return FactoryBuilder.factoryOf(rmtFilter);
                }
                return (Factory)bo.deserialize();
            }
            case 2: {
                PlatformContext platformCtx = ctx.kernalContext().platform().context();
                String curPlatform = platformCtx.platform();
                if (!"dotnet".equals(curPlatform)) {
                    throw new IgniteClientException(1, "ContinuousQuery filter platform is dotnet, current platform is " + curPlatform);
                }
                return FactoryBuilder.factoryOf(platformCtx.createContinuousQueryFilter(this.filter));
            }
        }
        throw new IgniteClientException(1, "Unsupported filter platform: " + this.filterPlatform);
    }
}

