/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.aware;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusHolder;
import org.apache.ignite.internal.processors.query.aware.IndexRebuildCacheInfo;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class IndexBuildStatusStorage
implements MetastorageLifecycleListener,
CheckpointListener {
    public static final String KEY_PREFIX = "rebuild-sql-indexes-";
    private final GridKernalContext ctx;
    private final Object metaStorageMux = new Object();
    private final GridBusyLock stopNodeLock = new GridBusyLock();
    private final ConcurrentMap<String, IndexBuildStatusHolder> statuses = new ConcurrentHashMap<String, IndexBuildStatusHolder>();

    public IndexBuildStatusStorage(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    public void start() {
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    public void onCacheKernalStart() {
        HashSet toComplete = new HashSet(this.statuses.keySet());
        toComplete.removeAll(this.ctx.cache().cacheDescriptors().keySet());
        for (String cacheName : toComplete) {
            this.onFinishRebuildIndexes(cacheName);
        }
    }

    public void stop() {
        this.stopNodeLock.block();
    }

    public void onStartRebuildIndexes(GridCacheContext cacheCtx) {
        this.onStartOperation(cacheCtx, true);
    }

    public void onStartBuildNewIndex(GridCacheContext cacheCtx) {
        this.onStartOperation(cacheCtx, false);
    }

    public void onFinishRebuildIndexes(String cacheName) {
        this.onFinishOperation(cacheName, true);
    }

    public void onFinishBuildNewIndex(String cacheName) {
        this.onFinishOperation(cacheName, false);
    }

    public boolean rebuildCompleted(String cacheName) {
        IndexBuildStatusHolder status = (IndexBuildStatusHolder)this.statuses.get(cacheName);
        return status == null || !status.rebuild();
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) {
        ((GridCacheDatabaseSharedManager)this.ctx.cache().context().database()).addCheckpointListener(this);
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            this.metaStorageOperation(metaStorage -> {
                assert (metaStorage != null);
                metaStorage.iterate(KEY_PREFIX, (k, v) -> {
                    IndexRebuildCacheInfo cacheInfo = (IndexRebuildCacheInfo)v;
                    this.statuses.put(cacheInfo.cacheName(), new IndexBuildStatusHolder(true, true));
                }, true);
            });
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            for (IndexBuildStatusHolder status : this.statuses.values()) {
                if (status.delete()) assert (status.persistent());
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) {
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCheckpointEnd(CheckpointListener.Context ctx) {
        if (!this.stopNodeLock.enterBusy()) {
            return;
        }
        try {
            for (String cacheName : this.statuses.keySet()) {
                IndexBuildStatusHolder newVal = this.statuses.compute(cacheName, (k, prev) -> prev != null && prev.status() == IndexBuildStatusHolder.Status.DELETE ? null : prev);
                if (newVal != null) continue;
                this.metaStorageOperation(metaStorage -> {
                    assert (metaStorage != null);
                    if (!this.statuses.containsKey(cacheName)) {
                        metaStorage.remove(IndexBuildStatusStorage.metaStorageKey(cacheName));
                    }
                });
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaStorageOperation(IgniteThrowableConsumer<MetaStorage> consumer) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            IgniteCacheDatabaseSharedManager db = this.ctx.cache().context().database();
            db.checkpointReadLock();
            try {
                consumer.accept(db.metaStorage());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
    }

    private static String metaStorageKey(String cacheName) {
        return KEY_PREFIX + cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStartOperation(GridCacheContext cacheCtx, boolean rebuild) {
        if (!this.stopNodeLock.enterBusy()) {
            throw new IgniteException("Node is stopping.");
        }
        try {
            String cacheName = cacheCtx.name();
            boolean persistent = CU.isPersistentCache(cacheCtx.config(), this.ctx.config().getDataStorageConfiguration());
            this.statuses.compute(cacheName, (k, prev) -> {
                if (prev != null) {
                    prev.onStartOperation(rebuild);
                    return prev;
                }
                return new IndexBuildStatusHolder(persistent, rebuild);
            });
            if (persistent) {
                this.metaStorageOperation(metaStorage -> {
                    assert (metaStorage != null);
                    metaStorage.write(IndexBuildStatusStorage.metaStorageKey(cacheName), new IndexRebuildCacheInfo(cacheName));
                });
            }
        }
        finally {
            this.stopNodeLock.leaveBusy();
        }
    }

    private void onFinishOperation(String cacheName, boolean rebuild) {
        this.statuses.compute(cacheName, (k, prev) -> {
            if (prev != null && prev.onFinishOperation(rebuild) == IndexBuildStatusHolder.Status.COMPLETE && !prev.persistent()) {
                return null;
            }
            return prev;
        });
    }
}

