/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.plugin.segmentation.SegmentationPolicy;
import org.jetbrains.annotations.Nullable;

public class VisorSegmentationConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private SegmentationPolicy plc;
    private String resolvers;
    private long checkFreq;
    private boolean waitOnStart;
    private boolean allResolversPassReq;
    private int segResolveAttempts;

    public VisorSegmentationConfiguration() {
    }

    public VisorSegmentationConfiguration(IgniteConfiguration c) {
        this.plc = c.getSegmentationPolicy();
        this.resolvers = VisorTaskUtils.compactArray(c.getSegmentationResolvers());
        this.checkFreq = c.getSegmentCheckFrequency();
        this.waitOnStart = c.isWaitForSegmentOnStart();
        this.allResolversPassReq = c.isAllSegmentationResolversPassRequired();
        this.segResolveAttempts = c.getSegmentationResolveAttempts();
    }

    public SegmentationPolicy getPolicy() {
        return this.plc;
    }

    @Nullable
    public String getResolvers() {
        return this.resolvers;
    }

    public long getCheckFrequency() {
        return this.checkFreq;
    }

    public boolean isWaitOnStart() {
        return this.waitOnStart;
    }

    public boolean isAllSegmentationResolversPassRequired() {
        return this.allResolversPassReq;
    }

    public int getSegmentationResolveAttempts() {
        return this.segResolveAttempts;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.plc);
        U.writeString(out, this.resolvers);
        out.writeLong(this.checkFreq);
        out.writeBoolean(this.waitOnStart);
        out.writeBoolean(this.allResolversPassReq);
        out.writeInt(this.segResolveAttempts);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.plc = SegmentationPolicy.fromOrdinal(in.readByte());
        this.resolvers = U.readString(in);
        this.checkFreq = in.readLong();
        this.waitOnStart = in.readBoolean();
        this.allResolversPassReq = in.readBoolean();
        this.segResolveAttempts = in.readInt();
    }

    public String toString() {
        return S.toString(VisorSegmentationConfiguration.class, this);
    }
}

