/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.netcrusher.NetCrusher;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.meter.RateMeters;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.state.BitState;
import org.netcrusher.datagram.DatagramCrusherOptions;
import org.netcrusher.datagram.DatagramCrusherSocketOptions;
import org.netcrusher.datagram.DatagramFilters;
import org.netcrusher.datagram.DatagramInner;
import org.netcrusher.datagram.DatagramOuter;
import org.netcrusher.datagram.callback.DatagramClientCreation;
import org.netcrusher.datagram.callback.DatagramClientDeletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramCrusher
implements NetCrusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramCrusher.class);
    private final NioReactor reactor;
    private final DatagramCrusherSocketOptions socketOptions;
    private final InetSocketAddress bindAddress;
    private final InetSocketAddress connectAddress;
    private final InetSocketAddress bindBeforeConnectAddress;
    private final BufferOptions bufferOptions;
    private final DatagramFilters filters;
    private final DatagramClientCreation creationListener;
    private final DatagramClientDeletion deletionListener;
    private final boolean deferredListeners;
    private final State state;
    private DatagramInner inner;

    public DatagramCrusher(DatagramCrusherOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options are not set");
        }
        options.validate();
        this.filters = new DatagramFilters(options.getIncomingTransformFilterFactory(), options.getOutgoingTransformFilterFactory(), options.getIncomingPassFilterFactory(), options.getOutgoingPassFilterFactory(), options.getIncomingGlobalThrottler(), options.getOutgoingThrottlerFactory());
        this.reactor = options.getReactor();
        this.bindAddress = options.getBindAddress();
        this.connectAddress = options.getConnectAddress();
        this.bindBeforeConnectAddress = options.getBindBeforeConnectAddress();
        this.socketOptions = options.getSocketOptions().copy();
        this.bufferOptions = options.getBufferOptions().copy();
        this.creationListener = options.getCreationListener();
        this.deletionListener = options.getDeletionListener();
        this.deferredListeners = options.isDeferredListeners();
        this.state = new State(State.CLOSED);
    }

    void notifyOuterCreated(DatagramOuter outer) {
        if (this.creationListener != null) {
            Runnable r = () -> this.creationListener.created(outer.getClientAddress());
            this.reactor.getScheduler().executeListener(r, this.deferredListeners);
        }
    }

    void notifyOuterDeleted(DatagramOuter outer) {
        if (this.deletionListener != null) {
            Runnable r = () -> this.deletionListener.deleted(outer.getClientAddress(), outer.getByteMeters(), outer.getPacketMeters());
            this.reactor.getScheduler().executeListener(r, this.deferredListeners);
        }
    }

    @Override
    public void open() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.CLOSED)) {
                this.inner = new DatagramInner(this, this.reactor, this.socketOptions, this.bufferOptions, this.filters, this.bindAddress, this.connectAddress, this.bindBeforeConnectAddress);
                this.inner.unfreeze();
                LOGGER.info("DatagramCrusher <{}>-<{}> is started", (Object)this.bindAddress, (Object)this.connectAddress);
                this.state.set(State.OPEN);
                return true;
            }
            throw new IllegalStateException("DatagramCrusher is already open");
        });
    }

    @Override
    public void close() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                if (this.state.is(State.OPEN)) {
                    this.freeze();
                }
                this.inner.close();
                this.inner = null;
                this.state.set(State.CLOSED);
                LOGGER.info("DatagramCrusher <{}>-<{}> is closed", (Object)this.bindAddress, (Object)this.connectAddress);
                return true;
            }
            return false;
        });
    }

    @Override
    public void reopen() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                this.close();
                this.open();
                return true;
            }
            throw new IllegalStateException("DatagramCrusher is not open");
        });
    }

    @Override
    public boolean isOpen() {
        return this.state.isAnyOf(State.OPEN | State.FROZEN);
    }

    @Override
    public void freeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.OPEN)) {
                if (!this.inner.isFrozen()) {
                    this.inner.freeze();
                }
                this.state.set(State.FROZEN);
                return true;
            }
            throw new IllegalStateException("Datagram\u0421rusher is not open on freeze");
        });
    }

    @Override
    public void unfreeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.FROZEN)) {
                if (this.inner.isFrozen()) {
                    this.inner.unfreeze();
                }
                this.state.set(State.OPEN);
                return true;
            }
            throw new IllegalStateException("DatagramCrusher is not frozen on unfreeze");
        });
    }

    @Override
    public boolean isFrozen() {
        return this.state.isAnyOf(State.FROZEN | State.CLOSED);
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    @Override
    public Collection<InetSocketAddress> getClientAddresses() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.getOuters().stream().map(DatagramOuter::getClientAddress).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
    }

    @Override
    public RateMeters getClientByteMeters(InetSocketAddress clientAddress) {
        return this.reactor.getSelector().execute(() -> {
            DatagramOuter outer;
            if (this.state.not(State.CLOSED) && (outer = this.inner.getOuter(clientAddress)) != null) {
                return outer.getByteMeters();
            }
            return null;
        });
    }

    public RateMeters getClientPacketMeters(InetSocketAddress clientAddress) {
        return this.reactor.getSelector().execute(() -> {
            DatagramOuter outer;
            if (this.state.not(State.CLOSED) && (outer = this.inner.getOuter(clientAddress)) != null) {
                return outer.getPacketMeters();
            }
            return null;
        });
    }

    public RateMeters getInnerByteMeters() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.getByteMeters();
            }
            return null;
        });
    }

    public RateMeters getInnerPacketMeters() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.getPacketMeters();
            }
            return null;
        });
    }

    @Override
    public boolean closeClient(InetSocketAddress clientAddress) {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.closeOuter(clientAddress);
            }
            return false;
        });
    }

    public int closeIdleClients(long maxIdleDuration, TimeUnit timeUnit) {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.closeIdleOuters(timeUnit.toMillis(maxIdleDuration));
            }
            return 0;
        });
    }

    @Override
    public int getClientTotalCount() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.inner.getClientTotalCount();
            }
            return 0;
        });
    }

    private static final class State
    extends BitState {
        private static final int OPEN = State.bit(0);
        private static final int FROZEN = State.bit(1);
        private static final int CLOSED = State.bit(2);

        private State(int state) {
            super(state);
        }
    }
}

