/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram;

import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import org.netcrusher.core.filter.PassFilterFactory;
import org.netcrusher.core.filter.TransformFilterFactory;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.Throttler;
import org.netcrusher.core.throttle.ThrottlerFactory;
import org.netcrusher.datagram.DatagramCrusher;
import org.netcrusher.datagram.DatagramCrusherOptions;
import org.netcrusher.datagram.callback.DatagramClientCreation;
import org.netcrusher.datagram.callback.DatagramClientDeletion;

public final class DatagramCrusherBuilder {
    private final DatagramCrusherOptions options = new DatagramCrusherOptions();

    private DatagramCrusherBuilder() {
    }

    public static DatagramCrusherBuilder builder() {
        return new DatagramCrusherBuilder();
    }

    public DatagramCrusherBuilder withBindAddress(InetSocketAddress address) {
        this.options.setBindAddress(address);
        return this;
    }

    public DatagramCrusherBuilder withBindAddress(String hostname, int port) {
        return this.withBindAddress(new InetSocketAddress(hostname, port));
    }

    public DatagramCrusherBuilder withConnectAddress(InetSocketAddress address) {
        this.options.setConnectAddress(address);
        return this;
    }

    public DatagramCrusherBuilder withConnectAddress(String hostname, int port) {
        return this.withConnectAddress(new InetSocketAddress(hostname, port));
    }

    public DatagramCrusherBuilder withBindBeforeConnectAddress(InetSocketAddress address) {
        this.options.setBindBeforeConnectAddress(address);
        return this;
    }

    public DatagramCrusherBuilder withBindBeforeConnectAddress(String hostname, int port) {
        return this.withBindBeforeConnectAddress(new InetSocketAddress(hostname, port));
    }

    public DatagramCrusherBuilder withReactor(NioReactor reactor) {
        this.options.setReactor(reactor);
        return this;
    }

    public DatagramCrusherBuilder withBroadcast(boolean broadcast) {
        this.options.getSocketOptions().setBroadcast(broadcast);
        return this;
    }

    public DatagramCrusherBuilder withProtocolFamily(ProtocolFamily protocolFamily) {
        this.options.getSocketOptions().setProtocolFamily(protocolFamily);
        return this;
    }

    public DatagramCrusherBuilder withRcvBufferSize(int bufferSize) {
        this.options.getSocketOptions().setRcvBufferSize(bufferSize);
        return this;
    }

    public DatagramCrusherBuilder withSndBufferSize(int bufferSize) {
        this.options.getSocketOptions().setSndBufferSize(bufferSize);
        return this;
    }

    public DatagramCrusherBuilder withBufferCount(int bufferCount) {
        this.options.getBufferOptions().setCount(bufferCount);
        return this;
    }

    public DatagramCrusherBuilder withBufferSize(int bufferSize) {
        this.options.getBufferOptions().setSize(bufferSize);
        return this;
    }

    public DatagramCrusherBuilder withBufferDirect(boolean direct) {
        this.options.getBufferOptions().setDirect(direct);
        return this;
    }

    public DatagramCrusherBuilder withOutgoingTransformFilterFactory(TransformFilterFactory filterFactory) {
        this.options.setOutgoingTransformFilterFactory(filterFactory);
        return this;
    }

    public DatagramCrusherBuilder withIncomingTransformFilterFactory(TransformFilterFactory filterFactory) {
        this.options.setIncomingTransformFilterFactory(filterFactory);
        return this;
    }

    public DatagramCrusherBuilder withOutgoingPassFilterFactory(PassFilterFactory filterFactory) {
        this.options.setOutgoingPassFilterFactory(filterFactory);
        return this;
    }

    public DatagramCrusherBuilder withIncomingPassFilterFactory(PassFilterFactory filterFactory) {
        this.options.setIncomingPassFilterFactory(filterFactory);
        return this;
    }

    public DatagramCrusherBuilder withOutgoingThrottlerFactory(ThrottlerFactory throttlerFactory) {
        this.options.setOutgoingThrottlerFactory(throttlerFactory);
        return this;
    }

    public DatagramCrusherBuilder withIncomingGlobalThrottler(Throttler throttler) {
        this.options.setIncomingGlobalThrottler(throttler);
        return this;
    }

    public DatagramCrusherBuilder withCreationListener(DatagramClientCreation creationListener) {
        this.options.setCreationListener(creationListener);
        return this;
    }

    public DatagramCrusherBuilder withDeletionListener(DatagramClientDeletion deletionListener) {
        this.options.setDeletionListener(deletionListener);
        return this;
    }

    public DatagramCrusherBuilder withDeferredListeners(boolean deferredListeners) {
        this.options.setDeferredListeners(deferredListeners);
        return this;
    }

    public DatagramCrusher build() {
        return new DatagramCrusher(this.options);
    }

    public DatagramCrusher buildAndOpen() {
        DatagramCrusher crusher = this.build();
        crusher.open();
        return crusher;
    }
}

