/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Queue;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.nio.NioUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatagramQueue
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramQueue.class);
    private final Deque<BufferEntry> entries;
    private final Queue<BufferEntry> pending;

    DatagramQueue(BufferOptions bufferOptions) {
        this.entries = new ArrayDeque<BufferEntry>(bufferOptions.getCount());
        this.pending = new ArrayDeque<BufferEntry>(bufferOptions.getCount());
        int limit = bufferOptions.getCount();
        for (int i = 0; i < limit; ++i) {
            this.pending.add(new BufferEntry(bufferOptions.getSize(), bufferOptions.isDirect()));
        }
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public boolean add(InetSocketAddress address, ByteBuffer bbToCopy, long delayNs) {
        BufferEntry entry = this.pending.poll();
        if (entry != null) {
            ByteBuffer entryBuffer = entry.getBuffer();
            if (entryBuffer.remaining() < bbToCopy.remaining()) {
                throw new IllegalStateException("Buffer capacity " + entry.getBuffer().remaining() + "  is less than datagram size " + bbToCopy.remaining() + ". Increase buffer size in builder.");
            }
            entryBuffer.put(bbToCopy);
            entryBuffer.flip();
            entry.schedule(address, delayNs);
            this.entries.addLast(entry);
            return true;
        }
        LOGGER.warn("Datagram with {} bytes is dropped because buffer queue has no any free buffers.", (Object)bbToCopy.remaining());
        return false;
    }

    public void retry(BufferEntry entry) {
        this.entries.addFirst(entry);
    }

    public BufferEntry request() {
        return this.entries.pollFirst();
    }

    public void release(BufferEntry entry) {
        entry.getBuffer().clear();
        this.pending.add(entry);
    }

    public static final class BufferEntry
    implements Serializable {
        private final ByteBuffer buffer;
        private InetSocketAddress address;
        private long scheduledNs;

        private BufferEntry(int capacity, boolean direct) {
            this.buffer = NioUtils.allocaleByteBuffer(capacity, direct);
            this.address = null;
            this.scheduledNs = System.nanoTime();
        }

        public void schedule(InetSocketAddress address, long delayNs) {
            this.address = address;
            this.scheduledNs = System.nanoTime() + delayNs;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public long getScheduledNs() {
            return this.scheduledNs;
        }
    }
}

