/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.netcrusher.NetCrusher;
import org.netcrusher.NetFreezer;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.meter.RateMeters;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.state.BitState;
import org.netcrusher.tcp.TcpAcceptor;
import org.netcrusher.tcp.TcpCrusherOptions;
import org.netcrusher.tcp.TcpCrusherSocketOptions;
import org.netcrusher.tcp.TcpFilters;
import org.netcrusher.tcp.TcpPair;
import org.netcrusher.tcp.callback.TcpClientCreation;
import org.netcrusher.tcp.callback.TcpClientDeletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpCrusher
implements NetCrusher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpCrusher.class);
    private static final int DEFAULT_PAIR_CAPACITY = 32;
    private final InetSocketAddress bindAddress;
    private final InetSocketAddress connectAddress;
    private final InetSocketAddress bindBeforeConnectAddress;
    private final TcpCrusherSocketOptions socketOptions;
    private final NioReactor reactor;
    private final Map<InetSocketAddress, TcpPair> pairs;
    private final TcpClientCreation creationListener;
    private final TcpClientDeletion deletionListener;
    private final boolean deferredListeners;
    private final BufferOptions bufferOptions;
    private final TcpFilters filters;
    private final State state;
    private TcpAcceptor acceptor;

    public TcpCrusher(TcpCrusherOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("Options are not set");
        }
        options.validate();
        this.filters = new TcpFilters(options.getIncomingTransformFilterFactory(), options.getOutgoingTransformFilterFactory(), options.getIncomingThrottlerFactory(), options.getOutgoingThrottlerFactory());
        this.reactor = options.getReactor();
        this.bindAddress = options.getBindAddress();
        this.connectAddress = options.getConnectAddress();
        this.bindBeforeConnectAddress = options.getBindBeforeConnectAddress();
        this.socketOptions = options.getSocketOptions().copy();
        this.bufferOptions = options.getBufferOptions().copy();
        this.creationListener = options.getCreationListener();
        this.deletionListener = options.getDeletionListener();
        this.deferredListeners = options.isDeferredListeners();
        this.pairs = new ConcurrentHashMap<InetSocketAddress, TcpPair>(32);
        this.state = new State(State.CLOSED);
    }

    void notifyPairCreated(TcpPair pair) {
        LOGGER.debug("Pair is created for <{}>", (Object)pair.getClientAddress());
        this.pairs.put(pair.getClientAddress(), pair);
        if (this.creationListener != null) {
            Runnable r = () -> this.creationListener.created(pair.getClientAddress());
            this.reactor.getScheduler().executeListener(r, this.deferredListeners);
        }
    }

    private void notifyPairDeleted(TcpPair pair) {
        if (this.deletionListener != null) {
            Runnable r = () -> this.deletionListener.deleted(pair.getClientAddress(), pair.getByteMeters());
            this.reactor.getScheduler().executeListener(r, this.deferredListeners);
        }
    }

    @Override
    public void open() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.CLOSED)) {
                this.acceptor = new TcpAcceptor(this, this.reactor, this.bindAddress, this.connectAddress, this.bindBeforeConnectAddress, this.socketOptions, this.filters, this.bufferOptions);
                this.state.set(State.FROZEN);
                LOGGER.info("TcpCrusher <{}>-<{}> is open", (Object)this.bindAddress, (Object)this.connectAddress);
                this.unfreeze();
                return true;
            }
            throw new IllegalStateException("TcpCrusher is already open");
        });
    }

    @Override
    public void close() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                if (this.state.is(State.OPEN)) {
                    this.freeze();
                }
                this.closeAllPairs();
                this.acceptor.close();
                this.acceptor = null;
                this.state.set(State.CLOSED);
                LOGGER.info("TcpCrusher <{}>-<{}> is closed", (Object)this.bindAddress, (Object)this.connectAddress);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean isOpen() {
        return this.state.isAnyOf(State.OPEN | State.FROZEN);
    }

    public void closeAllPairs() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                for (TcpPair pair : this.pairs.values()) {
                    pair.close();
                    this.notifyPairDeleted(pair);
                }
                this.pairs.clear();
                return true;
            }
            return false;
        });
    }

    @Override
    public void reopen() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                this.close();
                this.open();
                return true;
            }
            throw new IllegalStateException("TcpCrusher is already closed");
        });
    }

    @Override
    public void freeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.OPEN)) {
                if (!this.acceptor.isFrozen()) {
                    this.acceptor.freeze();
                }
                this.freezeAllPairs();
                this.state.set(State.FROZEN);
                return true;
            }
            throw new IllegalStateException("TcpCrusher is not open on freeze");
        });
    }

    public void freezeAllPairs() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                for (TcpPair pair : this.pairs.values()) {
                    if (pair.isFrozen()) continue;
                    pair.freeze();
                }
                return true;
            }
            throw new IllegalStateException("TcpCrusher is closed");
        });
    }

    @Override
    public void unfreeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.FROZEN)) {
                this.unfreezeAllPairs();
                if (this.acceptor.isFrozen()) {
                    this.acceptor.unfreeze();
                }
                this.state.set(State.OPEN);
                return true;
            }
            throw new IllegalStateException("TcpCrusher is not frozen on unfreeze");
        });
    }

    public void unfreezeAllPairs() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                for (TcpPair pair : this.pairs.values()) {
                    if (!pair.isFrozen()) continue;
                    pair.unfreeze();
                }
                return true;
            }
            throw new IllegalStateException("TcpCrusher is closed");
        });
    }

    @Override
    public boolean isFrozen() {
        return this.state.isAnyOf(State.FROZEN | State.CLOSED);
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    @Override
    public Collection<InetSocketAddress> getClientAddresses() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.pairs.values().stream().map(TcpPair::getClientAddress).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
    }

    @Override
    public RateMeters getClientByteMeters(InetSocketAddress clientAddress) {
        return this.reactor.getSelector().execute(() -> {
            TcpPair pair;
            if (this.state.not(State.CLOSED) && (pair = this.pairs.get(clientAddress)) != null) {
                return pair.getByteMeters();
            }
            return null;
        });
    }

    @Override
    public boolean closeClient(InetSocketAddress clientAddress) {
        return this.reactor.getSelector().execute(() -> {
            TcpPair pair;
            if (this.state.not(State.CLOSED) && (pair = this.pairs.remove(clientAddress)) != null) {
                pair.close();
                this.notifyPairDeleted(pair);
                return true;
            }
            return false;
        });
    }

    public NetFreezer getClientFreezer(InetSocketAddress clientAddress) {
        return this.pairs.get(clientAddress);
    }

    public NetFreezer getAcceptorFreezer() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.acceptor;
            }
            return null;
        });
    }

    @Override
    public int getClientTotalCount() {
        return this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                return this.acceptor.getTotalAccepted();
            }
            return 0;
        });
    }

    private static final class State
    extends BitState {
        private static final int OPEN = State.bit(0);
        private static final int FROZEN = State.bit(1);
        private static final int CLOSED = State.bit(2);

        private State(int state) {
            super(state);
        }
    }
}

