/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.terracotta.angela.common.util.IpUtils;

public class TerracottaVoter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String hostName;
    private final List<InetSocketAddress> hostPorts = new ArrayList<InetSocketAddress>();
    private final List<String> serverNames = new ArrayList<String>();

    private TerracottaVoter(String id, String hostName, List<InetSocketAddress> hostPorts, List<String> serverNames) {
        this.id = id;
        this.hostName = hostName;
        this.hostPorts.addAll(hostPorts);
        this.serverNames.addAll(serverNames);
    }

    public static TerracottaVoter voter(String id, String hostName, InetSocketAddress ... hostPorts) {
        return new TerracottaVoter(id, hostName, Arrays.asList(hostPorts), Collections.emptyList());
    }

    public static TerracottaVoter voter(String id, String hostName, String ... serverNames) {
        return new TerracottaVoter(id, hostName, Collections.emptyList(), Arrays.asList(serverNames));
    }

    public static TerracottaVoter localVoter(String id, InetSocketAddress ... hostPorts) {
        return new TerracottaVoter(id, IpUtils.getHostName(), Arrays.asList(hostPorts), Collections.emptyList());
    }

    public static TerracottaVoter localVoter(String id, String ... serverNames) {
        return new TerracottaVoter(id, IpUtils.getHostName(), Collections.emptyList(), Arrays.asList(serverNames));
    }

    public String getId() {
        return this.id;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Deprecated
    public List<String> getHostPorts() {
        return this.serverNames;
    }

    public List<InetSocketAddress> getHostAddresses() {
        return this.hostPorts;
    }

    public List<String> getServerNames() {
        return this.serverNames;
    }
}

