/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.distribution;

import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import org.terracotta.angela.common.distribution.Distribution102Controller;
import org.terracotta.angela.common.distribution.Distribution107Controller;
import org.terracotta.angela.common.distribution.Distribution107InlineController;
import org.terracotta.angela.common.distribution.Distribution43Controller;
import org.terracotta.angela.common.distribution.DistributionController;
import org.terracotta.angela.common.distribution.RuntimeOption;
import org.terracotta.angela.common.topology.LicenseType;
import org.terracotta.angela.common.topology.PackageType;
import org.terracotta.angela.common.topology.Version;

public class Distribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Version version;
    private final PackageType packageType;
    private final LicenseType licenseType;
    private final EnumSet<RuntimeOption> runtimeOptions;

    private Distribution(Version version, PackageType packageType, LicenseType licenseType, EnumSet<RuntimeOption> runtimeOptions) {
        this.version = Objects.requireNonNull(version);
        this.packageType = Objects.requireNonNull(packageType);
        this.licenseType = this.validateLicenseType(version, licenseType);
        this.runtimeOptions = runtimeOptions;
    }

    private LicenseType validateLicenseType(Version version, LicenseType licenseType) {
        Objects.requireNonNull(licenseType);
        if (version.getMajor() == 4) {
            if (licenseType != LicenseType.GO && licenseType != LicenseType.MAX) {
                return this.throwException("Expected license of type '%s' or '%s for version: %s, but found: %s", new Object[]{LicenseType.GO, LicenseType.MAX, version, licenseType});
            }
        } else if (version.getMajor() == 3 || version.getMajor() == 5) {
            if (licenseType != LicenseType.TERRACOTTA_OS) {
                this.throwException("Expected license of type '%s' for version: %s, but found: %s", new Object[]{LicenseType.TERRACOTTA_OS, version, licenseType});
            }
        } else if (licenseType != LicenseType.TERRACOTTA) {
            this.throwException("Expected license of type '%s' for version: %s, but found: %s", new Object[]{LicenseType.TERRACOTTA, version, licenseType});
        }
        return licenseType;
    }

    private LicenseType throwException(String string, Object ... args) {
        throw new IllegalArgumentException(String.format(string, args));
    }

    public static Distribution distribution(Version version, PackageType packageType, LicenseType licenseType) {
        return new Distribution(version, packageType, licenseType, EnumSet.noneOf(RuntimeOption.class));
    }

    public static Distribution distribution(Version version, PackageType packageType, LicenseType licenseType, RuntimeOption ... runtime) {
        return new Distribution(version, packageType, licenseType, runtime.length == 0 ? EnumSet.noneOf(RuntimeOption.class) : EnumSet.copyOf(Arrays.asList(runtime)));
    }

    public Version getVersion() {
        return this.version;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public DistributionController createDistributionController() {
        if (this.version.getMajor() == 10 && this.version.getMinor() >= 7 || this.version.getMajor() == 5 && this.version.getMinor() >= 7 || this.version.getMajor() == 3 && this.version.getMinor() >= 9) {
            if (this.runtimeOptions.contains((Object)RuntimeOption.INLINE_SERVERS)) {
                return new Distribution107InlineController(this);
            }
            return new Distribution107Controller(this);
        }
        if (this.version.getMajor() == 10 || this.version.getMajor() == 3) {
            return new Distribution102Controller(this);
        }
        if (this.version.getMinor() >= 3) {
            return new Distribution43Controller(this);
        }
        throw new IllegalStateException("Cannot create a DistributionController for version: " + this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distribution that = (Distribution)o;
        return Objects.equals(this.version, that.version) && this.packageType == that.packageType && this.licenseType == that.licenseType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.packageType, this.licenseType});
    }

    public String toString() {
        return "Distribution{version=" + this.version + ", packageType=" + (Object)((Object)this.packageType) + ", licenseType=" + (Object)((Object)this.licenseType) + '}';
    }
}

