/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tms.security.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TmsServerSecurityConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NOT_SET_VALUE = "was not set";
    public static final String SECURITY_ROOT_DIRECTORY = "tms.security.root.directory";
    public static final String AUDIT_DIRECTORY = "tms.security.audit.directory";
    public static final String HTTPS_ENABLED = "tms.security.https.enabled";
    public static final String AUTHENTICATION_SCHEME = "tms.security.authentication.scheme";
    public static final String AUTHORIZATION_SCHEME = "tms.security.authorization.scheme";
    public static final String SECURITY_ROOT_DIRECTORY_CONNECTION_DEFAULT = "tms.security.root.directory.connection.default";
    public static final String DEPRECATED_SECURITY_ROOT_DIRECTORY = "security.root.directory";
    public static final String DEPRECATED_SECURITY_LEVEL = "security.level";
    private String tmsSecurityRootDirectory;
    private String tmsSecurityHttpsEnabled;
    private String tmsSecurityAuthenticationScheme;
    private String tmsSecurityAuthorizationScheme;
    private String tmsSecurityRootDirectoryConnectionDefault;
    private String tmsSecurityAuditDirectory;
    @Deprecated
    private String deprecatedSecurityRootDirectory;
    @Deprecated
    private String deprecatedSecurityLevel;

    private TmsServerSecurityConfig() {
    }

    public String getTmsSecurityRootDirectory() {
        return this.tmsSecurityRootDirectory;
    }

    public String getTmsSecurityHttpsEnabled() {
        return this.tmsSecurityHttpsEnabled;
    }

    public String getTmsSecurityAuthenticationScheme() {
        return this.tmsSecurityAuthenticationScheme;
    }

    public String getTmsSecurityAuthorizationScheme() {
        return this.tmsSecurityAuthorizationScheme;
    }

    public String getTmsSecurityRootDirectoryConnectionDefault() {
        return this.tmsSecurityRootDirectoryConnectionDefault;
    }

    public String getTmsSecurityAuditDirectory() {
        return this.tmsSecurityAuditDirectory;
    }

    public String getDeprecatedSecurityRootDirectory() {
        return this.deprecatedSecurityRootDirectory;
    }

    public String getDeprecatedSecurityLevel() {
        return this.deprecatedSecurityLevel;
    }

    public String toString() {
        return String.format("tmsSecurityRootDirectory:%s, tmsSecurityHttpsEnabled:%s, tmsSecurityAuthenticationScheme:%s, tmsSecurityAuthorizationScheme:%s, tmsSecurityRootDirectoryConnectionDefault:%s, tmsSecurityAuditDirectory:%s, deprecatedSecurityRootDirectory:%s, deprecatedSecurityLevel:%s", this.getTmsSecurityRootDirectory(), this.getTmsSecurityHttpsEnabled(), this.getTmsSecurityAuthenticationScheme(), this.getTmsSecurityAuthorizationScheme(), this.getTmsSecurityRootDirectoryConnectionDefault(), this.getTmsSecurityAuditDirectory(), this.getDeprecatedSecurityRootDirectory(), this.getDeprecatedSecurityLevel());
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String property = this.getTmsSecurityRootDirectory();
        if (property == null || !property.equals(NOT_SET_VALUE)) {
            map.put(SECURITY_ROOT_DIRECTORY, property);
        }
        if ((property = this.getTmsSecurityHttpsEnabled()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(HTTPS_ENABLED, property);
        }
        if ((property = this.getTmsSecurityAuthenticationScheme()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(AUTHENTICATION_SCHEME, property);
        }
        if ((property = this.getTmsSecurityAuthorizationScheme()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(AUTHORIZATION_SCHEME, property);
        }
        if ((property = this.getTmsSecurityRootDirectoryConnectionDefault()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(SECURITY_ROOT_DIRECTORY_CONNECTION_DEFAULT, property);
        }
        if ((property = this.getTmsSecurityAuditDirectory()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(AUDIT_DIRECTORY, property);
        }
        if ((property = this.getDeprecatedSecurityRootDirectory()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(DEPRECATED_SECURITY_ROOT_DIRECTORY, property);
        }
        if ((property = this.getDeprecatedSecurityLevel()) == null || !property.equals(NOT_SET_VALUE)) {
            map.put(DEPRECATED_SECURITY_LEVEL, property);
        }
        return map;
    }

    public static class Builder {
        public String tmsSecurityRootDirectory = "was not set";
        public String tmsSecurityHttpsEnabled = "was not set";
        public String tmsSecurityAuthenticationScheme = "was not set";
        public String tmsSecurityAuthorizationScheme = "was not set";
        public String tmsSecurityRootDirectoryConnectionDefault = "was not set";
        public String tmsSecurityAuditDirectory = "was not set";
        @Deprecated
        public String deprecatedSecurityRootDirectory = "was not set";
        @Deprecated
        public String deprecatedSecurityLevel = "was not set";

        public Builder with(Consumer<Builder> builderFunction) {
            builderFunction.accept(this);
            return this;
        }

        public TmsServerSecurityConfig build() {
            TmsServerSecurityConfig config = new TmsServerSecurityConfig();
            config.tmsSecurityRootDirectory = this.tmsSecurityRootDirectory;
            config.tmsSecurityHttpsEnabled = this.tmsSecurityHttpsEnabled;
            config.tmsSecurityAuthenticationScheme = this.tmsSecurityAuthenticationScheme;
            config.tmsSecurityAuthorizationScheme = this.tmsSecurityAuthorizationScheme;
            config.tmsSecurityRootDirectoryConnectionDefault = this.tmsSecurityRootDirectoryConnectionDefault;
            config.tmsSecurityAuditDirectory = this.tmsSecurityAuditDirectory;
            config.deprecatedSecurityRootDirectory = this.deprecatedSecurityRootDirectory;
            config.deprecatedSecurityLevel = this.deprecatedSecurityLevel;
            return config;
        }
    }
}

