/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.topology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.provider.ConfigurationManager;
import org.terracotta.angela.common.provider.TcConfigManager;
import org.terracotta.angela.common.tcconfig.TcConfig;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tcconfig.TsaConfig;
import org.terracotta.angela.common.topology.LicenseType;

public class Topology
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Distribution distribution;
    private final boolean netDisruptionEnabled;
    private final ConfigurationManager configurationManager;

    public Topology(Distribution distribution, TsaConfig tsaConfig) {
        this(distribution, false, tsaConfig.getTcConfigs());
    }

    public Topology(Distribution distribution, boolean netDisruptionEnabled, TsaConfig tsaConfig) {
        this(distribution, netDisruptionEnabled, tsaConfig.getTcConfigs());
    }

    public Topology(Distribution distribution, TcConfig[] tcConfigs) {
        this(distribution, false, Arrays.asList(tcConfigs));
    }

    public Topology(Distribution distribution, TcConfig tcConfig, TcConfig ... tcConfigs) {
        this(distribution, false, TcConfigManager.mergeTcConfigs(tcConfig, tcConfigs));
    }

    public Topology(Distribution distribution, boolean netDisruptionEnabled, TcConfig[] tcConfigs) {
        this(distribution, netDisruptionEnabled, Arrays.asList(tcConfigs));
    }

    public Topology(Distribution distribution, boolean netDisruptionEnabled, TcConfig tcConfig, TcConfig ... tcConfigs) {
        this(distribution, netDisruptionEnabled, TcConfigManager.mergeTcConfigs(tcConfig, tcConfigs));
    }

    public Topology(Distribution distribution, boolean netDisruptionEnabled, ConfigurationManager configurationManager) {
        this.distribution = distribution;
        this.netDisruptionEnabled = netDisruptionEnabled;
        this.configurationManager = configurationManager;
    }

    public Topology(Distribution distribution, ConfigurationManager configurationManager) {
        this(distribution, false, configurationManager);
    }

    private Topology(Distribution distribution, boolean netDisruptionEnabled, List<TcConfig> tcConfigs) {
        this.distribution = distribution;
        this.netDisruptionEnabled = netDisruptionEnabled;
        this.configurationManager = TcConfigManager.withTcConfig(tcConfigs, netDisruptionEnabled);
    }

    public LicenseType getLicenseType() {
        return this.distribution.getLicenseType();
    }

    public boolean isNetDisruptionEnabled() {
        return this.netDisruptionEnabled;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void addStripe(TerracottaServer ... newServers) {
        this.configurationManager.addStripe(newServers);
    }

    public void removeStripe(int stripeIndex) {
        this.configurationManager.removeStripe(stripeIndex);
    }

    public List<List<TerracottaServer>> getStripes() {
        return this.configurationManager.getStripes();
    }

    public void addServer(int stripeIndex, TerracottaServer newServer) {
        this.configurationManager.addServer(stripeIndex, newServer);
    }

    public void removeServer(int stripeIndex, int serverIndex) {
        this.configurationManager.removeServer(stripeIndex, serverIndex);
    }

    public TerracottaServer getServer(int stripeIndex, int serverIndex) {
        return this.configurationManager.getServer(stripeIndex, serverIndex);
    }

    public List<TerracottaServer> getServers() {
        return this.configurationManager.getServers();
    }

    public Collection<String> getServersHostnames() {
        return this.configurationManager.getServersHostnames();
    }

    public void init(PortAllocator portAllocator) {
        this.configurationManager.init(portAllocator);
    }

    public String toString() {
        return "Topology{distribution=" + this.distribution + ", configurationManager=" + this.configurationManager + ", netDisruptionEnabled=" + this.netDisruptionEnabled + '}';
    }
}

