/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.util.Objects;
import org.terracotta.angela.common.util.HostAndIpValidator;

public class HostPort {
    private final String hostname;
    private final int port;

    public HostPort(String hostname, int port) {
        this.hostname = Objects.requireNonNull(hostname);
        this.port = port;
    }

    @Deprecated
    public String getHostname() {
        return this.getHostName();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostPort() {
        return this.encloseInBracketsIfIpv6(this.hostname) + ":" + this.port;
    }

    private String encloseInBracketsIfIpv6(String hostname) {
        if (hostname != null && HostAndIpValidator.isValidIPv6(hostname, false)) {
            return "[" + hostname + "]";
        }
        return hostname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPort hostPort = (HostPort)o;
        return this.port == hostPort.port && this.hostname.equals(hostPort.hostname);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.port);
    }
}

