/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.zeroturnaround.process.AbstractProcess;

public class JavaProcess
extends AbstractProcess {
    protected final Process process;

    protected JavaProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public String getDescription() {
        String result = this.process.toString();
        int i = result.lastIndexOf(46);
        return result.substring(i + 1);
    }

    @Override
    public boolean isAlive() {
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Override
    public void waitFor() throws InterruptedException {
        this.process.waitFor();
    }

    @Override
    public void destroy(boolean forceful) throws IOException {
        if (!this.canDestroy(forceful)) {
            throw new UnsupportedOperationException();
        }
        this.invokeDestroy(forceful);
    }

    protected boolean canDestroy(boolean forceful) {
        return forceful == SystemUtils.IS_OS_WINDOWS;
    }

    protected void invokeDestroy(boolean forceful) {
        this.log.debug("Invoking destroy() on {}", (Object)this.process);
        this.process.destroy();
    }
}

