/*
 * Decompiled with CFR 0.152.
 */
package org.terrakube.terraform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrakube.terraform.ProcessLauncher;
import org.terrakube.terraform.TerraformCommand;
import org.terrakube.terraform.TerraformDownloader;
import org.terrakube.terraform.TerraformProcessData;

public class TerraformClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TerraformClient.class);
    private static final String TERRAFORM_PARAM_VARIABLE = "--var";
    private static final String TERRAFORM_PARAM_VARIABLE_FILE = "-var-file";
    private static final String TERRAFORM_PARAM_AUTO_APPROVED = "-auto-approve";
    private static final String TERRAFORM_PARAM_NO_COLOR = "-no-color";
    private static final String TERRAFORM_PARAM_FORCE = "-force";
    private static final String TERRAFORM_PARAM_JSON = "-json";
    private static final String TERRAFORM_PARAM_BACKEND = "-backend-config=";
    private static final String TERRAFORM_PARAM_OUTPUT_PLAN = "-out=terraformLibrary.tfPlan";
    private static final String TERRAFORM_PARAM_PLAN_DESTROY = "-destroy";
    private static final String TERRAFORM_PARAM_OUTPUT_PLAN_FILE = "terraformLibrary.tfPlan";
    private static final String TERRAFORM_PARAM_DISABLE_USER_INPUT = "-input=false";
    private static final String TERRAFORM_PLAN_REFRESH_FALSE = "-refresh=false";
    private static final String TERRAFORM_PLAN_REFRESH_ONLY = "-refresh-only";
    private static final String TF_STATE_PULL = "pull";
    private final ExecutorService executor = Executors.newWorkStealingPool();
    private File workingDirectory;
    private boolean inheritIO;
    private boolean showColor;
    private boolean jsonOutput;
    private String terraformVersion;
    private String backendConfig;
    private String terraformReleasesUrl;
    private String tofuReleasesUrl;
    private String varFileName;
    private Map<String, String> environmentVariables;
    private Map<String, String> terraformParameters;
    private Consumer<String> outputListener;
    private Consumer<String> errorListener;

    public CompletableFuture<String> version() throws IOException {
        ProcessLauncher launcher = this.getTerraformLauncher(TerraformCommand.version);
        StringBuilder version = new StringBuilder();
        Consumer<String> outputListener = this.getOutputListener();
        launcher.setOutputListener(m -> {
            version.append(version.length() == 0 ? m : "");
            if (outputListener != null) {
                outputListener.accept((String)m);
            }
        });
        return launcher.launch().thenApply(c -> c == 0 ? version.toString() : null);
    }

    public CompletableFuture<Boolean> show(@NonNull TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (terraformProcessData == null) {
            throw new NullPointerException("terraformProcessData is marked non-null but is null");
        }
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        this.checkVarFileParam(terraformProcessData);
        this.checkTerraformVariablesParam(terraformProcessData);
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.show);
    }

    public CompletableFuture<Boolean> show() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.show);
    }

    public CompletableFuture<Boolean> showPlan(@NonNull TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (terraformProcessData == null) {
            throw new NullPointerException("terraformProcessData is marked non-null but is null");
        }
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        this.checkVarFileParam(terraformProcessData);
        this.checkTerraformVariablesParam(terraformProcessData);
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.showPlan);
    }

    public CompletableFuture<Boolean> showPlan() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.showPlan);
    }

    public CompletableFuture<Boolean> init(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        this.checkVarFileParam(terraformProcessData);
        this.checkTerraformVariablesParam(terraformProcessData);
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.init);
    }

    public CompletableFuture<Boolean> init() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.init);
    }

    public CompletableFuture<Boolean> plan(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.plan);
    }

    public CompletableFuture<Boolean> statePull(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.statePull);
    }

    public CompletableFuture<Boolean> planDestroy(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.planDestroy);
    }

    public CompletableFuture<Boolean> plan() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.plan);
    }

    public CompletableFuture<Boolean> apply(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.apply);
    }

    public CompletableFuture<Boolean> apply() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.apply);
    }

    public CompletableFuture<Boolean> destroy(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        this.checkBackendConfigFile(terraformProcessData);
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.destroy);
    }

    public CompletableFuture<Boolean> destroy() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.destroy);
    }

    public CompletableFuture<Boolean> output(TerraformProcessData terraformProcessData, @NonNull Consumer<String> outputListener, @NonNull Consumer<String> errorListener) throws IOException {
        if (outputListener == null) {
            throw new NullPointerException("outputListener is marked non-null but is null");
        }
        if (errorListener == null) {
            throw new NullPointerException("errorListener is marked non-null but is null");
        }
        this.checkBackendConfigFile(terraformProcessData);
        this.checkVarFileParam(terraformProcessData);
        this.checkTerraformVariablesParam(terraformProcessData);
        return this.run(terraformProcessData, outputListener, errorListener, TerraformCommand.output);
    }

    public CompletableFuture<Boolean> output() throws IOException {
        this.checkRunningParameters();
        return this.run(TerraformCommand.output);
    }

    private CompletableFuture<Boolean> run(TerraformProcessData terraformProcessData, Consumer<String> outputListener, Consumer<String> errorListener, TerraformCommand ... commands) throws IOException {
        assert (commands.length > 0);
        ProcessLauncher[] launchers = new ProcessLauncher[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            launchers[i] = this.getTerraformLauncher(terraformProcessData, outputListener, errorListener, commands[i]);
        }
        return this.getLauncherResult(launchers, commands);
    }

    private CompletableFuture<Boolean> getLauncherResult(ProcessLauncher[] launchers, TerraformCommand[] commands) {
        CompletionStage result = launchers[0].launch().thenApply(c -> c == 0 ? 1 : -1);
        for (int i2 = 1; i2 < commands.length; ++i2) {
            result = ((CompletableFuture)result).thenCompose(index -> {
                if (index > 0) {
                    return launchers[index].launch().thenApply(c -> c == 0 ? index + 1 : -1);
                }
                return CompletableFuture.completedFuture(-1);
            });
        }
        return ((CompletableFuture)result).thenApply(i -> i > 0);
    }

    private CompletableFuture<Boolean> run(TerraformCommand ... commands) throws IOException {
        assert (commands.length > 0);
        ProcessLauncher[] launchers = new ProcessLauncher[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            launchers[i] = this.getTerraformLauncher(commands[i]);
        }
        return this.getLauncherResult(launchers, commands);
    }

    private void checkVarFileParam(TerraformProcessData terraformProcessData) {
        if (terraformProcessData.getVarFileName() != null) {
            throw new IllegalArgumentException("varFile parameter should be null for this terraform command");
        }
    }

    private void checkTerraformVariablesParam(TerraformProcessData terraformProcessData) {
        if (!terraformProcessData.getTerraformVariables().isEmpty()) {
            throw new IllegalArgumentException("terraform variables parameter should be empty for this terraform command");
        }
    }

    private void checkBackendConfigFile(TerraformProcessData terraformProcessData) {
        if (terraformProcessData.getTerraformBackendConfigFileName() != null) {
            throw new IllegalArgumentException("terraform backend config file name should be null for this terraform command");
        }
    }

    private void checkRunningParameters() {
        if (this.getWorkingDirectory() == null) {
            throw new IllegalArgumentException("working directory should not be null");
        }
        if (this.terraformVersion == null) {
            throw new IllegalArgumentException("Terraform version should not be null");
        }
    }

    private ProcessLauncher getTerraformLauncher(TerraformCommand command) throws IOException {
        TerraformProcessData terraformProcessData = TerraformProcessData.builder().terraformVersion(this.terraformVersion).workingDirectory(this.workingDirectory).terraformBackendConfigFileName(this.backendConfig).varFileName(this.varFileName).terraformVariables(this.terraformParameters).terraformEnvironmentVariables(this.environmentVariables).build();
        return this.getTerraformLauncher(terraformProcessData, this.outputListener, this.errorListener, command);
    }

    private ProcessLauncher getTerraformLauncher(TerraformProcessData terraformProcessData, Consumer<String> outputListener, Consumer<String> errorListener, TerraformCommand command) throws IOException {
        String terraformPath;
        TerraformDownloader terraformDownloader = this.createTerraformDownloader();
        String string = terraformPath = terraformProcessData.isTofu() ? terraformDownloader.downloadTofuVersion(terraformProcessData.getTerraformVersion()) : terraformDownloader.downloadTerraformVersion(terraformProcessData.getTerraformVersion());
        if (terraformProcessData.sshFile != null && command.equals((Object)TerraformCommand.init)) {
            return this.getTerraformInitWithSSH(terraformPath, terraformProcessData, outputListener, errorListener);
        }
        ProcessLauncher launcher = new ProcessLauncher(this.executor, terraformPath, command.getLabel());
        launcher.setDirectory(terraformProcessData.getWorkingDirectory());
        launcher.setInheritIO(this.isInheritIO());
        if (terraformProcessData.getTerraformEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : terraformProcessData.getTerraformEnvironmentVariables().entrySet()) {
                launcher.setEnvironmentVariable(entry.getKey(), entry.getValue());
            }
        }
        ComparableVersion version = new ComparableVersion(terraformProcessData.getTerraformVersion());
        if (!this.showColor) {
            launcher.appendCommands(TERRAFORM_PARAM_NO_COLOR);
        }
        if (this.jsonOutput && version.compareTo(new ComparableVersion("0.15.2")) > 0) {
            switch (command) {
                case plan: 
                case apply: 
                case planDestroy: 
                case destroy: {
                    launcher.appendCommands(TERRAFORM_PARAM_JSON);
                    break;
                }
            }
        }
        switch (command) {
            case init: {
                if (terraformProcessData.getTerraformBackendConfigFileName() != null) {
                    launcher.appendCommands(TERRAFORM_PARAM_BACKEND.concat(terraformProcessData.getTerraformBackendConfigFileName()));
                }
                launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                break;
            }
            case plan: 
            case planDestroy: {
                if (!terraformProcessData.isRefresh()) {
                    launcher.appendCommands(TERRAFORM_PLAN_REFRESH_FALSE);
                }
                if (terraformProcessData.isRefreshOnly()) {
                    launcher.appendCommands(TERRAFORM_PLAN_REFRESH_ONLY);
                }
                if (terraformProcessData.getVarFileName() == null) {
                    for (Map.Entry<String, String> entry : terraformProcessData.getTerraformVariables().entrySet()) {
                        launcher.appendCommands(TERRAFORM_PARAM_VARIABLE, entry.getKey().concat("=").concat(entry.getValue()));
                    }
                } else {
                    log.info("Using plan with var file parameter");
                    launcher.appendCommands(TERRAFORM_PARAM_VARIABLE_FILE, terraformProcessData.getVarFileName());
                }
                launcher.appendCommands(TERRAFORM_PARAM_OUTPUT_PLAN);
                launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                if (!command.equals((Object)TerraformCommand.planDestroy)) break;
                launcher.appendCommands(TERRAFORM_PARAM_PLAN_DESTROY);
                break;
            }
            case apply: {
                if (terraformProcessData.getVarFileName() == null) {
                    if (terraformProcessData.getTerraformVariables().entrySet().isEmpty()) {
                        launcher.appendCommands(TERRAFORM_PARAM_AUTO_APPROVED);
                        launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                        launcher.appendCommands(TERRAFORM_PARAM_OUTPUT_PLAN_FILE);
                        break;
                    }
                    for (Map.Entry<String, String> entry : terraformProcessData.getTerraformVariables().entrySet()) {
                        launcher.appendCommands(TERRAFORM_PARAM_VARIABLE, entry.getKey().concat("=").concat(entry.getValue()));
                    }
                    launcher.appendCommands(TERRAFORM_PARAM_AUTO_APPROVED);
                    launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                    break;
                }
                log.info("Using apply with var file parameter");
                launcher.appendCommands(TERRAFORM_PARAM_VARIABLE_FILE, terraformProcessData.getVarFileName());
                launcher.appendCommands(TERRAFORM_PARAM_AUTO_APPROVED);
                launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                break;
            }
            case destroy: {
                if (version.compareTo(new ComparableVersion("0.15.0")) < 0) {
                    launcher.appendCommands(TERRAFORM_PARAM_FORCE);
                } else {
                    launcher.appendCommands(TERRAFORM_PARAM_AUTO_APPROVED);
                }
                if (terraformProcessData.getVarFileName() == null) {
                    for (Map.Entry<String, String> entry : terraformProcessData.getTerraformVariables().entrySet()) {
                        launcher.appendCommands(TERRAFORM_PARAM_VARIABLE, entry.getKey().concat("=").concat(entry.getValue()));
                    }
                } else {
                    log.info("Using Destroy with var file parameter");
                    launcher.appendCommands(TERRAFORM_PARAM_VARIABLE_FILE, terraformProcessData.getVarFileName());
                }
                launcher.appendCommands(TERRAFORM_PARAM_DISABLE_USER_INPUT);
                break;
            }
            case show: 
            case output: {
                launcher.appendCommands(TERRAFORM_PARAM_JSON);
                break;
            }
            case showPlan: {
                launcher.appendCommands(TERRAFORM_PARAM_OUTPUT_PLAN_FILE);
                break;
            }
            case statePull: {
                log.info("tf state pull command");
                launcher.appendCommands(TF_STATE_PULL);
            }
        }
        launcher.setOutputListener(outputListener);
        launcher.setErrorListener(errorListener);
        return launcher;
    }

    private ProcessLauncher getTerraformInitWithSSH(String terraformPath, TerraformProcessData terraformProcessData, Consumer<String> outputListener, Consumer<String> errorListener) {
        String initSSHCommand = String.format("GIT_SSH_COMMAND='ssh -i %s -o StrictHostKeyChecking=no' %s init", terraformProcessData.getSshFile().getAbsolutePath(), terraformPath);
        ProcessLauncher processLauncher = new ProcessLauncher(this.executor, "bash", "-c");
        processLauncher.setInheritIO(this.isInheritIO());
        processLauncher.setDirectory(terraformProcessData.getWorkingDirectory());
        if (terraformProcessData.getTerraformEnvironmentVariables() != null) {
            for (Map.Entry<String, String> entry : terraformProcessData.getTerraformEnvironmentVariables().entrySet()) {
                processLauncher.setEnvironmentVariable(entry.getKey(), entry.getValue());
            }
        }
        if (!this.showColor) {
            initSSHCommand = initSSHCommand.concat(" -no-color");
        }
        if (terraformProcessData.getTerraformBackendConfigFileName() != null) {
            initSSHCommand = initSSHCommand.concat(" " + TERRAFORM_PARAM_BACKEND.concat(terraformProcessData.getTerraformBackendConfigFileName()));
        }
        initSSHCommand = initSSHCommand.concat(" -input=false");
        log.warn("Running terraform init with command {},", (Object)initSSHCommand);
        processLauncher.appendCommands(initSSHCommand);
        processLauncher.setOutputListener(outputListener);
        processLauncher.setErrorListener(errorListener);
        return processLauncher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerraformDownloader createTerraformDownloader() {
        TerraformClient terraformClient = this;
        synchronized (terraformClient) {
            String TERRAFORM_RELEASES_URL = this.terraformReleasesUrl != null && !this.terraformReleasesUrl.isEmpty() ? this.terraformReleasesUrl : "https://releases.hashicorp.com/terraform/index.json";
            String TOFU_RELEASES_URL = this.tofuReleasesUrl != null && !this.tofuReleasesUrl.isEmpty() ? this.tofuReleasesUrl : "https://api.github.com/repos/opentofu/opentofu/releases";
            log.info("Creating terraform downloader using terraform release URL: {} and tofu release URL: {}", (Object)TERRAFORM_RELEASES_URL, (Object)TOFU_RELEASES_URL);
            return new TerraformDownloader(TERRAFORM_RELEASES_URL, TOFU_RELEASES_URL);
        }
    }

    @Override
    public void close() throws Exception {
        this.executor.shutdownNow();
        if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
            throw new RuntimeException("executor did not terminate");
        }
    }

    public static TerraformClientBuilder builder() {
        return new TerraformClientBuilder();
    }

    protected TerraformClient(File workingDirectory, boolean inheritIO, boolean showColor, boolean jsonOutput, String terraformVersion, String backendConfig, String terraformReleasesUrl, String tofuReleasesUrl, String varFileName, Map<String, String> environmentVariables, Map<String, String> terraformParameters, Consumer<String> outputListener, Consumer<String> errorListener) {
        this.workingDirectory = workingDirectory;
        this.inheritIO = inheritIO;
        this.showColor = showColor;
        this.jsonOutput = jsonOutput;
        this.terraformVersion = terraformVersion;
        this.backendConfig = backendConfig;
        this.terraformReleasesUrl = terraformReleasesUrl;
        this.tofuReleasesUrl = tofuReleasesUrl;
        this.varFileName = varFileName;
        this.environmentVariables = environmentVariables;
        this.terraformParameters = terraformParameters;
        this.outputListener = outputListener;
        this.errorListener = errorListener;
    }

    public TerraformClient() {
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean isInheritIO() {
        return this.inheritIO;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public String getTerraformVersion() {
        return this.terraformVersion;
    }

    public String getBackendConfig() {
        return this.backendConfig;
    }

    public String getTerraformReleasesUrl() {
        return this.terraformReleasesUrl;
    }

    public String getTofuReleasesUrl() {
        return this.tofuReleasesUrl;
    }

    public String getVarFileName() {
        return this.varFileName;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Map<String, String> getTerraformParameters() {
        return this.terraformParameters;
    }

    public Consumer<String> getOutputListener() {
        return this.outputListener;
    }

    public Consumer<String> getErrorListener() {
        return this.errorListener;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setInheritIO(boolean inheritIO) {
        this.inheritIO = inheritIO;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    public void setTerraformVersion(String terraformVersion) {
        this.terraformVersion = terraformVersion;
    }

    public void setBackendConfig(String backendConfig) {
        this.backendConfig = backendConfig;
    }

    public void setTerraformReleasesUrl(String terraformReleasesUrl) {
        this.terraformReleasesUrl = terraformReleasesUrl;
    }

    public void setTofuReleasesUrl(String tofuReleasesUrl) {
        this.tofuReleasesUrl = tofuReleasesUrl;
    }

    public void setVarFileName(String varFileName) {
        this.varFileName = varFileName;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setTerraformParameters(Map<String, String> terraformParameters) {
        this.terraformParameters = terraformParameters;
    }

    public void setOutputListener(Consumer<String> outputListener) {
        this.outputListener = outputListener;
    }

    public void setErrorListener(Consumer<String> errorListener) {
        this.errorListener = errorListener;
    }

    public static class TerraformClientBuilder {
        private File workingDirectory;
        private boolean inheritIO;
        private boolean showColor;
        private boolean jsonOutput;
        private String terraformVersion;
        private String backendConfig;
        private String terraformReleasesUrl;
        private String tofuReleasesUrl;
        private String varFileName;
        private ArrayList<String> environmentVariables$key;
        private ArrayList<String> environmentVariables$value;
        private ArrayList<String> terraformParameters$key;
        private ArrayList<String> terraformParameters$value;
        private Consumer<String> outputListener;
        private Consumer<String> errorListener;

        TerraformClientBuilder() {
        }

        public TerraformClientBuilder workingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public TerraformClientBuilder inheritIO(boolean inheritIO) {
            this.inheritIO = inheritIO;
            return this;
        }

        public TerraformClientBuilder showColor(boolean showColor) {
            this.showColor = showColor;
            return this;
        }

        public TerraformClientBuilder jsonOutput(boolean jsonOutput) {
            this.jsonOutput = jsonOutput;
            return this;
        }

        public TerraformClientBuilder terraformVersion(String terraformVersion) {
            this.terraformVersion = terraformVersion;
            return this;
        }

        public TerraformClientBuilder backendConfig(String backendConfig) {
            this.backendConfig = backendConfig;
            return this;
        }

        public TerraformClientBuilder terraformReleasesUrl(String terraformReleasesUrl) {
            this.terraformReleasesUrl = terraformReleasesUrl;
            return this;
        }

        public TerraformClientBuilder tofuReleasesUrl(String tofuReleasesUrl) {
            this.tofuReleasesUrl = tofuReleasesUrl;
            return this;
        }

        public TerraformClientBuilder varFileName(String varFileName) {
            this.varFileName = varFileName;
            return this;
        }

        public TerraformClientBuilder environmentVariable(String environmentVariableKey, String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public TerraformClientBuilder environmentVariables(Map<? extends String, ? extends String> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables cannot be null");
            }
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TerraformClientBuilder clearEnvironmentVariables() {
            if (this.environmentVariables$key != null) {
                this.environmentVariables$key.clear();
                this.environmentVariables$value.clear();
            }
            return this;
        }

        public TerraformClientBuilder terraformParameter(String terraformParameterKey, String terraformParameterValue) {
            if (this.terraformParameters$key == null) {
                this.terraformParameters$key = new ArrayList();
                this.terraformParameters$value = new ArrayList();
            }
            this.terraformParameters$key.add(terraformParameterKey);
            this.terraformParameters$value.add(terraformParameterValue);
            return this;
        }

        public TerraformClientBuilder terraformParameters(Map<? extends String, ? extends String> terraformParameters) {
            if (terraformParameters == null) {
                throw new NullPointerException("terraformParameters cannot be null");
            }
            if (this.terraformParameters$key == null) {
                this.terraformParameters$key = new ArrayList();
                this.terraformParameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : terraformParameters.entrySet()) {
                this.terraformParameters$key.add($lombokEntry.getKey());
                this.terraformParameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TerraformClientBuilder clearTerraformParameters() {
            if (this.terraformParameters$key != null) {
                this.terraformParameters$key.clear();
                this.terraformParameters$value.clear();
            }
            return this;
        }

        public TerraformClientBuilder outputListener(Consumer<String> outputListener) {
            this.outputListener = outputListener;
            return this;
        }

        public TerraformClientBuilder errorListener(Consumer<String> errorListener) {
            this.errorListener = errorListener;
            return this;
        }

        public TerraformClient build() {
            Map<Object, Object> terraformParameters;
            Map<Object, Object> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            switch (this.terraformParameters$key == null ? 0 : this.terraformParameters$key.size()) {
                case 0: {
                    terraformParameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    terraformParameters = Collections.singletonMap(this.terraformParameters$key.get(0), this.terraformParameters$value.get(0));
                    break;
                }
                default: {
                    terraformParameters = new LinkedHashMap(this.terraformParameters$key.size() < 0x40000000 ? 1 + this.terraformParameters$key.size() + (this.terraformParameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.terraformParameters$key.size(); ++$i) {
                        terraformParameters.put(this.terraformParameters$key.get($i), this.terraformParameters$value.get($i));
                    }
                    terraformParameters = Collections.unmodifiableMap(terraformParameters);
                }
            }
            return new TerraformClient(this.workingDirectory, this.inheritIO, this.showColor, this.jsonOutput, this.terraformVersion, this.backendConfig, this.terraformReleasesUrl, this.tofuReleasesUrl, this.varFileName, environmentVariables, terraformParameters, this.outputListener, this.errorListener);
        }

        public String toString() {
            return "TerraformClient.TerraformClientBuilder(workingDirectory=" + this.workingDirectory + ", inheritIO=" + this.inheritIO + ", showColor=" + this.showColor + ", jsonOutput=" + this.jsonOutput + ", terraformVersion=" + this.terraformVersion + ", backendConfig=" + this.backendConfig + ", terraformReleasesUrl=" + this.terraformReleasesUrl + ", tofuReleasesUrl=" + this.tofuReleasesUrl + ", varFileName=" + this.varFileName + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", terraformParameters$key=" + this.terraformParameters$key + ", terraformParameters$value=" + this.terraformParameters$value + ", outputListener=" + this.outputListener + ", errorListener=" + this.errorListener + ")";
        }
    }
}

