/*
 * Decompiled with CFR 0.152.
 */
package org.terrakube.terraform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;

public class TerraformProcessData {
    @NonNull
    String terraformVersion;
    @NonNull
    File workingDirectory;
    String terraformBackendConfigFileName;
    String varFileName;
    File sshFile;
    boolean refresh;
    boolean refreshOnly;
    boolean tofu;
    Map<String, String> terraformVariables;
    Map<String, String> terraformEnvironmentVariables;

    private static boolean $default$refresh() {
        return true;
    }

    private static boolean $default$refreshOnly() {
        return false;
    }

    private static boolean $default$tofu() {
        return false;
    }

    public static TerraformProcessDataBuilder builder() {
        return new TerraformProcessDataBuilder();
    }

    public TerraformProcessData(@NonNull String terraformVersion, @NonNull File workingDirectory, String terraformBackendConfigFileName, String varFileName, File sshFile, boolean refresh, boolean refreshOnly, boolean tofu, Map<String, String> terraformVariables, Map<String, String> terraformEnvironmentVariables) {
        if (terraformVersion == null) {
            throw new NullPointerException("terraformVersion is marked non-null but is null");
        }
        if (workingDirectory == null) {
            throw new NullPointerException("workingDirectory is marked non-null but is null");
        }
        this.terraformVersion = terraformVersion;
        this.workingDirectory = workingDirectory;
        this.terraformBackendConfigFileName = terraformBackendConfigFileName;
        this.varFileName = varFileName;
        this.sshFile = sshFile;
        this.refresh = refresh;
        this.refreshOnly = refreshOnly;
        this.tofu = tofu;
        this.terraformVariables = terraformVariables;
        this.terraformEnvironmentVariables = terraformEnvironmentVariables;
    }

    @NonNull
    public String getTerraformVersion() {
        return this.terraformVersion;
    }

    @NonNull
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getTerraformBackendConfigFileName() {
        return this.terraformBackendConfigFileName;
    }

    public String getVarFileName() {
        return this.varFileName;
    }

    public File getSshFile() {
        return this.sshFile;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public boolean isRefreshOnly() {
        return this.refreshOnly;
    }

    public boolean isTofu() {
        return this.tofu;
    }

    public Map<String, String> getTerraformVariables() {
        return this.terraformVariables;
    }

    public Map<String, String> getTerraformEnvironmentVariables() {
        return this.terraformEnvironmentVariables;
    }

    public void setTerraformVersion(@NonNull String terraformVersion) {
        if (terraformVersion == null) {
            throw new NullPointerException("terraformVersion is marked non-null but is null");
        }
        this.terraformVersion = terraformVersion;
    }

    public void setWorkingDirectory(@NonNull File workingDirectory) {
        if (workingDirectory == null) {
            throw new NullPointerException("workingDirectory is marked non-null but is null");
        }
        this.workingDirectory = workingDirectory;
    }

    public void setTerraformBackendConfigFileName(String terraformBackendConfigFileName) {
        this.terraformBackendConfigFileName = terraformBackendConfigFileName;
    }

    public void setVarFileName(String varFileName) {
        this.varFileName = varFileName;
    }

    public void setSshFile(File sshFile) {
        this.sshFile = sshFile;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setRefreshOnly(boolean refreshOnly) {
        this.refreshOnly = refreshOnly;
    }

    public void setTofu(boolean tofu) {
        this.tofu = tofu;
    }

    public void setTerraformVariables(Map<String, String> terraformVariables) {
        this.terraformVariables = terraformVariables;
    }

    public void setTerraformEnvironmentVariables(Map<String, String> terraformEnvironmentVariables) {
        this.terraformEnvironmentVariables = terraformEnvironmentVariables;
    }

    public static class TerraformProcessDataBuilder {
        private String terraformVersion;
        private File workingDirectory;
        private String terraformBackendConfigFileName;
        private String varFileName;
        private File sshFile;
        private boolean refresh$set;
        private boolean refresh$value;
        private boolean refreshOnly$set;
        private boolean refreshOnly$value;
        private boolean tofu$set;
        private boolean tofu$value;
        private ArrayList<String> terraformVariables$key;
        private ArrayList<String> terraformVariables$value;
        private ArrayList<String> terraformEnvironmentVariables$key;
        private ArrayList<String> terraformEnvironmentVariables$value;

        TerraformProcessDataBuilder() {
        }

        public TerraformProcessDataBuilder terraformVersion(@NonNull String terraformVersion) {
            if (terraformVersion == null) {
                throw new NullPointerException("terraformVersion is marked non-null but is null");
            }
            this.terraformVersion = terraformVersion;
            return this;
        }

        public TerraformProcessDataBuilder workingDirectory(@NonNull File workingDirectory) {
            if (workingDirectory == null) {
                throw new NullPointerException("workingDirectory is marked non-null but is null");
            }
            this.workingDirectory = workingDirectory;
            return this;
        }

        public TerraformProcessDataBuilder terraformBackendConfigFileName(String terraformBackendConfigFileName) {
            this.terraformBackendConfigFileName = terraformBackendConfigFileName;
            return this;
        }

        public TerraformProcessDataBuilder varFileName(String varFileName) {
            this.varFileName = varFileName;
            return this;
        }

        public TerraformProcessDataBuilder sshFile(File sshFile) {
            this.sshFile = sshFile;
            return this;
        }

        public TerraformProcessDataBuilder refresh(boolean refresh) {
            this.refresh$value = refresh;
            this.refresh$set = true;
            return this;
        }

        public TerraformProcessDataBuilder refreshOnly(boolean refreshOnly) {
            this.refreshOnly$value = refreshOnly;
            this.refreshOnly$set = true;
            return this;
        }

        public TerraformProcessDataBuilder tofu(boolean tofu) {
            this.tofu$value = tofu;
            this.tofu$set = true;
            return this;
        }

        public TerraformProcessDataBuilder terraformVariable(String terraformVariableKey, String terraformVariableValue) {
            if (this.terraformVariables$key == null) {
                this.terraformVariables$key = new ArrayList();
                this.terraformVariables$value = new ArrayList();
            }
            this.terraformVariables$key.add(terraformVariableKey);
            this.terraformVariables$value.add(terraformVariableValue);
            return this;
        }

        public TerraformProcessDataBuilder terraformVariables(Map<? extends String, ? extends String> terraformVariables) {
            if (terraformVariables == null) {
                throw new NullPointerException("terraformVariables cannot be null");
            }
            if (this.terraformVariables$key == null) {
                this.terraformVariables$key = new ArrayList();
                this.terraformVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : terraformVariables.entrySet()) {
                this.terraformVariables$key.add($lombokEntry.getKey());
                this.terraformVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TerraformProcessDataBuilder clearTerraformVariables() {
            if (this.terraformVariables$key != null) {
                this.terraformVariables$key.clear();
                this.terraformVariables$value.clear();
            }
            return this;
        }

        public TerraformProcessDataBuilder terraformEnvironmentVariable(String terraformEnvironmentVariableKey, String terraformEnvironmentVariableValue) {
            if (this.terraformEnvironmentVariables$key == null) {
                this.terraformEnvironmentVariables$key = new ArrayList();
                this.terraformEnvironmentVariables$value = new ArrayList();
            }
            this.terraformEnvironmentVariables$key.add(terraformEnvironmentVariableKey);
            this.terraformEnvironmentVariables$value.add(terraformEnvironmentVariableValue);
            return this;
        }

        public TerraformProcessDataBuilder terraformEnvironmentVariables(Map<? extends String, ? extends String> terraformEnvironmentVariables) {
            if (terraformEnvironmentVariables == null) {
                throw new NullPointerException("terraformEnvironmentVariables cannot be null");
            }
            if (this.terraformEnvironmentVariables$key == null) {
                this.terraformEnvironmentVariables$key = new ArrayList();
                this.terraformEnvironmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : terraformEnvironmentVariables.entrySet()) {
                this.terraformEnvironmentVariables$key.add($lombokEntry.getKey());
                this.terraformEnvironmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public TerraformProcessDataBuilder clearTerraformEnvironmentVariables() {
            if (this.terraformEnvironmentVariables$key != null) {
                this.terraformEnvironmentVariables$key.clear();
                this.terraformEnvironmentVariables$value.clear();
            }
            return this;
        }

        public TerraformProcessData build() {
            Map<Object, Object> terraformEnvironmentVariables;
            Map<Object, Object> terraformVariables;
            switch (this.terraformVariables$key == null ? 0 : this.terraformVariables$key.size()) {
                case 0: {
                    terraformVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    terraformVariables = Collections.singletonMap(this.terraformVariables$key.get(0), this.terraformVariables$value.get(0));
                    break;
                }
                default: {
                    terraformVariables = new LinkedHashMap(this.terraformVariables$key.size() < 0x40000000 ? 1 + this.terraformVariables$key.size() + (this.terraformVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.terraformVariables$key.size(); ++$i) {
                        terraformVariables.put(this.terraformVariables$key.get($i), this.terraformVariables$value.get($i));
                    }
                    terraformVariables = Collections.unmodifiableMap(terraformVariables);
                }
            }
            switch (this.terraformEnvironmentVariables$key == null ? 0 : this.terraformEnvironmentVariables$key.size()) {
                case 0: {
                    terraformEnvironmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    terraformEnvironmentVariables = Collections.singletonMap(this.terraformEnvironmentVariables$key.get(0), this.terraformEnvironmentVariables$value.get(0));
                    break;
                }
                default: {
                    terraformEnvironmentVariables = new LinkedHashMap(this.terraformEnvironmentVariables$key.size() < 0x40000000 ? 1 + this.terraformEnvironmentVariables$key.size() + (this.terraformEnvironmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.terraformEnvironmentVariables$key.size(); ++$i) {
                        terraformEnvironmentVariables.put(this.terraformEnvironmentVariables$key.get($i), this.terraformEnvironmentVariables$value.get($i));
                    }
                    terraformEnvironmentVariables = Collections.unmodifiableMap(terraformEnvironmentVariables);
                }
            }
            boolean refresh$value = this.refresh$value;
            if (!this.refresh$set) {
                refresh$value = TerraformProcessData.$default$refresh();
            }
            boolean refreshOnly$value = this.refreshOnly$value;
            if (!this.refreshOnly$set) {
                refreshOnly$value = TerraformProcessData.$default$refreshOnly();
            }
            boolean tofu$value = this.tofu$value;
            if (!this.tofu$set) {
                tofu$value = TerraformProcessData.$default$tofu();
            }
            return new TerraformProcessData(this.terraformVersion, this.workingDirectory, this.terraformBackendConfigFileName, this.varFileName, this.sshFile, refresh$value, refreshOnly$value, tofu$value, terraformVariables, terraformEnvironmentVariables);
        }

        public String toString() {
            return "TerraformProcessData.TerraformProcessDataBuilder(terraformVersion=" + this.terraformVersion + ", workingDirectory=" + this.workingDirectory + ", terraformBackendConfigFileName=" + this.terraformBackendConfigFileName + ", varFileName=" + this.varFileName + ", sshFile=" + this.sshFile + ", refresh$value=" + this.refresh$value + ", refreshOnly$value=" + this.refreshOnly$value + ", tofu$value=" + this.tofu$value + ", terraformVariables$key=" + this.terraformVariables$key + ", terraformVariables$value=" + this.terraformVariables$value + ", terraformEnvironmentVariables$key=" + this.terraformEnvironmentVariables$key + ", terraformEnvironmentVariables$value=" + this.terraformEnvironmentVariables$value + ")";
        }
    }
}

