/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.applications.batchquerying;

import org.terrier.applications.batchquerying.QuerySource;
import org.terrier.indexing.tokenisation.Tokeniser;

public class QuerySourceUtils {
    public static QuerySource create(String[] qids, String[] qs, boolean tokenise) {
        return QuerySourceUtils.create(qids, qs, (Tokeniser)(tokenise ? Tokeniser.getTokeniser() : null));
    }

    public static QuerySource create(final String[] qids, final String[] qs, final Tokeniser tok) {
        return new QuerySource(){
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < qids.length - 1;
            }

            @Override
            public String next() {
                ++this.i;
                String q = qs[this.i];
                if (tok != null) {
                    q = String.join((CharSequence)" ", tok.getTokens(q));
                }
                return q;
            }

            @Override
            public String getQueryId() {
                return qids[this.i];
            }

            @Override
            public void reset() {
                this.i = -1;
            }

            @Override
            public String[] getInfo() {
                return new String[]{"DirectQuerySource"};
            }
        };
    }
}

