/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.applications.batchquerying;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.terrier.applications.batchquerying.TRECQuery;
import org.terrier.indexing.tokenisation.IdentityTokeniser;
import org.terrier.indexing.tokenisation.Tokeniser;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.ArrayUtils;
import org.terrier.utility.Files;
import org.terrier.utility.TagSet;

public class SingleLineTRECQuery
extends TRECQuery {
    protected Tokeniser tokeniser;
    protected boolean tokenise;

    public SingleLineTRECQuery() {
        this.tokenise = true;
    }

    public SingleLineTRECQuery(String[] queryfilenames) {
        this(queryfilenames, Boolean.parseBoolean(ApplicationSetup.getProperty((String)"SingleLineTRECQuery.tokenise", (String)"false")));
    }

    public SingleLineTRECQuery(String queryfilename) {
        this(queryfilename, Boolean.parseBoolean(ApplicationSetup.getProperty((String)"SingleLineTRECQuery.tokenise", (String)"false")));
    }

    public SingleLineTRECQuery(String queryfilename, boolean tokenise) {
        super(queryfilename);
        this.tokenise = true;
        this.tokenise = tokenise;
        this.tokeniser = Tokeniser.getTokeniser();
    }

    public SingleLineTRECQuery(String queryfilename, Tokeniser tokeniser) {
        super(queryfilename);
        this.tokenise = this.tokenise = true;
        this.tokeniser = tokeniser;
    }

    public SingleLineTRECQuery(String[] queryfilenames, boolean tokenise) {
        super(queryfilenames);
        this.tokenise = true;
        this.tokenise = tokenise;
        this.tokeniser = Tokeniser.getTokeniser();
    }

    public SingleLineTRECQuery(String[] queryfilenames, Tokeniser tokeniser) {
        super(queryfilenames);
        this.tokenise = this.tokenise = true;
        this.tokeniser = tokeniser;
    }

    @Override
    public boolean extractQuery(String queryfilename, TagSet ignore, Vector<String> vecStringQueries, Vector<String> vecStringIds) {
        boolean gotSome = false;
        boolean QueryLineHasQueryID = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"SingleLineTRECQuery.queryid.exists", (String)"true"));
        this.tokeniser = this.tokenise ? Tokeniser.getTokeniser() : new IdentityTokeniser();
        logger.info("Extracting queries from " + queryfilename + " tokeniser=" + this.tokeniser.getClass().getSimpleName());
        try {
            if (!Files.exists((String)queryfilename)) {
                logger.error("The topics file " + queryfilename + " does not exist, or it cannot be read.");
                return false;
            }
            BufferedReader br = Files.openFileReader((String)queryfilename, (String)this.desiredEncoding);
            String line = null;
            int queryCount = 0;
            while ((line = br.readLine()) != null) {
                String query;
                Object queryID;
                if ((line = line.trim()).startsWith("#")) continue;
                ++queryCount;
                if (QueryLineHasQueryID) {
                    int queryIdEnd = SingleLineTRECQuery.minOver0(new int[]{line.indexOf(32), line.indexOf(9), line.indexOf(":")});
                    if (queryIdEnd == -1) continue;
                    queryID = line.substring(0, queryIdEnd);
                    query = line.substring(queryIdEnd + 1);
                } else {
                    query = line;
                    queryID = "" + queryCount;
                }
                query = ArrayUtils.join((String[])this.tokeniser.getTokens((Reader)new StringReader(query)), (String)" ");
                vecStringQueries.add(query);
                vecStringIds.add((String)queryID);
                gotSome = true;
                logger.debug("Extracted queryID " + (String)queryID + " " + query);
            }
            br.close();
        }
        catch (IOException ioe) {
            logger.error("IOException while extracting queries: ", (Throwable)ioe);
            return gotSome;
        }
        logger.info("Extracted " + vecStringQueries.size() + " queries");
        return gotSome;
    }

    static int minOver0(int[] a) {
        int min = Integer.MAX_VALUE;
        for (int i : a) {
            if (i == -1 || i >= min) continue;
            min = i;
        }
        return min != Integer.MAX_VALUE ? min : -1;
    }
}

