/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.applications.batchquerying;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.applications.batchquerying.QuerySource;
import org.terrier.indexing.TRECFullTokenizer;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.ArrayUtils;
import org.terrier.utility.Files;
import org.terrier.utility.TagSet;

public class TRECQuery
implements QuerySource {
    protected static final Logger logger = LoggerFactory.getLogger(TRECQuery.class);
    protected static final boolean IGNORE_DESC_NARR_NAME_TOKENS = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"trecquery.ignore.desc.narr.name.tokens", (String)"true"));
    protected String desiredEncoding = ApplicationSetup.getProperty((String)"trec.encoding", null);
    protected String[] topicFiles;
    protected String[] queries = null;
    protected String[] query_ids = null;
    protected int index;
    protected TagSet tags;

    public boolean extractQuery(String[] queryfilenames, TagSet t, Vector<String> vecStringQueries, Vector<String> vecStringIds) {
        boolean rtn = false;
        for (int i = 0; i < queryfilenames.length; ++i) {
            if (!this.extractQuery(queryfilenames[i], t, vecStringQueries, vecStringIds)) continue;
            rtn = true;
        }
        return rtn;
    }

    public boolean extractQuery(String queryfilename, TagSet t, Vector<String> vecStringQueries, Vector<String> vecStringIds) {
        boolean gotSome = false;
        try {
            if (!Files.exists((String)queryfilename) || !Files.canRead((String)queryfilename)) {
                logger.error("The topics file " + queryfilename + " does not exist, or it cannot be read.");
                return false;
            }
            BufferedReader br = Files.openFileReader((String)queryfilename, (String)this.desiredEncoding);
            TRECFullTokenizer queryTokenizer = new TRECFullTokenizer(t, new TagSet(""), br);
            queryTokenizer.setIgnoreMissingClosingTags(true);
            while (!queryTokenizer.isEndOfFile()) {
                boolean seenNarrativeToken;
                String docnoToken = null;
                StringBuilder query = new StringBuilder();
                boolean seenDescriptionToken = !IGNORE_DESC_NARR_NAME_TOKENS;
                boolean bl = seenNarrativeToken = !IGNORE_DESC_NARR_NAME_TOKENS;
                while (!queryTokenizer.isEndOfDocument()) {
                    String token = queryTokenizer.nextToken();
                    if (token == null || token.length() == 0 || queryTokenizer.inTagToSkip()) continue;
                    if (queryTokenizer.inDocnoTag()) {
                        StringTokenizer docnoTokens = new StringTokenizer(token.trim(), " ");
                        while (docnoTokens.hasMoreTokens()) {
                            String tok = docnoTokens.nextToken().trim();
                            if (tok.equalsIgnoreCase("number")) continue;
                            docnoToken = tok;
                        }
                        continue;
                    }
                    if (!queryTokenizer.inTagToProcess() || !seenDescriptionToken && queryTokenizer.currentTag().equalsIgnoreCase("DESC") && token.equalsIgnoreCase("DESCRIPTION") || !seenNarrativeToken && queryTokenizer.currentTag().equalsIgnoreCase("NARR") && token.equalsIgnoreCase("NARRATIVE")) continue;
                    query.append(token);
                    query.append(' ');
                }
                queryTokenizer.nextDocument();
                if (query.length() == 0) continue;
                vecStringQueries.add(query.toString().trim());
                if (docnoToken == null) {
                    throw new IOException("No id tag found for this query");
                }
                vecStringIds.add(docnoToken);
                gotSome = true;
            }
            br.close();
        }
        catch (IOException ioe) {
            logger.error("Input/Output exception while extracting queries from the topic file named " + queryfilename, (Throwable)ioe);
        }
        return gotSome;
    }

    public TRECQuery(String[] queryfilenames, String docTag, String idTag, String[] whitelist, String[] blacklist) {
        TagSet.TagSetFactory fact = TagSet.factory().setDocTag(docTag).setIdTag(idTag);
        if (whitelist != null) {
            fact.setWhitelist(whitelist);
        }
        if (blacklist != null) {
            fact.setBlacklist(blacklist);
        }
        this.tags = fact.build();
        this.topicFiles = queryfilenames;
    }

    public TRECQuery() {
        this(ArrayUtils.parseCommaDelimitedString((String)ApplicationSetup.getProperty((String)"trec.topics", (String)"")));
    }

    public TRECQuery(String queryfilename) {
        this(new String[]{queryfilename});
    }

    public TRECQuery(String[] queryfilenames) {
        this.topicFiles = queryfilenames;
        this.tags = new TagSet("TrecQueryTags");
        this.checkEncoding();
    }

    protected void checkEncoding() {
        if (this.desiredEncoding == null) {
            String defaultEncoding = Charset.defaultCharset().name();
            if (!defaultEncoding.equals("UTF-8")) {
                logger.warn("trec.encoding is not set; resorting to platform default (" + defaultEncoding + "). Retrieval may be platform dependent. Recommend trec.encoding=UTF-8");
            }
            this.desiredEncoding = defaultEncoding;
        }
    }

    protected void performExtraction() {
        Vector<String> vecStringQueries = new Vector<String>();
        Vector<String> vecStringQueryIDs = new Vector<String>();
        this.checkEncoding();
        if (!this.extractQuery(this.topicFiles, this.tags, vecStringQueries, vecStringQueryIDs)) {
            logger.error("Topic files were specified, but non could be parsed correctly to obtain any topics. Check you have the correct topic files specified, and that tags are correct.");
            return;
        }
        this.queries = vecStringQueries.toArray(new String[0]);
        this.query_ids = vecStringQueryIDs.toArray(new String[0]);
        this.index = 0;
    }

    public int getIndexOfCurrentQuery() {
        return this.index - 1;
    }

    public int getNumberOfQueries() {
        return this.queries.length;
    }

    @Override
    public String[] getInfo() {
        return this.topicFiles;
    }

    public String getQuery(String queryNo) {
        for (int i = 0; i < this.query_ids.length; ++i) {
            if (!this.query_ids[i].equals(queryNo)) continue;
            return this.queries[i];
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.queries == null) {
            this.performExtraction();
        }
        return this.index != this.queries.length;
    }

    @Override
    public String next() {
        if (this.queries == null) {
            this.performExtraction();
        }
        if (this.index == this.queries.length) {
            return null;
        }
        return this.queries[this.index++];
    }

    @Override
    public String getQueryId() {
        return this.query_ids[this.index == 0 ? 0 : this.index - 1];
    }

    public String[] getQueryIds() {
        return this.query_ids;
    }

    public String[] toArray() {
        return (String[])this.queries.clone();
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        TRECQuery source = new TRECQuery(args[0]);
        while (source.hasNext()) {
            String query = source.next();
            String id = source.getQueryId();
            System.out.println(id + ": " + query);
        }
    }
}

