/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.applications.batchquerying;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.applications.AbstractQuerying;
import org.terrier.applications.batchquerying.QuerySource;
import org.terrier.applications.batchquerying.SingleLineTRECQuery;
import org.terrier.matching.ResultSet;
import org.terrier.matching.models.queryexpansion.Bo1;
import org.terrier.querying.IndexRef;
import org.terrier.querying.Manager;
import org.terrier.querying.ManagerFactory;
import org.terrier.querying.Request;
import org.terrier.querying.SearchRequest;
import org.terrier.structures.Index;
import org.terrier.structures.IndexFactory;
import org.terrier.structures.IndexUtil;
import org.terrier.structures.cache.NullQueryResultCache;
import org.terrier.structures.cache.QueryResultCache;
import org.terrier.structures.outputformat.OutputFormat;
import org.terrier.structures.outputformat.RawOutputFormat;
import org.terrier.structures.outputformat.TRECDocidOutputFormat;
import org.terrier.structures.outputformat.TRECDocnoOutputFormat;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.ArrayUtils;
import org.terrier.utility.Files;

public class TRECQuerying
extends AbstractQuerying {
    public static final String BATCHRETRIEVE_COMMAND = "batchretrieval";
    public static final String BATCHRETRIEVE_PROP_PREFIX = "trec";
    protected String defaultQEModel;
    protected static final Logger logger = LoggerFactory.getLogger(TRECQuerying.class);
    protected static boolean removeQueryPeriods = false;
    protected static final Random random = new Random();
    protected volatile PrintWriter resultFile;
    protected OutputStream resultFileRaw;
    protected String resultsFilename;
    protected static boolean DUMP_SETTINGS = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"trec.querying.dump.settings", (String)"true"));
    protected Manager queryingManager;
    protected String mModel = ApplicationSetup.getProperty((String)"trec.matching", null);
    protected static int RESULTS_LENGTH = Integer.parseInt(ApplicationSetup.getProperty((String)"trec.output.format.length", (String)"1000"));
    protected static String ITERATION = ApplicationSetup.getProperty((String)"trec.iteration", (String)"Q");
    protected String method = null;
    private String topicsParser = ApplicationSetup.getProperty((String)"trec.topics.parser", (String)"TRECQuery");
    protected QuerySource querySource;
    protected OutputFormat printer;
    protected QueryResultCache resultsCache;

    public TRECQuerying() {
        super(BATCHRETRIEVE_PROP_PREFIX);
        this.loadIndex();
        this.matchopQl = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"trec.topics.matchopql", (String)"false"));
    }

    public TRECQuerying(IndexRef _indexref) {
        super(BATCHRETRIEVE_PROP_PREFIX, _indexref);
        this.matchopQl = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"trec.topics.matchopql", (String)"false"));
    }

    public void intialise() {
        this.createManager();
        this.querySource = TRECQuerying.getQueryParser(this.getTopicsParser());
        this.printer = this.getOutputFormat();
        this.resultsCache = this.getResultsCache();
    }

    protected QueryResultCache getResultsCache() {
        QueryResultCache rtr = null;
        try {
            Object className = ApplicationSetup.getProperty((String)"trec.querying.resultscache", (String)NullQueryResultCache.class.getName());
            if (!((String)className).contains(".")) {
                className = "org.terrier.applications.TRECQuerying$" + (String)className;
            }
            rtr = ApplicationSetup.getClass((String)className).asSubclass(QueryResultCache.class).newInstance();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return rtr;
    }

    protected OutputFormat getOutputFormat() {
        OutputFormat rtr = null;
        try {
            Object className = ApplicationSetup.getProperty((String)"trec.querying.outputformat", (String)TRECDocnoOutputFormat.class.getName());
            logger.debug("Trying to load " + (String)className);
            if (!((String)className).contains(".")) {
                className = OutputFormat.class.getPackage().getName() + "." + (String)className;
            }
            Index index = IndexFactory.isLoaded((IndexRef)this.indexref) ? IndexFactory.of((IndexRef)this.indexref) : null;
            rtr = ApplicationSetup.getClass((String)className).asSubclass(OutputFormat.class).getConstructor(Index.class).newInstance(index);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new IllegalArgumentException("Could not load TREC OutputFormat class", e);
        }
        logger.debug("returning " + rtr.toString() + " as printer");
        return rtr;
    }

    protected void createManager() {
        this.queryingManager = ManagerFactory.from((IndexRef)this.indexref);
    }

    protected void loadIndex() {
        this.indexref = IndexRef.of((String)ApplicationSetup.TERRIER_INDEX_PATH, (String)ApplicationSetup.TERRIER_INDEX_PREFIX);
    }

    public IndexRef getIndexRef() {
        return this.indexref;
    }

    public Manager getManager() {
        return this.queryingManager;
    }

    public void close() {
    }

    protected String getNextQueryCounter(String resultsFolder) {
        String type = ApplicationSetup.getProperty((String)"trec.querycounter.type", (String)"sequential").toLowerCase();
        if (type.equals("sequential")) {
            return this.getSequentialQueryCounter(resultsFolder);
        }
        if (type.equals("random")) {
            return this.getRandomQueryCounter();
        }
        throw new IllegalArgumentException("Unsupported value for propert trec.querycounter.type: must be one of sequential or random.");
    }

    protected String getRandomQueryCounter() {
        return System.currentTimeMillis() / 1000L + "-" + random.nextInt(1000);
    }

    protected String getSequentialQueryCounter(String resultsFolder) {
        File fx = new File(resultsFolder, "querycounter");
        int counter = 0;
        if (!fx.exists()) {
            try {
                BufferedWriter bufw = new BufferedWriter(new FileWriter(fx));
                bufw.write(counter + ApplicationSetup.EOL);
                bufw.close();
            }
            catch (IOException ioe) {
                logger.error("Input/Output exception while creating querycounter. Stack trace follows.", (Throwable)ioe);
            }
        } else {
            try {
                BufferedReader buf = new BufferedReader(new FileReader(fx));
                String s = buf.readLine();
                counter = s != null ? Integer.parseInt(s) : 0;
                buf.close();
                BufferedWriter bufw = new BufferedWriter(new FileWriter(fx));
                bufw.write(++counter + ApplicationSetup.EOL);
                bufw.close();
            }
            catch (Exception e) {
                logger.error("Exception occurred when defining querycounter", (Throwable)e);
            }
        }
        return "" + counter;
    }

    public PrintWriter getResultFile(String predefinedName) {
        String PREDEFINED_RESULT_PREFIX = "prob";
        PrintWriter _resultFile = null;
        File fx = new File(ApplicationSetup.TREC_RESULTS);
        if (!fx.exists() && !fx.mkdir()) {
            logger.error("Could not create results directory (" + ApplicationSetup.TREC_RESULTS + ") - permissions problem?");
            return null;
        }
        try {
            String theFilename = ApplicationSetup.getProperty((String)"trec.results.file", null);
            if (theFilename != null) {
                theFilename = ApplicationSetup.makeAbsolute((String)theFilename, (String)ApplicationSetup.TREC_RESULTS);
                this.resultFileRaw = Files.writeFileStream((String)theFilename);
                _resultFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.resultFileRaw)));
                this.resultsFilename = theFilename;
                if (logger.isInfoEnabled()) {
                    logger.info("Writing results to " + this.resultsFilename);
                }
                return _resultFile;
            }
            String querycounter = this.getNextQueryCounter(ApplicationSetup.TREC_RESULTS);
            String prefix = null;
            prefix = predefinedName == null || predefinedName.equals("") ? "prob" : predefinedName;
            this.resultsFilename = ApplicationSetup.TREC_RESULTS + "/" + prefix + "_" + querycounter + ApplicationSetup.TREC_RESULTS_SUFFIX;
            this.resultFileRaw = Files.writeFileStream((String)this.resultsFilename);
            _resultFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.resultFileRaw)));
            if (logger.isInfoEnabled()) {
                logger.info("Writing results to " + this.resultsFilename);
            }
        }
        catch (IOException e) {
            logger.error("Input/Output exception while creating the result file. Stack trace follows.", (Throwable)e);
        }
        return _resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQueryAndWrite(String queryId, String query) {
        if (query == null || query.trim().length() == 0) {
            logger.warn("Ignoring empty query " + queryId);
            return;
        }
        SearchRequest srq = this.processQuery(queryId, query);
        TRECQuerying tRECQuerying = this;
        synchronized (tRECQuerying) {
            if (this.resultFile == null) {
                this.method = ApplicationSetup.getProperty((String)"trec.runtag", (String)srq.getControl("wmodel", srq.getControl("runtag", "unknown")));
                if (srq.hasControl("qe")) {
                    this.method = this.method + "_d_" + ApplicationSetup.getProperty((String)"expansion.documents", (String)"3") + "_t_" + ApplicationSetup.getProperty((String)"expansion.terms", (String)"10");
                }
                this.resultFile = this.getResultFile(this.method);
            }
        }
        long t = System.currentTimeMillis();
        try {
            logger.debug("Trying to print results to " + this.printer.getClass().getSimpleName());
            if (this.printer instanceof RawOutputFormat) {
                ((RawOutputFormat)this.printer).writeResults(this.resultFileRaw, srq, this.method, ITERATION + "0", RESULTS_LENGTH);
            } else {
                this.printer.printResults(this.resultFile, srq, this.method, ITERATION + "0", RESULTS_LENGTH);
            }
        }
        catch (IOException ioe) {
            logger.error("Problem writing results file:", (Throwable)ioe);
        }
        logger.debug("Time to write results: " + (System.currentTimeMillis() - t));
    }

    public SearchRequest processQuery(String queryId, String query) {
        if (removeQueryPeriods && query.indexOf(".") > -1) {
            logger.warn("Removed . from query");
            query = query.replaceAll("\\.", " ");
        }
        if (logger.isInfoEnabled()) {
            logger.info(queryId + " : " + query);
        }
        SearchRequest srq = this.queryingManager.newSearchRequest(queryId, query);
        if (this.matchopQl) {
            srq.setControl("parsecontrols", "off");
            srq.setControl("parseql", "off");
            srq.setControl("terrierql", "off");
            srq.setControl("matchopql", "on");
        }
        this.controls.forEach((k, v) -> srq.setControl(k, v));
        this.initSearchRequestModification(queryId, srq);
        if (this.mModel != null) {
            srq.setControl("matching", this.mModel);
        }
        if (srq.getControl("qe").equals("on")) {
            srq.setControl("qemodel", this.defaultQEModel);
        }
        this.preQueryingSearchRequestModification(queryId, srq);
        ResultSet rs = this.resultsCache.checkCache(srq);
        if (rs != null) {
            ((Request)rs).setResultSet(rs);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Processing query: " + queryId + ": '" + query + "'");
        }
        ++this.matchingCount;
        this.queryingManager.runSearchRequest(srq);
        this.resultsCache.add(srq);
        return srq;
    }

    protected void preQueryingSearchRequestModification(String queryId, SearchRequest srq) {
    }

    protected void initSearchRequestModification(String queryId, SearchRequest srq) {
    }

    public static QuerySource getQueryParser(String parserName) {
        String[] topicsFiles = null;
        QuerySource rtr = null;
        try {
            Class<QuerySource> queryingClass = ApplicationSetup.getClass((String)(parserName.indexOf(46) > 0 ? parserName : "org.terrier.applications.batchquerying." + parserName)).asSubclass(QuerySource.class);
            topicsFiles = ArrayUtils.parseCommaDelimitedString((String)ApplicationSetup.getProperty((String)"trec.topics", (String)""));
            if (topicsFiles.length > 0) {
                Class[] types = new Class[]{String[].class};
                Object[] params = new Object[]{topicsFiles};
                rtr = queryingClass.getConstructor(types).newInstance(params);
            } else {
                logger.error("Error instantiating topic file.  Please set the topic file(s) using trec.topics property", (Throwable)new IllegalArgumentException());
            }
        }
        catch (Exception e) {
            logger.error("Error instantiating topic file QuerySource called " + parserName, (Throwable)e);
        }
        return rtr;
    }

    public String processQueries() {
        this.querySource.reset();
        return this.processQueries(this.querySource);
    }

    public String processQueries(QuerySource _qs) {
        this.matchingCount = 0;
        this.startingBatchOfQueries();
        long startTime = System.currentTimeMillis();
        boolean doneSomeMethods = false;
        boolean doneSomeTopics = false;
        this.defaultQEModel = ApplicationSetup.getProperty((String)"trec.qe.model", (String)Bo1.class.getName());
        while (_qs.hasNext()) {
            String query = (String)_qs.next();
            String qid = _qs.getQueryId();
            long processingStart = System.currentTimeMillis();
            this.processQueryAndWrite(qid, query);
            long processingEnd = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info("Time to process query " + qid + ": " + (double)(processingEnd - processingStart) / 1000.0);
            }
            doneSomeTopics = true;
        }
        this.finishedQueries();
        doneSomeMethods = true;
        if (DUMP_SETTINGS && doneSomeTopics) {
            this.printSettings(this.queryingManager.newSearchRequest(""), _qs.getInfo(), "# run started at: " + startTime + "\n# run finished at " + System.currentTimeMillis());
        }
        if (doneSomeTopics && doneSomeMethods) {
            logger.info("Finished topics, executed " + this.matchingCount + " queries in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds, results written to " + this.resultsFilename);
        }
        return this.resultsFilename;
    }

    protected void startingBatchOfQueries() {
    }

    protected void finishedQueries() {
        if (this.resultFile != null) {
            this.resultFile.close();
        }
        this.resultFile = null;
    }

    public void printSettings(SearchRequest default_q, String[] topicsFiles, String otherComments) {
        try {
            if (this.resultsFilename.equals("-")) {
                logger.info("Skipping writing of Terrier settings as stdout is the results file");
                return;
            }
            OutputStream bos = Files.writeFileStream((String)(this.resultsFilename.replaceFirst("\\.res(\\.\\w+)?$", ".res") + ".settings"));
            ApplicationSetup.getUsedProperties().store(bos, " Settings of Terrier (TRECQuerying) generated for run " + this.resultsFilename);
            PrintWriter pw = new PrintWriter(bos);
            if (topicsFiles != null) {
                for (String f : topicsFiles) {
                    pw.println("# topicfile: " + f);
                }
            }
            pw.println("# indexref:" + this.indexref.toString());
            HashMap defaultcontrols = new HashMap(default_q.getControls());
            defaultcontrols.putAll(this.controls);
            for (Map.Entry kv : defaultcontrols.entrySet()) {
                pw.println(String.format("# control: %s=%s", kv.getKey(), kv.getValue()));
            }
            pw.println(otherComments);
            pw.close();
            logger.info("Settings of Terrier written to " + this.resultsFilename + ".settings");
        }
        catch (IOException ioe) {
            logger.warn("Couldn't write settings out to disk in TRECQuerying (.res.settings)", (Throwable)ioe);
        }
    }

    public String getTopicsParser() {
        return this.topicsParser;
    }

    public void setTopicsParser(String topicsParser) {
        this.topicsParser = topicsParser;
    }

    public static class Command
    extends AbstractQuerying.AbstractQueryingCommand {
        public Command() {
            super(TRECQuerying.class);
        }

        protected Command(Class<? extends TRECQuerying> clz) {
            super(clz);
        }

        protected Options getOptions() {
            Options options = super.getOptions();
            options.addOption(Option.builder((String)"d").argName("docids").longOpt("docids").desc("specifies that Terrier will returns docids rather than docnos. Do not mix with -F.").build());
            options.addOption(Option.builder((String)"F").argName("format").longOpt("format").hasArg().desc("changes the default run OutputFormat class").build());
            options.addOption(Option.builder((String)"o").argName("output res file").longOpt("output").hasArg().desc("specify the filename of the run will be generated").build());
            options.addOption(Option.builder((String)"s").argName("singleline").longOpt("singleline").desc("use SingleLineTRECQuery to parse the topics").build());
            options.addOption(Option.builder((String)"t").argName("topics").longOpt("topics").hasArg().desc("specify the location of the topics file").build());
            return options;
        }

        public String commandname() {
            return TRECQuerying.BATCHRETRIEVE_COMMAND;
        }

        public Set<String> commandaliases() {
            return Sets.newHashSet((Object[])new String[]{"br", "batchretrieve"});
        }

        public String helpsummary() {
            return "performs a batch retrieval \"run\" over a set of queries";
        }

        public int run(CommandLine line, AbstractQuerying q) throws Exception {
            TRECQuerying tq = (TRECQuerying)q;
            if (line.hasOption("docids")) {
                ApplicationSetup.setProperty((String)"trec.querying.outputformat", (String)TRECDocidOutputFormat.class.getName());
            }
            if (line.hasOption('F')) {
                ApplicationSetup.setProperty((String)"trec.querying.outputformat", (String)line.getOptionValue('F'));
            }
            if (line.hasOption('o')) {
                ApplicationSetup.setProperty((String)"trec.results.file", (String)line.getOptionValue('o'));
            }
            if (line.hasOption('s')) {
                tq.setTopicsParser(SingleLineTRECQuery.class.getName());
            }
            if (line.hasOption('t')) {
                ApplicationSetup.setProperty((String)"trec.topics", (String)line.getOptionValue('t'));
            }
            tq.intialise();
            tq.processQueries();
            IndexUtil.close((Object)((Object)tq));
            return 0;
        }
    }
}

