/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import gnu.trove.TDoubleFunction;
import gnu.trove.TIntDoubleHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.evaluation.TerrierEvaluation;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;
import org.terrier.utility.Rounding;

public class AdhocEvaluation
extends TerrierEvaluation {
    protected static final Logger logger = LoggerFactory.getLogger(AdhocEvaluation.class);
    protected static final int[] PRECISION_RANKS = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 30, 50, 100, 200, 500, 1000};
    protected static final int[] PRECISION_PERCENTAGES = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
    protected int maxNumberRetrieved;
    protected int numberOfEffQuery;
    protected int totalNumberOfRetrieved;
    protected int totalNumberOfRelevant;
    protected int totalNumberOfRelevantRetrieved;
    protected TIntDoubleHashMap precisionAtRank = new TIntDoubleHashMap();
    protected TIntDoubleHashMap precisionAtRecall = new TIntDoubleHashMap();
    protected double meanAveragePrecision;
    protected double meanRelevantPrecision;
    protected double[] averagePrecisionOfEachQuery;
    protected String[] queryNo;

    public AdhocEvaluation() {
    }

    public AdhocEvaluation(String qrelsFile) {
        super(qrelsFile);
    }

    public AdhocEvaluation(String[] qrelsFiles) {
        super(qrelsFiles);
    }

    public void initialise() {
        this.maxNumberRetrieved = Integer.parseInt(ApplicationSetup.getProperty((String)"max.number.retrieved", (String)"1000"));
        this.precisionAtRank.clear();
        this.precisionAtRecall.clear();
        this.numberOfEffQuery = 0;
        this.totalNumberOfRetrieved = 0;
        this.totalNumberOfRelevant = 0;
        this.meanAveragePrecision = 0.0;
        this.meanRelevantPrecision = 0.0;
    }

    @Override
    public void evaluate(String resultFilename) {
        int i;
        Object relevantRetrieved;
        this.initialise();
        logger.info("Evaluating result file: " + resultFilename);
        int effQueryCounter = 0;
        int[] numberOfRelevantRetrieved = null;
        int[] numberOfRelevant = null;
        int[] numberOfRetrieved = null;
        Vector<TerrierEvaluation.Record[]> listOfRetrieved = new Vector<TerrierEvaluation.Record[]>();
        Vector<TerrierEvaluation.Record[]> listOfRelevantRetrieved = new Vector<TerrierEvaluation.Record[]>();
        Vector<Integer> vecNumberOfRelevant = new Vector<Integer>();
        Vector<Integer> vecNumberOfRetrieved = new Vector<Integer>();
        Vector<Integer> vecNumberOfRelevantRetrieved = new Vector<Integer>();
        Vector<Object> vecQueryNo = new Vector<Object>();
        try {
            BufferedReader br = Files.openFileReader((String)resultFilename);
            String str = null;
            Object previous = "";
            int numberOfRetrievedCounter = 0;
            int numberOfRelevantRetrievedCounter = 0;
            relevantRetrieved = new Vector();
            Vector<TerrierEvaluation.Record> retrieved = new Vector<TerrierEvaluation.Record>();
            while ((str = br.readLine()) != null) {
                StringTokenizer stk = new StringTokenizer(str);
                Object queryid = stk.nextToken();
                StringBuilder queryNoTmp = new StringBuilder();
                boolean firstNumericChar = false;
                for (int i2 = ((String)queryid).length() - 1; i2 >= 0; --i2) {
                    if (((String)queryid).charAt(i2) >= '0' && ((String)queryid).charAt(i2) <= '9') {
                        queryNoTmp.append(((String)queryid).charAt(i2));
                        firstNumericChar = true;
                        continue;
                    }
                    if (firstNumericChar) break;
                }
                if (!this.qrels.queryExistInQrels((String)(queryid = "" + Integer.parseInt(queryNoTmp.reverse().toString())))) continue;
                stk.nextToken();
                String docID = stk.nextToken();
                int rank = Integer.parseInt(stk.nextToken());
                if (!((String)previous).equals(queryid)) {
                    if (effQueryCounter != 0) {
                        vecNumberOfRetrieved.addElement(numberOfRetrievedCounter);
                        vecNumberOfRelevantRetrieved.addElement(numberOfRelevantRetrievedCounter);
                        listOfRetrieved.addElement(retrieved.toArray(new TerrierEvaluation.Record[retrieved.size()]));
                        listOfRelevantRetrieved.addElement(relevantRetrieved.toArray(new TerrierEvaluation.Record[relevantRetrieved.size()]));
                        numberOfRetrievedCounter = 0;
                        numberOfRelevantRetrievedCounter = 0;
                        retrieved = new Vector();
                        relevantRetrieved = new Vector();
                    }
                    ++effQueryCounter;
                    vecQueryNo.addElement(queryid);
                    vecNumberOfRelevant.addElement(this.qrels.getNumberOfRelevant((String)queryid));
                }
                previous = queryid;
                ++numberOfRetrievedCounter;
                ++this.totalNumberOfRetrieved;
                retrieved.addElement(new TerrierEvaluation.Record((String)queryid, docID, rank));
                if (!this.qrels.isRelevant((String)queryid, docID)) continue;
                relevantRetrieved.addElement(new TerrierEvaluation.Record((String)queryid, docID, rank));
                ++numberOfRelevantRetrievedCounter;
            }
            listOfRelevantRetrieved.addElement(relevantRetrieved.toArray(new TerrierEvaluation.Record[relevantRetrieved.size()]));
            listOfRetrieved.addElement(retrieved.toArray(new TerrierEvaluation.Record[retrieved.size()]));
            vecNumberOfRetrieved.addElement(numberOfRetrievedCounter);
            vecNumberOfRelevantRetrieved.addElement(numberOfRelevantRetrievedCounter);
            br.close();
            this.queryNo = vecQueryNo.toArray(new String[vecQueryNo.size()]);
            numberOfRelevantRetrieved = new int[effQueryCounter];
            numberOfRelevant = new int[effQueryCounter];
            numberOfRetrieved = new int[effQueryCounter];
            this.totalNumberOfRelevant = 0;
            this.totalNumberOfRelevantRetrieved = 0;
            this.totalNumberOfRetrieved = 0;
            for (int i3 = 0; i3 < effQueryCounter; ++i3) {
                numberOfRelevantRetrieved[i3] = (Integer)vecNumberOfRelevantRetrieved.get(i3);
                numberOfRelevant[i3] = (Integer)vecNumberOfRelevant.get(i3);
                numberOfRetrieved[i3] = (Integer)vecNumberOfRetrieved.get(i3);
                this.totalNumberOfRetrieved += numberOfRetrieved[i3];
                this.totalNumberOfRelevant += numberOfRelevant[i3];
                this.totalNumberOfRelevantRetrieved += numberOfRelevantRetrieved[i3];
            }
        }
        catch (IOException e) {
            logger.error("Exception while evaluating", (Throwable)e);
        }
        this.averagePrecisionOfEachQuery = new double[effQueryCounter];
        TIntDoubleHashMap[] precisionAtRankByQuery = new TIntDoubleHashMap[effQueryCounter];
        TIntDoubleHashMap[] precisionAtRecallByQuery = new TIntDoubleHashMap[effQueryCounter];
        for (int i4 = 0; i4 < effQueryCounter; ++i4) {
            precisionAtRankByQuery[i4] = new TIntDoubleHashMap();
            precisionAtRecallByQuery[i4] = new TIntDoubleHashMap();
        }
        double[] ExactPrecision = new double[effQueryCounter];
        double[] RPrecision = new double[effQueryCounter];
        Arrays.fill(ExactPrecision, 0.0);
        Arrays.fill(RPrecision, 0.0);
        this.meanAveragePrecision = 0.0;
        this.meanRelevantPrecision = 0.0;
        this.numberOfEffQuery = effQueryCounter;
        for (i = 0; i < effQueryCounter; ++i) {
            int queryNoTmp;
            int queryid;
            int j;
            relevantRetrieved = (TerrierEvaluation.Record[])listOfRelevantRetrieved.get(i);
            for (j = 0; j < ((TerrierEvaluation.Record[])relevantRetrieved).length; ++j) {
                if (relevantRetrieved[j].rank < numberOfRelevant[i]) {
                    int n = i;
                    RPrecision[n] = RPrecision[n] + 1.0;
                }
                int[] nArray = PRECISION_RANKS;
                queryid = nArray.length;
                for (queryNoTmp = 0; queryNoTmp < queryid; ++queryNoTmp) {
                    int precisionRank = nArray[queryNoTmp];
                    if (relevantRetrieved[j].rank >= precisionRank) continue;
                    precisionAtRankByQuery[i].adjustOrPutValue(precisionRank, 1.0, 1.0);
                }
                int n = i;
                ExactPrecision[n] = ExactPrecision[n] + (double)(j + 1) / (1.0 + (double)relevantRetrieved[j].rank);
                relevantRetrieved[j].precision = (double)(j + 1) / (1.0 + (double)relevantRetrieved[j].rank);
                relevantRetrieved[j].recall = (double)(j + 1) / (double)numberOfRelevant[i];
            }
            for (j = 0; j < ((TerrierEvaluation.Record[])relevantRetrieved).length; ++j) {
                int[] nArray = PRECISION_PERCENTAGES;
                queryid = nArray.length;
                for (queryNoTmp = 0; queryNoTmp < queryid; ++queryNoTmp) {
                    int precisionPercentage = nArray[queryNoTmp];
                    double fraction = (double)precisionPercentage / 100.0;
                    if (!(relevantRetrieved[j].recall >= fraction) || !(relevantRetrieved[j].precision >= precisionAtRecallByQuery[i].get(precisionPercentage))) continue;
                    precisionAtRecallByQuery[i].put(precisionPercentage, relevantRetrieved[j].precision);
                }
            }
            if (numberOfRelevant[i] > 0) {
                int n = i;
                ExactPrecision[n] = ExactPrecision[n] / (double)numberOfRelevant[i];
            } else {
                --this.numberOfEffQuery;
            }
            if (numberOfRelevant[i] > 0) {
                int n = i;
                RPrecision[n] = RPrecision[n] / (double)numberOfRelevant[i];
            }
            this.meanAveragePrecision += ExactPrecision[i];
            this.averagePrecisionOfEachQuery[i] = ExactPrecision[i];
            this.meanRelevantPrecision += RPrecision[i];
            int[] j2 = PRECISION_RANKS;
            int n = j2.length;
            for (queryid = 0; queryid < n; ++queryid) {
                int precisionRank = j2[queryid];
                this.precisionAtRank.adjustOrPutValue(precisionRank, precisionAtRankByQuery[i].get(precisionRank) / (double)precisionRank, precisionAtRankByQuery[i].get(precisionRank) / (double)precisionRank);
            }
        }
        for (i = 0; i < effQueryCounter; ++i) {
            for (int precisionRecall : PRECISION_PERCENTAGES) {
                this.precisionAtRecall.adjustOrPutValue(precisionRecall, precisionAtRecallByQuery[i].get(precisionRecall), precisionAtRecallByQuery[i].get(precisionRecall));
            }
        }
        final double numberOfEffQueryD = this.numberOfEffQuery;
        TDoubleFunction meanTransformer = new TDoubleFunction(){

            public double execute(double value) {
                return value / numberOfEffQueryD;
            }
        };
        this.precisionAtRecall.transformValues(meanTransformer);
        this.precisionAtRank.transformValues(meanTransformer);
        this.meanAveragePrecision /= (double)this.numberOfEffQuery;
        this.meanRelevantPrecision /= (double)this.numberOfEffQuery;
    }

    @Override
    public void writeEvaluationResultOfEachQuery(String resultEvalFilename) {
        try {
            PrintWriter out = new PrintWriter(Files.writeFileWriter((String)resultEvalFilename));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.queryNo.length; ++i) {
                sb.append(this.queryNo[i] + " " + Rounding.toString((double)this.averagePrecisionOfEachQuery[i], (int)4) + ApplicationSetup.EOL);
            }
            out.print(sb.toString());
            out.close();
        }
        catch (IOException fnfe) {
            logger.error("Couldn't create evaluation file " + resultEvalFilename, (Throwable)fnfe);
        }
    }

    @Override
    public void writeEvaluationResult(PrintWriter out) {
        out.println("____________________________________");
        out.println("Number of queries  = " + this.numberOfEffQuery);
        out.println("Retrieved          = " + this.totalNumberOfRetrieved);
        out.println("Relevant           = " + this.totalNumberOfRelevant);
        out.println("Relevant retrieved = " + this.totalNumberOfRelevantRetrieved);
        out.println("____________________________________");
        out.println("Average Precision: " + Rounding.toString((double)this.meanAveragePrecision, (int)4));
        out.println("R Precision      : " + Rounding.toString((double)this.meanRelevantPrecision, (int)4));
        out.println("____________________________________");
        for (int precisionRank : PRECISION_RANKS) {
            out.printf("Precision at   %d : %s\n", precisionRank, Rounding.toString((double)this.precisionAtRank.get(precisionRank), (int)4));
        }
        out.println("____________________________________");
        for (int precisionPercent : PRECISION_PERCENTAGES) {
            out.printf("Precision at   %d%%: %s\n", precisionPercent, Rounding.toString((double)this.precisionAtRecall.get(precisionPercent), (int)4));
        }
        out.println("____________________________________");
        out.println("Average Precision: " + Rounding.toString((double)this.meanAveragePrecision, (int)4));
        System.out.println("Average Precision: " + Rounding.toString((double)this.meanAveragePrecision, (int)4));
    }
}

