/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import gnu.trove.TDoubleFunction;
import gnu.trove.TIntDoubleHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.evaluation.AdhocEvaluation;
import org.terrier.evaluation.TRECQrelsInMemory;
import org.terrier.evaluation.TerrierEvaluation;
import org.terrier.utility.Files;

public class AdhocFullQueryEvaluation
extends AdhocEvaluation {
    protected static final Logger logger = LoggerFactory.getLogger(AdhocFullQueryEvaluation.class);

    public AdhocFullQueryEvaluation() {
    }

    public AdhocFullQueryEvaluation(String qrelsFile) {
        super(qrelsFile);
    }

    public AdhocFullQueryEvaluation(String[] qrelsFiles) {
        super(qrelsFiles);
    }

    public void evaluate(String qrelsFilename, String resultFilename) {
        int i;
        Object relevantRetrieved;
        this.initialise();
        logger.info("Evaluating result file: " + resultFilename);
        logger.info("Using qrel file: " + qrelsFilename);
        TRECQrelsInMemory qrels = new TRECQrelsInMemory(qrelsFilename);
        int effQueryCounter = 0;
        int[] numberOfRelevantRetrieved = null;
        int[] numberOfRelevant = null;
        int[] numberOfRetrieved = null;
        Vector<TerrierEvaluation.Record[]> listOfRetrieved = new Vector<TerrierEvaluation.Record[]>();
        Vector<TerrierEvaluation.Record[]> listOfRelevantRetrieved = new Vector<TerrierEvaluation.Record[]>();
        Vector<Integer> vecNumberOfRelevant = new Vector<Integer>();
        Vector<Integer> vecNumberOfRetrieved = new Vector<Integer>();
        Vector<Integer> vecNumberOfRelevantRetrieved = new Vector<Integer>();
        Vector<String> vecQueryNo = new Vector<String>();
        this.precisionAtRank.clear();
        this.precisionAtRecall.clear();
        try {
            BufferedReader br = Files.openFileReader((String)resultFilename);
            String str = null;
            String previous = "";
            int numberOfRetrievedCounter = 0;
            int numberOfRelevantRetrievedCounter = 0;
            relevantRetrieved = new Vector();
            Vector<TerrierEvaluation.Record> retrieved = new Vector<TerrierEvaluation.Record>();
            while ((str = br.readLine()) != null) {
                StringTokenizer stk = new StringTokenizer(str);
                String queryid = stk.nextToken();
                StringBuilder queryNoTmp = new StringBuilder();
                for (int i2 = 0; i2 < queryid.length(); ++i2) {
                    if (queryid.charAt(i2) < '0' || queryid.charAt(i2) > '9') continue;
                    queryNoTmp.append(queryid.charAt(i2));
                }
                queryid = queryNoTmp.toString();
                if (!qrels.queryExistInQrels(queryid)) continue;
                stk.nextToken();
                String docID = stk.nextToken();
                int rank = Integer.parseInt(stk.nextToken());
                if (!previous.equals(queryid)) {
                    if (effQueryCounter != 0) {
                        vecNumberOfRetrieved.addElement(numberOfRetrievedCounter);
                        vecNumberOfRelevantRetrieved.addElement(numberOfRelevantRetrievedCounter);
                        listOfRetrieved.addElement(retrieved.toArray(new TerrierEvaluation.Record[retrieved.size()]));
                        listOfRelevantRetrieved.addElement(relevantRetrieved.toArray(new TerrierEvaluation.Record[relevantRetrieved.size()]));
                        numberOfRetrievedCounter = 0;
                        numberOfRelevantRetrievedCounter = 0;
                        retrieved = new Vector();
                        relevantRetrieved = new Vector();
                    }
                    ++effQueryCounter;
                    vecQueryNo.addElement(queryid);
                    vecNumberOfRelevant.addElement(qrels.getNumberOfRelevant(queryid));
                }
                previous = queryid;
                ++numberOfRetrievedCounter;
                ++this.totalNumberOfRetrieved;
                retrieved.addElement(new TerrierEvaluation.Record(queryid, docID, rank));
                if (!qrels.isRelevant(queryid, docID)) continue;
                relevantRetrieved.addElement(new TerrierEvaluation.Record(queryid, docID, rank));
                ++numberOfRelevantRetrievedCounter;
            }
            listOfRelevantRetrieved.addElement(relevantRetrieved.toArray(new TerrierEvaluation.Record[relevantRetrieved.size()]));
            listOfRetrieved.addElement(retrieved.toArray(new TerrierEvaluation.Record[retrieved.size()]));
            vecNumberOfRetrieved.addElement(numberOfRetrievedCounter);
            vecNumberOfRelevantRetrieved.addElement(numberOfRelevantRetrievedCounter);
            br.close();
            this.queryNo = vecQueryNo.toArray(new String[vecQueryNo.size()]);
            numberOfRelevantRetrieved = new int[effQueryCounter];
            numberOfRelevant = new int[effQueryCounter];
            numberOfRetrieved = new int[effQueryCounter];
            for (int i3 = 0; i3 < effQueryCounter; ++i3) {
                numberOfRelevantRetrieved[i3] = (Integer)vecNumberOfRelevantRetrieved.get(i3);
                numberOfRelevant[i3] = (Integer)vecNumberOfRelevant.get(i3);
                numberOfRetrieved[i3] = (Integer)vecNumberOfRetrieved.get(i3);
            }
        }
        catch (IOException e) {
            logger.error("Exception while evaluating", (Throwable)e);
        }
        this.averagePrecisionOfEachQuery = new double[effQueryCounter];
        TIntDoubleHashMap[] precisionAtRankByQuery = new TIntDoubleHashMap[effQueryCounter];
        TIntDoubleHashMap[] precisionAtRecallByQuery = new TIntDoubleHashMap[effQueryCounter];
        for (int i4 = 0; i4 < effQueryCounter; ++i4) {
            precisionAtRankByQuery[i4] = new TIntDoubleHashMap();
            precisionAtRecallByQuery[i4] = new TIntDoubleHashMap();
        }
        double[] ExactPrecision = new double[effQueryCounter];
        double[] RPrecision = new double[effQueryCounter];
        this.meanAveragePrecision = 0.0;
        this.meanRelevantPrecision = 0.0;
        this.numberOfEffQuery = effQueryCounter;
        for (i = 0; i < effQueryCounter; ++i) {
            int queryNoTmp;
            int queryid;
            int j;
            relevantRetrieved = (TerrierEvaluation.Record[])listOfRelevantRetrieved.get(i);
            for (j = 0; j < ((TerrierEvaluation.Record[])relevantRetrieved).length; ++j) {
                if (relevantRetrieved[j].rank < numberOfRelevant[i]) {
                    int n = i;
                    RPrecision[n] = RPrecision[n] + 1.0;
                }
                int[] nArray = PRECISION_RANKS;
                queryid = nArray.length;
                for (queryNoTmp = 0; queryNoTmp < queryid; ++queryNoTmp) {
                    int precisionRank = nArray[queryNoTmp];
                    if (relevantRetrieved[j].rank > precisionRank) continue;
                    precisionAtRankByQuery[i].adjustOrPutValue(precisionRank, 1.0, 1.0);
                }
                int n = i;
                ExactPrecision[n] = ExactPrecision[n] + (double)(j + 1) / (1.0 + (double)relevantRetrieved[j].rank);
                relevantRetrieved[j].precision = (double)(j + 1) / (1.0 + (double)relevantRetrieved[j].rank);
                relevantRetrieved[j].recall = (double)(j + 1) / (double)numberOfRelevant[i];
            }
            for (j = 0; j < ((TerrierEvaluation.Record[])relevantRetrieved).length; ++j) {
                int[] nArray = PRECISION_PERCENTAGES;
                queryid = nArray.length;
                for (queryNoTmp = 0; queryNoTmp < queryid; ++queryNoTmp) {
                    int precisionPercentage = nArray[queryNoTmp];
                    double fraction = (double)precisionPercentage / 100.0;
                    if (!(relevantRetrieved[j].recall >= fraction) || !(relevantRetrieved[j].precision >= precisionAtRecallByQuery[i].get(precisionPercentage))) continue;
                    precisionAtRecallByQuery[i].adjustOrPutValue(precisionPercentage, relevantRetrieved[j].precision, relevantRetrieved[j].precision);
                }
            }
            if (numberOfRelevant[i] > 0) {
                int n = i;
                ExactPrecision[n] = ExactPrecision[n] / (double)numberOfRelevant[i];
            } else {
                --this.numberOfEffQuery;
            }
            if (numberOfRelevant[i] > 0) {
                int n = i;
                RPrecision[n] = RPrecision[n] / (double)numberOfRelevant[i];
            }
            this.meanAveragePrecision += ExactPrecision[i];
            this.averagePrecisionOfEachQuery[i] = ExactPrecision[i];
            this.meanRelevantPrecision += RPrecision[i];
            int[] j2 = PRECISION_RANKS;
            int n = j2.length;
            for (queryid = 0; queryid < n; ++queryid) {
                int precisionRank = j2[queryid];
                this.precisionAtRank.adjustOrPutValue(precisionRank, precisionAtRankByQuery[i].get(precisionRank) / (double)precisionRank, precisionAtRankByQuery[i].get(precisionRank) / (double)precisionRank);
            }
        }
        for (i = 0; i < effQueryCounter; ++i) {
            for (int precisionRecall : PRECISION_PERCENTAGES) {
                this.precisionAtRecall.adjustOrPutValue(precisionRecall, precisionAtRecallByQuery[i].get(precisionRecall), precisionAtRecallByQuery[i].get(precisionRecall));
            }
        }
        final double numberOfEffQueryD = this.numberOfEffQuery;
        TDoubleFunction meanTransformer = new TDoubleFunction(){

            public double execute(double value) {
                return value / numberOfEffQueryD;
            }
        };
        this.precisionAtRecall.transformValues(meanTransformer);
        this.precisionAtRank.transformValues(meanTransformer);
        this.meanAveragePrecision /= (double)this.numberOfEffQuery;
        this.meanRelevantPrecision /= (double)this.numberOfEffQuery;
    }
}

