/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.terrier.applications.CLITool;
import org.terrier.evaluation.AdhocEvaluation;
import org.terrier.evaluation.Evaluation;
import org.terrier.evaluation.TrecEvalEvaluation;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;

public class BatchEvaluationCommand
extends CLITool.CLIParsedCLITool {
    public String helpsummary() {
        return "evaluate all run result files in the results directory";
    }

    public String commandname() {
        return "batchevaluate";
    }

    public Set<String> commandaliases() {
        return Sets.newHashSet((Object[])new String[]{"be"});
    }

    public String sourcepackage() {
        return "platform";
    }

    public int run(CommandLine line) throws Exception {
        Evaluation te = null;
        Object evaluationFilename = null;
        boolean use_jtrec_eval = true;
        boolean overwrite = false;
        boolean evaluation_per_query = false;
        String qrels = ApplicationSetup.getProperty((String)"trec.qrels", null);
        if (line.hasOption('q')) {
            qrels = line.getOptionValue('q');
        }
        if (qrels == null) {
            System.err.println("No qrels specified in property trec.qrels or on command line (-q)");
            return 1;
        }
        if (line.hasOption('f')) {
            overwrite = true;
        }
        if (line.hasOption('p')) {
            evaluation_per_query = true;
        }
        if (line.hasOption('j')) {
            use_jtrec_eval = false;
        }
        if (use_jtrec_eval && TrecEvalEvaluation.isPlatformSupported()) {
            te = new TrecEvalEvaluation(qrels);
        } else {
            if (use_jtrec_eval) {
                System.err.println("Sorry, your platform is not supported by jtrec_eval; resorting to older Terrier evaluation");
            }
            te = new AdhocEvaluation(qrels);
        }
        String[] nomefile = null;
        if (line.getArgs().length > 0) {
            nomefile = line.getArgs();
        }
        if (nomefile == null) {
            File fresdirectory = new File(ApplicationSetup.TREC_RESULTS);
            nomefile = fresdirectory.list();
            if (nomefile == null) {
                nomefile = new String[]{};
            }
        } else {
            nomefile = new String[]{evaluationFilename};
        }
        for (int i = 0; i < nomefile.length; ++i) {
            String evaluationResultFilename;
            if (!nomefile[i].endsWith(".res")) continue;
            Object resultFilename = ApplicationSetup.TREC_RESULTS + "/" + nomefile[i];
            if (nomefile[i].indexOf("/") >= 0) {
                resultFilename = nomefile[i];
            }
            if (Files.exists((String)(evaluationResultFilename = ((String)resultFilename).substring(0, ((String)resultFilename).lastIndexOf(46)) + ".eval")) && !overwrite) {
                System.err.println("Skipping overwriting the existing .eval file" + evaluationResultFilename + " - use -f to force re-evaluation.");
                continue;
            }
            te.evaluate((String)resultFilename);
            if (evaluation_per_query) {
                te.writeEvaluationResultOfEachQuery(evaluationResultFilename);
                continue;
            }
            te.writeEvaluationResult(evaluationResultFilename);
        }
        return 0;
    }

    protected Options getOptions() {
        Options options = super.getOptions();
        options.addOption(Option.builder((String)"j").argName("no_jtreceval").longOpt("jtreceval").desc("disable use of jtreceval, using instead Terrier's in-built evaluation package.").build());
        options.addOption(Option.builder((String)"p").argName("perquery").longOpt("perquery").desc("report results on a per-query basis").build());
        options.addOption(Option.builder((String)"f").argName("force").longOpt("force").desc("force the re-evaluation of .res file that have already been evaluated").build());
        options.addOption(Option.builder((String)"q").argName("qrels").longOpt("qrels").desc("specify location of qrels file.").hasArg().build());
        return options;
    }
}

