/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import gnu.trove.TIntDoubleHashMap;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.terrier.evaluation.TerrierEvaluation;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;
import org.terrier.utility.Rounding;

public class NamedPageEvaluation
extends TerrierEvaluation {
    protected double arr;
    protected int numberOfQueries;
    protected TIntIntHashMap rankRelevantDocument;
    protected int inTop50;
    protected int inTop20;
    protected int inTop10;
    protected int inTop5;
    protected int inTop1;
    protected int notInTop50;
    protected TIntHashSet queryNumbers;
    protected TIntDoubleHashMap recipRank;

    @Override
    public void evaluate(String resultFilename) {
        logger.info("Result file: " + resultFilename);
        this.queryNumbers = new TIntHashSet();
        this.recipRank = new TIntDoubleHashMap();
        this.arr = 0.0;
        this.inTop50 = 0;
        this.inTop20 = 0;
        this.inTop10 = 0;
        this.inTop1 = 0;
        this.notInTop50 = 0;
        this.rankRelevantDocument = new TIntIntHashMap();
        int previousQueryId = -1;
        try {
            int rank;
            BufferedReader br = Files.openFileReader((String)resultFilename);
            String line = null;
            boolean foundRelevantForQuery = false;
            while ((line = br.readLine()) != null) {
                int firstSpaceIndex = line.indexOf(32);
                String queryIdString = line.substring(0, firstSpaceIndex);
                int secondSpaceIndex = line.indexOf(32, firstSpaceIndex + 1);
                int thirdSpaceIndex = line.indexOf(32, secondSpaceIndex + 1);
                String docno = line.substring(secondSpaceIndex + 1, thirdSpaceIndex);
                int fourthSpaceIndex = line.indexOf(32, thirdSpaceIndex + 1);
                String rankString = line.substring(thirdSpaceIndex + 1, fourthSpaceIndex);
                rank = new Integer(rankString) + 1;
                StringBuilder queryNoTmp = new StringBuilder();
                boolean firstNumericChar = false;
                for (int i = queryIdString.length() - 1; i >= 0; --i) {
                    if (queryIdString.charAt(i) >= '0' && queryIdString.charAt(i) <= '9') {
                        queryNoTmp.append(queryIdString.charAt(i));
                        firstNumericChar = true;
                        continue;
                    }
                    if (firstNumericChar) break;
                }
                int queryId = Integer.parseInt(queryNoTmp.reverse().toString());
                if (!this.qrels.queryExistInQrels(queryIdString)) continue;
                if (previousQueryId != queryId) {
                    this.queryNumbers.add(queryId);
                    foundRelevantForQuery = false;
                    this.rankRelevantDocument.put(queryId, 0);
                }
                previousQueryId = queryId;
                if (foundRelevantForQuery || !this.qrels.isRelevant(queryIdString, docno) || this.rankRelevantDocument.get(queryId) > 0) continue;
                this.rankRelevantDocument.put(queryId, rank);
                foundRelevantForQuery = true;
            }
            this.numberOfQueries = this.queryNumbers.size();
            int[] queryids = this.queryNumbers.toArray();
            for (int i = 0; i < this.rankRelevantDocument.size(); ++i) {
                rank = this.rankRelevantDocument.get(queryids[i]);
                if (rank > 0 && rank <= 50) {
                    ++this.inTop50;
                }
                if (rank > 0 && rank <= 20) {
                    ++this.inTop20;
                }
                if (rank > 0 && rank <= 10) {
                    ++this.inTop10;
                }
                if (rank > 0 && rank <= 5) {
                    ++this.inTop5;
                }
                if (rank > 0 && rank == 1) {
                    ++this.inTop1;
                }
                if (rank > 0 && rank > 50) {
                    ++this.notInTop50;
                }
                if (rank == 0) {
                    ++this.notInTop50;
                }
                if (rank <= 0 || rank > 50) continue;
                this.arr += 1.0 / (1.0 * (double)rank);
                this.recipRank.put(queryids[i], 1.0 / (1.0 * (double)rank));
            }
            br.close();
        }
        catch (IOException ioe) {
            logger.error("An error occured while reading the relevance assessments. Stack trace follows.", (Throwable)ioe);
        }
    }

    @Override
    public void writeEvaluationResultOfEachQuery(String resultEvalFilename) {
        int[] queryids = this.queryNumbers.toArray();
        Arrays.sort(queryids);
        try {
            PrintWriter out = new PrintWriter(Files.writeFileWriter((String)resultEvalFilename));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.queryNumbers.size(); ++i) {
                sb.append(queryids[i] + " " + Rounding.toString((double)this.recipRank.get(queryids[i]), (int)4) + ApplicationSetup.EOL);
            }
            out.print(sb.toString());
            out.close();
        }
        catch (IOException fnfe) {
            logger.error("Couldn't write evaluation file " + resultEvalFilename, (Throwable)fnfe);
        }
    }

    @Override
    public void writeEvaluationResult(PrintWriter out) {
        int[] queryids = this.queryNumbers.toArray();
        Arrays.sort(queryids);
        for (int i = 0; i < this.rankRelevantDocument.size(); ++i) {
            int rank = this.rankRelevantDocument.get(queryids[i]);
            if (rank == 0 || rank > 50) {
                out.println("for query " + queryids[i] + " no relevant document was found.");
                continue;
            }
            out.println("for query " + queryids[i] + " 1st Relevant document at rank " + rank);
        }
        out.println("Average Reciprocal Rank: " + this.arr / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of answers found in the first rank: " + (double)this.inTop1 / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of answers found among the top 5 documents: " + (double)this.inTop5 / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of answers found among the top 10 documents: " + (double)this.inTop10 / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of answers found among the top 20 documents: " + (double)this.inTop20 / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of answers found among the top 50 documents: " + (double)this.inTop50 / (1.0 * (double)this.numberOfQueries));
        out.println("Percentage of documents not found in top 50 documents: " + (double)this.notInTop50 / (1.0 * (double)this.numberOfQueries));
        logger.info("Average Reciprocal Rank: " + this.arr / (1.0 * (double)this.numberOfQueries));
    }
}

