/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.ArrayUtils;
import org.terrier.utility.Files;

public class TRECQrelsInMemory {
    protected static final Logger logger = LoggerFactory.getLogger(TRECQrelsInMemory.class);
    public QrelsHashSet[] qrelsPerQuery;
    Map<String, QrelsHashSet> qid2qrels = new HashMap<String, QrelsHashSet>();
    protected File[] fqrels;
    public int totalNumberOfRelevantDocs;

    public TRECQrelsInMemory(String qrelsFilename) {
        this.fqrels = new File[1];
        this.fqrels[0] = new File(qrelsFilename);
        this.loadQrelsFile();
    }

    public TRECQrelsInMemory(String[] qrelsFilenames) {
        this.fqrels = new File[qrelsFilenames.length];
        for (int i = 0; i < qrelsFilenames.length; ++i) {
            this.fqrels[i] = new File(qrelsFilenames[i]);
        }
        this.loadQrelsFile();
    }

    public String[] getQueryids() {
        String[] queryids = new String[this.getNumberOfQueries()];
        for (int i = 0; i < this.getNumberOfQueries(); ++i) {
            queryids[i] = this.qrelsPerQuery[i].queryid;
        }
        return queryids;
    }

    public String[] getRelevantDocuments(int[] grades) {
        THashSet docnoSet = new THashSet();
        for (int i = 0; i < grades.length; ++i) {
            String[] docnos = this.getRelevantDocumentsToArray(grades[i]);
            int N = docnos.length;
            for (int j = 0; j < N; ++j) {
                docnoSet.add((Object)docnos[j]);
            }
        }
        return (String[])docnoSet.toArray((Object[])new String[docnoSet.size()]);
    }

    public THashSet<String> getAllRelevantDocuments() {
        THashSet docnos = new THashSet();
        String[] queryids = this.getQueryids();
        for (int i = 0; i < queryids.length; ++i) {
            String[] docnosTmp = this.getRelevantDocumentsToArray(queryids[i]);
            if (docnosTmp == null) continue;
            for (int j = 0; j < docnosTmp.length; ++j) {
                docnos.add((Object)docnosTmp[j]);
            }
        }
        return docnos;
    }

    public THashSet<String> getRelevantDocuments(int grade) {
        THashSet docnos = new THashSet();
        String[] queryids = this.getQueryids();
        for (int i = 0; i < queryids.length; ++i) {
            String[] docnosTmp = this.getRelevantDocumentsToArray(queryids[i], grade);
            if (docnosTmp == null) continue;
            for (int j = 0; j < docnosTmp.length; ++j) {
                docnos.add((Object)docnosTmp[j]);
            }
        }
        return docnos;
    }

    public String[] getAllRelevantDocumentsToArray() {
        THashSet docnos = new THashSet();
        String[] queryids = this.getQueryids();
        for (int i = 0; i < queryids.length; ++i) {
            String[] docnosTmp = this.getRelevantDocumentsToArray(queryids[i]);
            if (docnosTmp == null) continue;
            for (int j = 0; j < docnosTmp.length; ++j) {
                docnos.add((Object)docnosTmp[j]);
            }
        }
        return (String[])docnos.toArray((Object[])new String[docnos.size()]);
    }

    public String[] getRelevantDocumentsToArray(int grade) {
        THashSet docnos = new THashSet();
        String[] queryids = this.getQueryids();
        for (int i = 0; i < queryids.length; ++i) {
            String[] docnosTmp = this.getRelevantDocumentsToArray(queryids[i], grade);
            if (docnosTmp == null) continue;
            for (int j = 0; j < docnosTmp.length; ++j) {
                docnos.add((Object)docnosTmp[j]);
            }
        }
        return (String[])docnos.toArray((Object[])new String[docnos.size()]);
    }

    public TRECQrelsInMemory() {
        try {
            String[] files = ArrayUtils.parseCommaDelimitedString((String)ApplicationSetup.getProperty((String)"trec.qrels", (String)""));
            if (files.length == 0) {
                throw new IllegalArgumentException("No relevance assessments specified in property trec.qrels");
            }
            this.fqrels = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                this.fqrels[i] = new File(files[i]);
            }
            this.loadQrelsFile();
        }
        catch (Exception ioe) {
            logger.error("Problem loading relevance assessments from property trec.qrels :", (Throwable)ioe);
            return;
        }
    }

    public THashSet<String> getNonRelevantDocuments(String queryid) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set == null) {
            return null;
        }
        return (THashSet)set.nonRelDocnos.clone();
    }

    public THashSet<String> getNonRelevantDocuments() {
        THashSet docnoSet = new THashSet();
        int numberOfQueries = this.getNumberOfQueries();
        for (int i = 0; i < numberOfQueries; ++i) {
            THashSet<String> tmpSet = this.qrelsPerQuery[i].nonRelDocnos;
            String[] docnos = (String[])tmpSet.toArray((Object[])new String[tmpSet.size()]);
            int N = docnos.length;
            for (int j = 0; j < N; ++j) {
                docnoSet.add((Object)docnos[j]);
            }
        }
        return docnoSet;
    }

    public String[] getNonRelevantDocumentsToArray() {
        THashSet<String> docnoSet = this.getNonRelevantDocuments();
        return (String[])docnoSet.toArray((Object[])new String[docnoSet.size()]);
    }

    public THashSet<String> getRelevantDocuments(String queryid) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set == null) {
            return null;
        }
        return set.getAllRelevantDocuments();
    }

    public THashSet<String> getRelevantDocuments(String queryid, int grade) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set == null) {
            return null;
        }
        return set.getRelevantDocuments(grade);
    }

    public THashSet<String> getRelevantDocuments(String queryid, int[] grades) {
        THashSet docnoSet = new THashSet();
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set == null) {
            return docnoSet;
        }
        for (int j = 0; j < grades.length; ++j) {
            String[] docnos = set.getRelevantDocumentsToArray(grades[j]);
            if (docnos == null) continue;
            int N = docnos.length;
            for (int k = 0; k < N; ++k) {
                docnoSet.add((Object)docnos[k]);
            }
        }
        return docnoSet;
    }

    public String[] getRelevantDocumentsToArray(String queryid, int[] grades) {
        THashSet<String> docnoSet = this.getRelevantDocuments(queryid, grades);
        return (String[])docnoSet.toArray((Object[])new String[docnoSet.size()]);
    }

    public String[] getNonRelevantDocumentsToArray(String queryid) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set != null) {
            return (String[])set.nonRelDocnos.toArray((Object[])new String[set.nonRelDocnos.size()]);
        }
        return null;
    }

    public String[] getRelevantDocumentsToArray(String queryid) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set != null) {
            return set.getAllRelevantDocumentsToArray();
        }
        return null;
    }

    public String[] getRelevantDocumentsToArray(String queryid, int grade) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set != null) {
            return set.getRelevantDocumentsToArray(grade);
        }
        return null;
    }

    public int getNumberOfQueries() {
        return this.qrelsPerQuery.length;
    }

    public int getNumberOfRelevant(String queryid) {
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set != null) {
            return set.getAllRelevantDocuments().size();
        }
        return 0;
    }

    protected void loadQrelsFile() {
        ArrayList<QrelsHashSet> vector = new ArrayList<QrelsHashSet>();
        int linenumber = 0;
        String file = null;
        try {
            int qrelsCounter = 0;
            file = this.fqrels[0].toString();
            BufferedReader br = Files.openFileReader((String)file);
            String preQueryid = "1st";
            linenumber = 0;
            QrelsHashSet qrelsHashSet = null;
            String str = null;
            while ((str = br.readLine()) != null || qrelsCounter != this.fqrels.length - 1) {
                boolean relevant;
                if (str == null) {
                    br.close();
                    file = this.fqrels[++qrelsCounter].toString();
                    br = Files.openFileReader((String)file);
                    linenumber = 0;
                    continue;
                }
                ++linenumber;
                if (str.startsWith("#") || str.trim().length() == 0) continue;
                StringTokenizer stk = new StringTokenizer(str);
                String queryid = TRECQrelsInMemory.parseTRECQueryNo(stk.nextToken());
                stk.nextToken();
                String docno = stk.nextToken();
                int relGrade = Integer.parseInt(stk.nextToken());
                boolean bl = relevant = relGrade > 0;
                if (!queryid.equals(preQueryid)) {
                    if (preQueryid.equals("1st")) {
                        qrelsHashSet = new QrelsHashSet(queryid);
                        if (relevant) {
                            qrelsHashSet.insertRelDocno(docno, relGrade);
                        } else {
                            qrelsHashSet.insertNonRelDocno(docno);
                        }
                        preQueryid = queryid;
                        continue;
                    }
                    vector.add((QrelsHashSet)qrelsHashSet.clone());
                    qrelsHashSet = new QrelsHashSet(queryid);
                    if (relevant) {
                        qrelsHashSet.insertRelDocno(docno, relGrade);
                    } else {
                        qrelsHashSet.insertNonRelDocno(docno);
                    }
                    preQueryid = queryid;
                    continue;
                }
                if (relevant) {
                    qrelsHashSet.insertRelDocno(docno, relGrade);
                    continue;
                }
                qrelsHashSet.insertNonRelDocno(docno);
            }
            vector.add((QrelsHashSet)qrelsHashSet.clone());
            br.close();
        }
        catch (Exception t) {
            logger.error("Problem parsing qrels file " + file + " line " + linenumber, (Throwable)t);
            throw new Error(t);
        }
        this.qrelsPerQuery = vector.toArray(new QrelsHashSet[vector.size()]);
        this.totalNumberOfRelevantDocs = 0;
        for (QrelsHashSet querySet : this.qrelsPerQuery) {
            this.qid2qrels.put(querySet.queryid, querySet);
            this.totalNumberOfRelevantDocs += querySet.getAllRelevantDocuments().size();
        }
    }

    public static String parseTRECQueryNo(String queryid) {
        StringBuilder queryNoTmp = new StringBuilder();
        boolean firstNumericChar = false;
        for (int i = queryid.length() - 1; i >= 0; --i) {
            char ch = queryid.charAt(i);
            if (Character.isDigit(ch)) {
                queryNoTmp.append(queryid.charAt(i));
                firstNumericChar = true;
                continue;
            }
            if (firstNumericChar) break;
        }
        queryid = String.valueOf(Integer.parseInt(queryNoTmp.reverse().toString()));
        return queryid;
    }

    public boolean queryExistInQrels(String queryid) {
        return this.qid2qrels.containsKey(queryid);
    }

    public boolean isRelevant(String queryid, String docno) {
        boolean relevant = false;
        QrelsHashSet set = this.qid2qrels.get(queryid);
        if (set != null) {
            relevant = set.isRelevant(docno);
        }
        return relevant;
    }

    public int getGrade(String qid, String docno, int def) {
        int grade = def;
        QrelsHashSet set = this.qid2qrels.get(qid);
        if (set != null) {
            grade = set.getGrade(docno, def);
        }
        return grade;
    }

    public static class QrelsHashSet
    implements Cloneable {
        public String queryid = "";
        public TIntHashSet relGrade;
        public THashSet<String> nonRelDocnos;
        public TIntObjectHashMap<THashSet<String>> relGradeDocnosMap;

        public QrelsHashSet(String _queryid) {
            this.queryid = _queryid;
            this.nonRelDocnos = new THashSet();
            this.relGrade = new TIntHashSet();
            this.relGradeDocnosMap = new TIntObjectHashMap();
        }

        public Object clone() {
            QrelsHashSet dup;
            try {
                dup = (QrelsHashSet)super.clone();
            }
            catch (CloneNotSupportedException e) {
                dup = new QrelsHashSet(this.queryid);
            }
            dup.queryid = this.queryid;
            dup.nonRelDocnos = (THashSet)this.nonRelDocnos.clone();
            dup.relGrade = (TIntHashSet)this.relGrade.clone();
            dup.relGradeDocnosMap = this.relGradeDocnosMap.clone();
            return dup;
        }

        public boolean isRelevant(String docno) {
            int[] grades = this.relGrade.toArray();
            int numOfGrades = grades.length;
            for (int i = 0; i < numOfGrades; ++i) {
                if (!((THashSet)this.relGradeDocnosMap.get(grades[i])).contains((Object)docno)) continue;
                return true;
            }
            return false;
        }

        public int getGrade(String docno, int def) {
            int[] grades = this.relGrade.toArray();
            int numOfGrades = grades.length;
            for (int i = 0; i < numOfGrades; ++i) {
                if (((THashSet)this.relGradeDocnosMap.get(grades[i])).contains((Object)docno)) {
                    return grades[i];
                }
                if (!this.nonRelDocnos.contains((Object)docno)) continue;
                return 0;
            }
            return def;
        }

        public String[] getAllRelevantDocumentsToArray() {
            THashSet docnos = new THashSet();
            int[] grades = this.relGrade.toArray();
            for (int i = 0; i < this.relGrade.size(); ++i) {
                THashSet docnosTmp = (THashSet)this.relGradeDocnosMap.get(grades[i]);
                String[] docnosArray = (String[])docnosTmp.toArray((Object[])new String[docnosTmp.size()]);
                for (int j = 0; j < docnosArray.length; ++j) {
                    docnos.add((Object)docnosArray[j]);
                }
            }
            return (String[])docnos.toArray((Object[])new String[docnos.size()]);
        }

        public THashSet<String> getAllRelevantDocuments() {
            THashSet docnos = new THashSet();
            int[] grades = this.relGrade.toArray();
            for (int i = 0; i < this.relGrade.size(); ++i) {
                THashSet docnosTmp = (THashSet)this.relGradeDocnosMap.get(grades[i]);
                String[] docnosArray = (String[])docnosTmp.toArray((Object[])new String[docnosTmp.size()]);
                for (int j = 0; j < docnosArray.length; ++j) {
                    docnos.add((Object)docnosArray[j]);
                }
            }
            return docnos;
        }

        public String[] getRelevantDocumentsToArray(int grade) {
            if (!this.relGrade.contains(grade)) {
                return null;
            }
            THashSet docnos = (THashSet)this.relGradeDocnosMap.get(grade);
            return (String[])docnos.toArray((Object[])new String[docnos.size()]);
        }

        public THashSet<String> getRelevantDocuments(int grade) {
            if (!this.relGrade.contains(grade)) {
                return null;
            }
            return (THashSet)this.relGradeDocnosMap.get(grade);
        }

        public void insertRelDocno(String docno, int grade) {
            if (!this.relGrade.contains(grade)) {
                this.relGrade.add(grade);
                THashSet gradeDocnos = new THashSet();
                gradeDocnos.add((Object)docno);
                this.relGradeDocnosMap.put(grade, (Object)gradeDocnos);
            } else {
                ((THashSet)this.relGradeDocnosMap.get(grade)).add((Object)docno);
            }
        }

        public void insertNonRelDocno(String docno) {
            this.nonRelDocnos.add((Object)docno);
        }
    }
}

