/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.evaluation.Evaluation;
import org.terrier.evaluation.TRECQrelsInMemory;
import org.terrier.utility.Files;

public abstract class TerrierEvaluation
implements Evaluation {
    protected static final Logger logger = LoggerFactory.getLogger(TerrierEvaluation.class);
    public TRECQrelsInMemory qrels;

    protected TerrierEvaluation() {
        this.qrels = new TRECQrelsInMemory();
    }

    protected TerrierEvaluation(String qrelsFile) {
        this.qrels = new TRECQrelsInMemory(qrelsFile);
    }

    protected TerrierEvaluation(String[] qrelsFiles) {
        this.qrels = new TRECQrelsInMemory(qrelsFiles);
    }

    @Override
    public abstract void evaluate(String var1);

    @Override
    public void writeEvaluationResult() {
        this.writeEvaluationResult(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    @Override
    public abstract void writeEvaluationResult(PrintWriter var1);

    @Override
    public abstract void writeEvaluationResultOfEachQuery(String var1);

    @Override
    public void writeEvaluationResult(String resultEvalFilename) {
        try {
            PrintWriter out = new PrintWriter(Files.writeFileWriter((String)resultEvalFilename));
            this.writeEvaluationResult(out);
            out.close();
        }
        catch (IOException fnfe) {
            logger.error("File not found exception occurred when trying to write to file" + resultEvalFilename, (Throwable)fnfe);
        }
    }

    public static class Record {
        String queryNo;
        int rank;
        String docNo;
        double precision;
        double recall;

        public Record(String _queryNo, String _docNo, int _rank) {
            this.queryNo = _queryNo;
            this.rank = _rank;
            this.docNo = _docNo;
        }

        public int getRank() {
            return this.rank;
        }

        public void setRank(int _rank) {
            this.rank = _rank;
        }

        public String getDocNo() {
            return this.docNo;
        }

        public void setQueryNo(String _queryNo) {
            this.queryNo = _queryNo;
        }

        public String getQueryNo() {
            return this.queryNo;
        }
    }
}

