/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.evaluation;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.applications.CLITool;
import org.terrier.evaluation.Evaluation;
import org.terrier.utility.ArrayUtils;
import org.terrier.utility.Files;
import org.terrier.utility.Rounding;
import uk.ac.gla.terrier.jtreceval.trec_eval;

public class TrecEvalEvaluation
implements Evaluation {
    protected static final Logger logger = LoggerFactory.getLogger(TrecEvalEvaluation.class);
    String qrels;
    protected String[][] output;
    String resFile;

    public TrecEvalEvaluation(String[] qrels) {
        this.qrels = qrels[0];
        if (qrels.length != 1) {
            throw new IllegalArgumentException("Only one qrels file can be specified");
        }
        if (!TrecEvalEvaluation.isPlatformSupported()) {
            throw new UnsupportedOperationException("Your platform is not currently supported by jtreceval");
        }
    }

    public TrecEvalEvaluation(String qrels) {
        this.qrels = qrels;
    }

    @Override
    public void evaluate(String resultFilename) {
        logger.info("Evaluating result file: " + resultFilename);
        this.resFile = resultFilename;
        String[] args = new String[]{this.qrels, this.resFile};
        this.output = new trec_eval().runAndGetOutput(args);
    }

    @Override
    public void writeEvaluationResult() {
        this.writeEvaluationResult(new PrintWriter(new OutputStreamWriter(System.out)));
    }

    @Override
    public void writeEvaluationResult(PrintWriter out) {
        for (String[] line : this.output) {
            if (line.length >= 3 && line[0].equals("map") && line[1].equals("all")) {
                System.out.println("Average Precision: " + Rounding.toString((double)Double.parseDouble(line[2]), (int)4));
            }
            out.println(ArrayUtils.join((String[])line, (char)'\t'));
        }
    }

    @Override
    public void writeEvaluationResultOfEachQuery(String evaluationResultFilename) {
        String[] args = new String[]{"-q", this.qrels, this.resFile};
        this.output = new trec_eval().runAndGetOutput(args);
        this.writeEvaluationResult(evaluationResultFilename);
    }

    @Override
    public void writeEvaluationResult(String resultEvalFilename) {
        try {
            PrintWriter pw = new PrintWriter(Files.writeFileWriter((String)resultEvalFilename));
            this.writeEvaluationResult(pw);
            pw.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static boolean isPlatformSupported() {
        try {
            if (!trec_eval.isPlatformSupported()) {
                return false;
            }
        }
        catch (UnsupportedOperationException uoe) {
            return false;
        }
        return true;
    }

    public static class Command
    extends CLITool {
        public String commandname() {
            return "trec_eval";
        }

        public Set<String> commandaliases() {
            return Sets.newHashSet((Object[])new String[]{"treceval"});
        }

        public String help() {
            new trec_eval().run(new String[]{"-h"});
            return "";
        }

        public String helpsummary() {
            return "runs the NIST standard trec_eval tool";
        }

        public int run(String[] args) throws Exception {
            new trec_eval().run(args);
            return 0;
        }

        public String sourcepackage() {
            return "platform";
        }
    }
}

