/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.matching;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.matching.CollectionResultSet;
import org.terrier.matching.Matching;
import org.terrier.matching.MatchingQueryTerms;
import org.terrier.matching.ResultSet;
import org.terrier.matching.dsms.DocumentScoreModifier;
import org.terrier.structures.CollectionStatistics;
import org.terrier.structures.Index;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;
import org.terrier.utility.HeapSort;

public class TRECResultsMatching
implements Matching {
    protected static final Pattern SPLIT_SPACE_PLUS = Pattern.compile("\\s+");
    protected Index index;
    protected CollectionStatistics collStats;
    protected static final String DSMNS = "org.terrier.matching.dsms.";
    protected List<DocumentScoreModifier> dsms;
    protected String filename;
    protected BufferedReader reader;
    protected InputFormat format;
    protected final boolean parseScores;
    protected final int maxResults;
    protected String qid;
    protected ResultSet rs;
    protected int docid;
    protected double score;
    protected boolean found;
    protected boolean reset;
    protected Logger logger = LoggerFactory.getLogger(TRECResultsMatching.class);

    public TRECResultsMatching(Index _index) throws IOException {
        this(_index, ApplicationSetup.getProperty((String)"matching.trecresults.file", (String)""), ApplicationSetup.getProperty((String)"matching.dsms", (String)""));
    }

    public TRECResultsMatching(Index _index, String _filename) throws IOException {
        this(_index, _filename, ApplicationSetup.getProperty((String)"matching.dsms", (String)""));
    }

    public TRECResultsMatching(Index _index, String _filename, String defDSMs) throws IOException {
        this.index = _index;
        this.collStats = _index.getCollectionStatistics();
        this.initDSMs(defDSMs);
        this.filename = _filename;
        this.format = InputFormat.valueOf(ApplicationSetup.getProperty((String)"matching.trecresults.format", (String)"docno").toUpperCase());
        this.parseScores = Boolean.parseBoolean(ApplicationSetup.getProperty((String)"matching.trecresults.scores", (String)"true"));
        this.maxResults = Integer.parseInt(ApplicationSetup.getProperty((String)"matching.trecresults.length", (String)"1000"));
        this.reopen();
    }

    protected void reopen() throws IOException {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.reader = Files.openFileReader((String)this.filename);
        this.logger.info(this.getClass().getSimpleName() + " opened " + this.filename);
    }

    /*
     * WARNING - void declaration
     */
    protected void initDSMs(String defDSMs) {
        this.dsms = new ArrayList<DocumentScoreModifier>();
        try {
            for (String string : defDSMs.split("\\s*,\\s*")) {
                void var5_6;
                if (string.length() == 0) continue;
                if (string.indexOf(46) == -1) {
                    String string2 = DSMNS + string;
                }
                this.dsms.add(ApplicationSetup.getClass((String)var5_6).asSubclass(DocumentScoreModifier.class).newInstance());
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while initialising default modifiers. Please check the name of the modifiers in the configuration file.", (Throwable)e);
        }
    }

    public String getInfo() {
        return this.getClass().getSimpleName() + "(" + this.filename + ")";
    }

    protected int getDocid(String docno) throws IOException {
        if (this.format.equals((Object)InputFormat.DOCNO)) {
            return this.index.getMetaIndex().getDocument("docno", docno);
        }
        return Integer.parseInt(docno);
    }

    protected boolean read(String _qid) throws IOException {
        while (true) {
            this.reader.mark(1024);
            String line = this.reader.readLine();
            if (line == null) {
                this.qid = null;
                if (!this.found && !this.reset) {
                    this.reopen();
                    this.reset = true;
                    continue;
                }
                return false;
            }
            String[] parts = SPLIT_SPACE_PLUS.split(line.trim());
            this.qid = parts[0];
            this.docid = this.getDocid(parts[2]);
            if (this.parseScores) {
                this.score = Double.parseDouble(parts[4]);
            }
            if (parts[0].equals(_qid)) {
                if (!this.checkValid()) continue;
                this.found = true;
                return true;
            }
            if (this.found) break;
        }
        this.reader.reset();
        return false;
    }

    protected boolean checkValid() {
        return true;
    }

    public ResultSet match(String _qid, MatchingQueryTerms mqt) throws IOException {
        int matched;
        int max = this.collStats.getNumberOfDocuments();
        if (this.maxResults > 0) {
            max = this.maxResults;
        }
        this.initialise(max);
        int[] docids = this.rs.getDocids();
        double[] scores = this.rs.getScores();
        this.found = false;
        this.reset = false;
        for (matched = 0; this.read(_qid) && matched < max; ++matched) {
            docids[matched] = this.docid;
            scores[matched] = this.score;
        }
        if (_qid.equals(this.qid)) {
            this.logger.warn("Found more than " + max + " results for query " + _qid);
        }
        this.rs.setExactResultSize(matched);
        this.rs.setResultSize(matched);
        this.rs = this.rs.getResultSet(0, matched);
        docids = this.rs.getDocids();
        scores = this.rs.getScores();
        int numDSMs = this.dsms.size();
        this.logger.info("Applying " + numDSMs + " DSMs to query " + _qid);
        for (int t = 0; t < numDSMs; ++t) {
            if (!this.dsms.get(t).modifyScores(this.index, mqt, this.rs)) continue;
            HeapSort.descendingHeapSort((double[])scores, (int[])docids, (short[])this.rs.getOccurrences(), (int)this.rs.getResultSize());
        }
        this.logger.debug(this.getClass().getSimpleName() + " ranked " + matched + " documents in response to query " + _qid);
        return this.rs;
    }

    public void setCollectionStatistics(CollectionStatistics _collStats) {
        this.collStats = _collStats;
    }

    public CollectionStatistics getCollectionStatistics() {
        return this.collStats;
    }

    protected void initialise(int max) {
        this.rs = new CollectionResultSet(max);
        this.rs.initialise();
    }

    protected void finalize() throws Throwable {
        this.reader.close();
    }

    public static enum InputFormat {
        DOCNO,
        DOCID;

    }
}

