/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.querying;

import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.querying.FeedbackDocument;
import org.terrier.querying.FeedbackSelector;
import org.terrier.querying.Request;
import org.terrier.structures.Index;
import org.terrier.structures.MetaIndex;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;

public class RelevanceFeedbackSelector
extends FeedbackSelector {
    protected static final Logger logger = LoggerFactory.getLogger(RelevanceFeedbackSelector.class);
    protected MetaIndex metaIndex;
    protected THashMap<String, List<FeedbackWithDocno>> queryidRelDocumentMap;

    public RelevanceFeedbackSelector() {
        String feedbackFilename = ApplicationSetup.getProperty((String)"qe.feedback.filename", (String)(ApplicationSetup.TERRIER_ETC + ApplicationSetup.FILE_SEPARATOR + "feedback"));
        this.loadRelevanceInformation(feedbackFilename);
    }

    public void setIndex(Index index) {
        this.metaIndex = index.getMetaIndex();
    }

    public FeedbackDocument[] getFeedbackDocuments(Request request) {
        String queryid = request.getQueryID();
        List list = (List)this.queryidRelDocumentMap.get((Object)queryid);
        if (list == null) {
            return new FeedbackDocument[0];
        }
        if (list.size() == 0) {
            return new FeedbackDocument[0];
        }
        ArrayList<FeedbackWithDocno> rtrList = new ArrayList<FeedbackWithDocno>(list.size());
        for (FeedbackWithDocno doc : list) {
            try {
                doc.docid = this.metaIndex.getDocument("docno", doc.docno);
            }
            catch (IOException ioe) {
                logger.warn("IOException while looking for docid for feedback document " + doc.docno + " of query " + request.getQueryID(), (Throwable)ioe);
            }
            if (doc.docid < 0) {
                logger.warn("Could not find docid for feedback document " + doc.docno + " of query " + request.getQueryID());
                continue;
            }
            doc.score = -1.0;
            doc.rank = -1;
            logger.info("(" + (rtrList.size() + 1) + ") Feedback document:" + doc.docno);
            rtrList.add(doc);
        }
        logger.info("Found " + rtrList.size() + " feedback documents for query " + request.getQueryID());
        return rtrList.toArray(new FeedbackDocument[0]);
    }

    private void loadRelevanceInformation(String filename) {
        logger.info("Loading relevance feedback assessments from " + filename);
        try {
            this.queryidRelDocumentMap = new THashMap();
            BufferedReader br = Files.openFileReader((String)filename);
            String line = null;
            int assessmentsCount = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                String[] parts = line.split("\\s+");
                FeedbackWithDocno doc = new FeedbackWithDocno();
                doc.docno = parts[2];
                doc.relevance = Byte.parseByte(parts[3]);
                ArrayList<FeedbackWithDocno> list = (ArrayList<FeedbackWithDocno>)this.queryidRelDocumentMap.get((Object)parts[0]);
                if (list == null) {
                    list = new ArrayList<FeedbackWithDocno>();
                    this.queryidRelDocumentMap.put((Object)parts[0], list);
                }
                list.add(doc);
                ++assessmentsCount;
            }
            br.close();
            logger.info("Total " + assessmentsCount + " assessments found");
        }
        catch (IOException ioe) {
            logger.error("Problem loading relevance feedback assessments from " + filename, (Throwable)ioe);
        }
    }

    static class FeedbackWithDocno
    extends FeedbackDocument {
        String docno;

        FeedbackWithDocno() {
        }

        public boolean equals(Object y) {
            if (!(y instanceof FeedbackDocument)) {
                return false;
            }
            FeedbackWithDocno o = (FeedbackWithDocno)((Object)y);
            if (this.docno.equals(o.docno)) {
                return true;
            }
            return this.docid == o.docid;
        }

        public int hashCode() {
            return this.docno.hashCode();
        }
    }
}

