/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.querying;

import gnu.trove.THashMap;
import gnu.trove.TIntByteHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.querying.FeedbackDocument;
import org.terrier.querying.FeedbackSelector;
import org.terrier.querying.Request;
import org.terrier.structures.DocumentIndex;
import org.terrier.structures.Index;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.Files;

public class RelevanceFeedbackSelectorDocids
extends FeedbackSelector {
    protected static final Logger logger = LoggerFactory.getLogger(RelevanceFeedbackSelectorDocids.class);
    protected DocumentIndex doi;
    protected THashMap<String, TIntByteHashMap> queryidRelDocumentMap;

    public RelevanceFeedbackSelectorDocids() {
        String feedbackFilename = ApplicationSetup.getProperty((String)"qe.feedback.filename", (String)(ApplicationSetup.TERRIER_ETC + ApplicationSetup.FILE_SEPARATOR + "feedback"));
        this.loadRelevanceInformation(feedbackFilename);
    }

    public void setIndex(Index index) {
        this.doi = index.getDocumentIndex();
    }

    public FeedbackDocument[] getFeedbackDocuments(Request request) {
        String queryid = request.getQueryID();
        TIntByteHashMap list = (TIntByteHashMap)this.queryidRelDocumentMap.get((Object)queryid);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return new FeedbackDocument[0];
        }
        ArrayList<FeedbackDocument> rtrList = new ArrayList<FeedbackDocument>(list.size());
        for (int id : list.keys()) {
            FeedbackDocument doc = new FeedbackDocument();
            doc.docid = id;
            doc.score = -1.0;
            doc.rank = -1;
            doc.relevance = list.get(id);
            rtrList.add(doc);
        }
        logger.info("Found " + rtrList.size() + " feedback documents for query " + request.getQueryID());
        return rtrList.toArray(new FeedbackDocument[0]);
    }

    private void loadRelevanceInformation(String filename) {
        logger.info("Loading relevance feedback assessments from " + filename);
        try {
            this.queryidRelDocumentMap = new THashMap();
            BufferedReader br = Files.openFileReader((String)filename);
            String line = null;
            int assessmentsCount = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                String[] parts = line.split("\\s+");
                TIntByteHashMap list = (TIntByteHashMap)this.queryidRelDocumentMap.get((Object)parts[0]);
                if (list == null) {
                    list = new TIntByteHashMap();
                    this.queryidRelDocumentMap.put((Object)parts[0], (Object)list);
                }
                list.put(Integer.parseInt(parts[2]), Byte.parseByte(parts[3]));
                ++assessmentsCount;
            }
            br.close();
            logger.info("Total " + assessmentsCount + " assessments found");
        }
        catch (IOException ioe) {
            logger.error("Problem loading relevance feedback assessments from " + filename, (Throwable)ioe);
        }
    }
}

