/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.querying;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.querying.FeedbackDocument;
import org.terrier.querying.FeedbackSelector;
import org.terrier.querying.Request;
import org.terrier.structures.Index;

public class RelevantOnlyFeedbackDocuments
extends FeedbackSelector {
    protected static final Logger logger = LoggerFactory.getLogger(RelevantOnlyFeedbackDocuments.class);
    protected final FeedbackSelector parent;

    public RelevantOnlyFeedbackDocuments(FeedbackSelector _parent) {
        this.parent = _parent;
    }

    public void setIndex(Index index) {
        this.parent.setIndex(index);
    }

    public FeedbackDocument[] getFeedbackDocuments(Request request) {
        FeedbackDocument[] parentReturn = this.parent.getFeedbackDocuments(request);
        ArrayList<FeedbackDocument> rtr = new ArrayList<FeedbackDocument>(parentReturn.length);
        for (FeedbackDocument candidateDocument : parentReturn) {
            if (candidateDocument.relevance <= 0) continue;
            rtr.add(candidateDocument);
        }
        logger.info("Dropped " + (parentReturn.length - rtr.size()) + " irrelevant feedback documents");
        return rtr.toArray(new FeedbackDocument[0]);
    }
}

