/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.structures.outputformat;

import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.matching.ResultSet;
import org.terrier.querying.Request;
import org.terrier.querying.SearchRequest;
import org.terrier.structures.Index;
import org.terrier.structures.outputformat.OutputFormat;
import org.terrier.utility.ApplicationSetup;

public class TRECDocidOutputFormat
implements OutputFormat {
    protected static final Logger logger = LoggerFactory.getLogger(TRECDocidOutputFormat.class);

    public TRECDocidOutputFormat(Index index) {
    }

    @Override
    public void printResults(PrintWriter pw, SearchRequest q, String method, String iteration, int _RESULTS_LENGTH) throws IOException {
        ResultSet set = ((Request)q).getResultSet();
        int[] docids = set.getDocids();
        double[] scores = set.getScores();
        if (set.getResultSize() == 0) {
            logger.warn("No results retrieved for query " + q.getQueryID());
            return;
        }
        int maximum = _RESULTS_LENGTH > set.getResultSize() || _RESULTS_LENGTH == 0 ? set.getResultSize() : _RESULTS_LENGTH;
        String queryIdExpanded = q.getQueryID() + " " + iteration + " ";
        String methodExpanded = " " + method + ApplicationSetup.EOL;
        StringBuilder sbuffer = new StringBuilder();
        int limit = 10000;
        int counter = 0;
        for (int i = 0; i < maximum; ++i) {
            if (scores[i] == Double.NEGATIVE_INFINITY) continue;
            sbuffer.append(queryIdExpanded);
            sbuffer.append(docids[i]);
            sbuffer.append(" ");
            sbuffer.append(i);
            sbuffer.append(" ");
            sbuffer.append(scores[i]);
            sbuffer.append(methodExpanded);
            if (++counter % limit != 0) continue;
            pw.write(sbuffer.toString());
            sbuffer = null;
            sbuffer = new StringBuilder();
            pw.flush();
        }
        pw.write(sbuffer.toString());
        pw.flush();
    }
}

