/*
 * Decompiled with CFR 0.152.
 */
package org.terrier.structures.outputformat;

import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terrier.matching.ResultSet;
import org.terrier.querying.Request;
import org.terrier.querying.ScoredDoc;
import org.terrier.querying.ScoredDocList;
import org.terrier.querying.SearchRequest;
import org.terrier.structures.Index;
import org.terrier.structures.MetaIndex;
import org.terrier.structures.outputformat.OutputFormat;
import org.terrier.utility.ApplicationSetup;
import org.terrier.utility.ArrayUtils;

public class TRECDocnoOutputFormat
implements OutputFormat {
    Index index;
    protected static final Logger logger = LoggerFactory.getLogger(TRECDocnoOutputFormat.class);

    public TRECDocnoOutputFormat(Index _index) {
        this.index = _index;
    }

    protected String[] obtainDocnos(String metaIndexDocumentKey, SearchRequest q, ResultSet set) throws IOException {
        MetaIndex metaIndex;
        String[] docnos;
        if (set.hasMetaItems(metaIndexDocumentKey)) {
            docnos = set.getMetaItems(metaIndexDocumentKey);
        } else if (this.index == null && q instanceof Request) {
            metaIndex = ((Request)q).getIndex().getMetaIndex();
            docnos = metaIndex.getItems(metaIndexDocumentKey, set.getDocids());
        } else if (this.index != null) {
            metaIndex = this.index.getMetaIndex();
            docnos = metaIndex.getItems(metaIndexDocumentKey, set.getDocids());
        } else {
            throw new IllegalStateException("Could not obtain meta for key " + metaIndexDocumentKey + " perhaps decorate:on was missing?");
        }
        boolean NDN = false;
        for (int i = 0; i < docnos.length; ++i) {
            if (docnos[i] != null && docnos[i].length() != 0) continue;
            String diagnosticDOCNO = "NDN_DOCID_" + set.getDocids()[i];
            docnos[i] = diagnosticDOCNO;
            NDN = true;
        }
        if (NDN) {
            logger.warn("Not all docnos were found in the meta index during obtainDocnos(), some diagnostic docnos were added. ");
        }
        return docnos;
    }

    void printResults(PrintWriter pw, SearchRequest q, ResultSet set, String method, String iteration, int _RESULTS_LENGTH) throws IOException {
        String metaIndexDocumentKey = ApplicationSetup.getProperty((String)"trec.querying.outputformat.docno.meta.key", (String)"docno");
        double[] scores = set.getScores();
        if (set.getResultSize() == 0) {
            logger.warn("No results retrieved for query " + q.getQueryID());
            return;
        }
        String[] docnos = this.obtainDocnos(metaIndexDocumentKey, q, set);
        int maximum = _RESULTS_LENGTH > set.getResultSize() || _RESULTS_LENGTH == 0 ? set.getResultSize() : _RESULTS_LENGTH;
        logger.debug("Writing " + maximum + " results for query " + q.getQueryID());
        String queryIdExpanded = q.getQueryID() + " " + iteration + " ";
        String methodExpanded = " " + method + ApplicationSetup.EOL;
        StringBuilder sbuffer = new StringBuilder();
        int limit = 10000;
        int counter = 0;
        for (int i = 0; i < maximum; ++i) {
            if (scores[i] == Double.NEGATIVE_INFINITY) continue;
            sbuffer.append(queryIdExpanded);
            sbuffer.append(docnos[i]);
            sbuffer.append(" ");
            sbuffer.append(i);
            sbuffer.append(" ");
            sbuffer.append(scores[i]);
            sbuffer.append(methodExpanded);
            if (++counter % limit != 0) continue;
            pw.write(sbuffer.toString());
            sbuffer = null;
            sbuffer = new StringBuilder();
            pw.flush();
        }
        pw.write(sbuffer.toString());
        pw.flush();
    }

    @Override
    public void printResults(PrintWriter pw, SearchRequest q, String method, String iteration, int _RESULTS_LENGTH) throws IOException {
        String[] docnos;
        String metaIndexDocumentKey = ApplicationSetup.getProperty((String)"trec.querying.outputformat.docno.meta.key", (String)"docno");
        ScoredDocList results = q.getResults();
        int maximum = _RESULTS_LENGTH > results.size() || _RESULTS_LENGTH == 0 ? results.size() : _RESULTS_LENGTH;
        String queryIdExpanded = q.getQueryID() + " " + iteration + " ";
        String methodExpanded = " " + method + ApplicationSetup.EOL;
        StringBuilder sbuffer = new StringBuilder();
        if (ArrayUtils.contains((Object[])results.getMetaKeys(), (Object)metaIndexDocumentKey)) {
            docnos = (String[])results.stream().map(doc -> doc.getMetadata(metaIndexDocumentKey)).toArray(String[]::new);
        } else if (this.index == null && q instanceof Request) {
            MetaIndex metaIndex = ((Request)q).getIndex().getMetaIndex();
            docnos = metaIndex.getItems(metaIndexDocumentKey, results.stream().mapToInt(doc -> doc.getDocid()).toArray());
        } else if (this.index != null) {
            docnos = this.index.getMetaIndex().getItems(metaIndexDocumentKey, results.stream().mapToInt(doc -> doc.getDocid()).toArray());
        } else {
            throw new IllegalStateException("No source for " + metaIndexDocumentKey + " found. Perhaps you need to set control decorate:on");
        }
        int limit = 10000;
        int i = -1;
        for (ScoredDoc doc2 : results) {
            ++i;
            if (doc2.getScore() == Double.NEGATIVE_INFINITY) continue;
            sbuffer.append(queryIdExpanded);
            sbuffer.append(docnos[i]);
            sbuffer.append(" ");
            sbuffer.append(i);
            sbuffer.append(" ");
            sbuffer.append(doc2.getScore());
            sbuffer.append(methodExpanded);
            if (i % limit == 0) {
                pw.write(sbuffer.toString());
                sbuffer = null;
                sbuffer = new StringBuilder();
                pw.flush();
            }
            if (i != maximum) continue;
            break;
        }
        pw.write(sbuffer.toString());
        pw.flush();
    }
}

