/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.client.protocol;

import java.io.IOException;
import java.util.Locale;
import org.testifyproject.apache.http.Header;
import org.testifyproject.apache.http.HeaderElement;
import org.testifyproject.apache.http.HttpEntity;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpResponse;
import org.testifyproject.apache.http.HttpResponseInterceptor;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.client.entity.DeflateDecompressingEntity;
import org.testifyproject.apache.http.client.entity.GzipDecompressingEntity;
import org.testifyproject.apache.http.protocol.HttpContext;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs = ceheader.getElements();
            boolean uncompressed = false;
            int i$ = 0;
            HeaderElement[] arr$ = codecs;
            int len$ = arr$.length;
            if (i$ < len$) {
                HeaderElement codec = arr$[i$];
                String codecname = codec.getName().toLowerCase(Locale.US);
                if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                    response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                    uncompressed = true;
                } else if ("org.testifyprojectflate".equals(codecname)) {
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    uncompressed = true;
                } else {
                    if ("identity".equals(codecname)) {
                        return;
                    }
                    throw new HttpException("Unsupported Content-Coding: " + codec.getName());
                }
            }
            if (uncompressed) {
                response.removeHeaders("Content-Length");
                response.removeHeaders("Content-Encoding");
                response.removeHeaders("Content-MD5");
            }
        }
    }
}

