/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl;

import java.util.Locale;
import org.testifyproject.apache.http.HttpResponse;
import org.testifyproject.apache.http.HttpResponseFactory;
import org.testifyproject.apache.http.ProtocolVersion;
import org.testifyproject.apache.http.ReasonPhraseCatalog;
import org.testifyproject.apache.http.StatusLine;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.impl.EnglishReasonPhraseCatalog;
import org.testifyproject.apache.http.message.BasicHttpResponse;
import org.testifyproject.apache.http.message.BasicStatusLine;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline);
    }

    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline);
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

