/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testifyproject.apache.commons.codec.binary.Base64;
import org.testifyproject.apache.http.Header;
import org.testifyproject.apache.http.HttpHost;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.annotation.NotThreadSafe;
import org.testifyproject.apache.http.auth.AuthenticationException;
import org.testifyproject.apache.http.auth.Credentials;
import org.testifyproject.apache.http.auth.InvalidCredentialsException;
import org.testifyproject.apache.http.auth.MalformedChallengeException;
import org.testifyproject.apache.http.conn.routing.HttpRoute;
import org.testifyproject.apache.http.impl.auth.AuthSchemeBase;
import org.testifyproject.apache.http.message.BufferedHeader;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;
import org.testifyproject.apache.http.util.CharArrayBuffer;
import org.testifyproject.ietf.jgss.GSSContext;
import org.testifyproject.ietf.jgss.GSSException;
import org.testifyproject.ietf.jgss.GSSManager;
import org.testifyproject.ietf.jgss.GSSName;
import org.testifyproject.ietf.jgss.Oid;

@NotThreadSafe
public abstract class GGSSchemeBase
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Base64 base64codec = new Base64(0);
    private final boolean stripPort;
    private State state;
    private byte[] token;

    GGSSchemeBase(boolean stripPort) {
        this.stripPort = stripPort;
        this.state = State.UNINITIATED;
    }

    GGSSchemeBase() {
        this(false);
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer) throws GSSException {
        byte[] token = input;
        if (token == null) {
            token = new byte[]{};
        }
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSContext gssContext = manager.createContext(serverName.canonicalize(oid), oid, null, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return gssContext.initSecContext(token, 0, token.length);
    }

    protected abstract byte[] generateToken(byte[] var1, String var2) throws GSSException;

    public boolean isComplete() {
        return this.state == State.TOKEN_GENERATED || this.state == State.FAILED;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull(request, "HTTP request");
        switch (this.state) {
            case UNINITIATED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has not been initiated");
            }
            case FAILED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                try {
                    HttpHost host;
                    HttpRoute route = (HttpRoute)context.getAttribute("http.route");
                    if (route == null) {
                        throw new AuthenticationException("Connection route is not available");
                    }
                    if (this.isProxy()) {
                        host = route.getProxyHost();
                        if (host == null) {
                            host = route.getTargetHost();
                        }
                    } else {
                        host = route.getTargetHost();
                    }
                    String authServer = !this.stripPort && host.getPort() > 0 ? host.toHostString() : host.getHostName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("init " + authServer));
                    }
                    this.token = this.generateToken(this.token, authServer);
                    this.state = State.TOKEN_GENERATED;
                }
                catch (GSSException gsse) {
                    this.state = State.FAILED;
                    if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 13) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                        throw new AuthenticationException(gsse.getMessage(), gsse);
                    }
                    throw new AuthenticationException(gsse.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                String tokenstr = new String(this.base64codec.encode(this.token));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending response '" + tokenstr + "' back to the auth server"));
                }
                CharArrayBuffer buffer = new CharArrayBuffer(32);
                if (this.isProxy()) {
                    buffer.append("Proxy-Authorization");
                } else {
                    buffer.append("Authorization");
                }
                buffer.append(": Negotiate ");
                buffer.append(tokenstr);
                return new BufferedHeader(buffer);
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.state));
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        String challenge = buffer.substringTrimmed(beginIndex, endIndex);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received challenge '" + challenge + "' from the auth server"));
        }
        if (this.state == State.UNINITIATED) {
            this.token = Base64.decodeBase64(challenge.getBytes());
            this.state = State.CHALLENGE_RECEIVED;
        } else {
            this.log.debug((Object)"Authentication already attempted");
            this.state = State.FAILED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

