/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpHost;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.annotation.ThreadSafe;
import org.testifyproject.apache.http.client.ClientProtocolException;
import org.testifyproject.apache.http.client.config.RequestConfig;
import org.testifyproject.apache.http.client.methods.CloseableHttpResponse;
import org.testifyproject.apache.http.client.methods.Configurable;
import org.testifyproject.apache.http.client.methods.HttpExecutionAware;
import org.testifyproject.apache.http.client.methods.HttpRequestWrapper;
import org.testifyproject.apache.http.client.protocol.HttpClientContext;
import org.testifyproject.apache.http.conn.ClientConnectionManager;
import org.testifyproject.apache.http.conn.ClientConnectionRequest;
import org.testifyproject.apache.http.conn.HttpClientConnectionManager;
import org.testifyproject.apache.http.conn.ManagedClientConnection;
import org.testifyproject.apache.http.conn.routing.HttpRoute;
import org.testifyproject.apache.http.conn.scheme.SchemeRegistry;
import org.testifyproject.apache.http.impl.DefaultConnectionReuseStrategy;
import org.testifyproject.apache.http.impl.client.CloseableHttpClient;
import org.testifyproject.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.testifyproject.apache.http.impl.execchain.MinimalClientExec;
import org.testifyproject.apache.http.params.BasicHttpParams;
import org.testifyproject.apache.http.params.HttpParams;
import org.testifyproject.apache.http.protocol.BasicHttpContext;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.protocol.HttpRequestExecutor;
import org.testifyproject.apache.http.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void close() {
        this.connManager.shutdown();
    }

    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

