/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.impl.cookie;

import java.util.Collection;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.cookie.CookieSpec;
import org.testifyproject.apache.http.cookie.CookieSpecFactory;
import org.testifyproject.apache.http.cookie.CookieSpecProvider;
import org.testifyproject.apache.http.impl.cookie.RFC2109Spec;
import org.testifyproject.apache.http.params.HttpParams;
import org.testifyproject.apache.http.protocol.HttpContext;

@Immutable
public class RFC2109SpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    private final String[] datepatterns;
    private final boolean oneHeader;

    public RFC2109SpecFactory(String[] datepatterns, boolean oneHeader) {
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public RFC2109SpecFactory() {
        this(null, false);
    }

    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            boolean singleHeader = params.getBooleanParameter("http.protocol.single-cookie-header", false);
            return new RFC2109Spec(patterns, singleHeader);
        }
        return new RFC2109Spec();
    }

    public CookieSpec create(HttpContext context) {
        return new RFC2109Spec(this.datepatterns, this.oneHeader);
    }
}

