/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.protocol;

import java.io.IOException;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.HttpRequestInterceptor;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class RequestConnControl
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

