/*
 * Decompiled with CFR 0.152.
 */
package org.testifyproject.apache.http.protocol;

import java.io.IOException;
import org.testifyproject.apache.http.HttpEntity;
import org.testifyproject.apache.http.HttpEntityEnclosingRequest;
import org.testifyproject.apache.http.HttpException;
import org.testifyproject.apache.http.HttpRequest;
import org.testifyproject.apache.http.HttpRequestInterceptor;
import org.testifyproject.apache.http.HttpVersion;
import org.testifyproject.apache.http.ProtocolVersion;
import org.testifyproject.apache.http.annotation.Immutable;
import org.testifyproject.apache.http.protocol.HttpContext;
import org.testifyproject.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

